

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMCreateBkpStatsRecord.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMCreateBkpStatsRecord.sp,v $ $Id: JMCreateBkpStatsRecord.sp,v 1.1.2.6 2018/10/24 14:23:47 sbonilla Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMCreateBkpStatsRecord')
BEGIN
	print '>>> Drop Stored Procedure: JMCreateBkpStatsRecord <<<'
	drop procedure JMCreateBkpStatsRecord
END
IF EXISTS (select * from GxQscripts where name='JMCreateBkpStatsRecord')
	delete from GxQscripts where name = 'JMCreateBkpStatsRecord'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCreateBkpStatsRecord')
	delete from GXDBVersions where aliasname = 'JMCreateBkpStatsRecord'
GO
print '... Creating Procedure: JMCreateBkpStatsRecord'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMCreateBkpStatsRecord
  @jobId BIGINT,   
  @commCellID INTEGER,
  @status INTEGER
AS
  DECLARE @retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @now INTEGER= dbo.GetUnixTime(GetUTCDate())
	DECLARE @scPropTbl TABLE (errCode INT, hasChanged INT, propId INT, errString VARCHAR(MAX) )
	DECLARE @fullCycleNumber INTEGER = 1
	DECLARE @cycleSequence	INTEGER = 1
	DECLARE @unCompBytes BIGINT = 0
	DECLARE @BkpLevel INTEGER
	DECLARE @subClientID INTEGER
	SELECT @BkpLevel = bkpLevel, @subClientID = applicationId, @unCompBytes = unCompBytes
		FROM JMBkpJobInfo WITH(NOLOCK) WHERE jobId = @JobId AND commcellId = @commCellID
	SET @fullCycleNumber = CONVERT(INTEGER,ISNULL((SELECT attrVal FROM APP_SubClientProp WHERE componentNameId = @subClientID AND modified = 0 and cs_attrName = CHECKSUM(N'sys:full cycle num')),1))
	SET @cycleSequence = CONVERT(INTEGER,ISNULL((SELECT attrVal FROM APP_SubClientProp WHERE componentNameId = @subClientID AND modified = 0 and cs_attrName = CHECKSUM(N'sys:non full cycle num')),1))
	IF dbo.IsBackupLevelFull(@bkpLevel) = 1
	BEGIN
		SET @fullCycleNumber = @fullCycleNumber + 1
		SET @cycleSequence = 1
	END
	ELSE
	BEGIN
		SET @cycleSequence = @cycleSequence + 1
	END
	UPDATE JMJobStats
	SET status = 2 /*FINISHED*/
	WHERE jobId = @jobId and commCellId = @commCellID
	INSERT INTO JMBkpStats(jobId,commCellId,appId,appType,numAttempts,dataArchGrpId,copyID,bkpLevel,indexOverride,status,duration,numStreams,servStartDate,servEndDate,opType,fullCycleNum,initFrom,failureReason,bkpOptions,scanFileFailures,scanFolderFailures,backupFileFailures,backupFolderFailures,oraSubLevel,username,totalWriteTime,priority,totalCompBytes,totalUncompBytes,totalNumOfFiles,bkpattributes,logArchGrpId,totalNumOfFolders,failureErrorCode,lastIncrJobTime,scanType,scanTypeChangeReason,numStreamsRequested,dataStatus,agedTime,mediaDeletedTime,modifiedTime,version,idaVersion,cIndexTime,cycleSequence,filesToXfer,cloudId,diffArchGrpId,totalBackupSize,percentageChange,targetClientId,totalUncompBytesToXfer,displayStatus,dataBackedUp,logsBackedUp,openChain,secondaryBkpLevel,jobIdPrepared,jobIdActedOn,fromTime,toTime,subTaskId,nwTransBytes,totSkippedObjects,bkpAttributesEx,jobReferenceTime)
	SELECT jobInfo.jobId				as jobId,
			jobInfo.commcellId			as commCellId,
			id							as appId,
			app.appTypeId				as appType,
			jobInfo.runAttempts			as numAttempts,
			dataArchGrpID				as dataArchGrpId,
			0							as copyID,
			bkpLevel					as bkpLevel,
			indexOverride				as indexOverride,
			@status/*status*/			as status,
			@now - jobInfo.jobStartTime/*duration*/ as duration,
			bkpJobInfo.numStreams		as numStreams,
			jobInfo.jobStartTime		as servStartDate,
			@now as servEndDate,
			4							as opType, /*Make STATELESS_BACKUP as BACKUP in stats*/
			@fullCycleNumber			as fullCycleNum,
			jobInfo.initFrom			as initFrom,
			''							as failureReason,
			bkpJobInfo.bkpOptions		as bkpOptions,
			bkpJobInfo.scanFileFailures as scanFileFailures,
			0							as scanFolderFailures,
			bkpJobInfo.backupFileFailures as backupFileFailures,
			0							as backupFolderFailures,
			bkpJobInfo.oraSubLevel as oraSubLevel,
			jobInfo.opUsername			as username,
			bkpJobInfo.totalMediaUsageTime as totalWriteTime,
			jobInfo.combPriority		as priority,
			bkpJobInfo.compBytes		as totalCompBytes,
			bkpJobInfo.unCompBytes		as totalUncompBytes,
			bkpJobInfo.filesXfered		as totalNumOfFiles,
			bkpJobInfo.bkpattributes	as bkpattributes,
			bkpJobInfo.logPolicy		as logArchGrpId,
			0							as totalNumOfFolders,
			0							as failureErrorCode,
			0							as lastIncrJobTime,
			bkpJobInfo.scanType			as scanType,
			bkpJobInfo.scanTypeChangeReason			as scanTypeChangeReason,
			1							as numStreamsRequested,
			0							as dataStatus,
			0							as agedTime,
			0							as mediaDeletedTime,
			@now						as modifiedTime,
			16							as version,
			1							as idaVersion,
			0							as cIndexTime,
			@cycleSequence				as cycleSequence,
			bkpJobInfo.filesToXfer		as filesToXfer,
			bkpJobInfo.cloudId			as cloudId,
			bkpJobInfo.diffPolicy		as diffArchGrpId,
			0							as totalBackupSize,
			0							as percentageChange,
			0							as targetClientId,
			bkpJobInfo.unCompBytesToXfer			as totalUncompBytesToXfer,
			@status						as displayStatus,
			1							as dataBackedUp,
			0							as logsBackedUp,
			0							as openChain,
			0							as secondaryBkpLevel,
			0							as jobIdPrepared,
			0							as jobIdActedOn,
			bkpJobInfo.fromTime			as fromTime,
			bkpJobInfo.toTime			as toTime,
			bkpJobInfo.backupTaskId		as subTaskId,
			bkpJobInfo.nwTransBytes		as nwTransBytes,
			bkpJobInfo.totSkippedObjects			as totSkippedObjects,
			(bkpJobInfo.bkpAttributesEx | 0x10000000)	as bkpAttributesEx, --Add JMBKP_EX_STATELESS_BACKUP
			bkpJobInfo.jobReferenceTime as jobReferenceTime
		   FROM JMJobInfo jobInfo INNER JOIN JMBkpJobInfo bkpJobInfo
				ON jobInfo.jobId = @JobId AND  bkpJobInfo.jobId = @JobId and jobInfo.commCellId = bkpJobInfo.commcellId
					INNER JOIN APP_Application app
						ON bkpJobInfo.applicationId = app.id AND bkpJobInfo.commcellId = app.origCCId
	--Update basic subclient property
	IF dbo.IsBackupLevelFull(@bkpLevel) = 1
	BEGIN
		INSERT INTO @scPropTbl exec AppInsertSubClientProp @subClientID, 0, @now, N'sys:last full',8,@now
		INSERT INTO @scPropTbl exec AppInsertSubClientProp @subClientID, 0, @now, N'turbo:last full',8,@now
		INSERT INTO @scPropTbl exec AppInsertSubClientProp @subClientID, 0, @now, N'sys:last full jobId',8,@JobId
	END
	INSERT INTO @scPropTbl exec AppInsertSubClientProp @subClientID, 0, @now, N'sys:full cycle num',10,@fullCycleNumber
	INSERT INTO @scPropTbl exec AppInsertSubClientProp @subClientID, 0, @now, N'sys:non full cycle num',10,@cycleSequence
	INSERT INTO @scPropTbl exec AppInsertSubClientProp @subClientID, 0, @now, N'sys:last incr',8,@now
	INSERT INTO @scPropTbl exec AppInsertSubClientProp @subClientID, 0, @now, N'turbo:last incr',8,@now
	INSERT INTO @scPropTbl exec AppInsertSubClientProp @subClientID, 0, @now, N'Last Backup Size',14,@unCompBytes
GO

IF EXISTS (select * from GxQscripts where name = 'JMCreateBkpStatsRecord')
	delete from GxQscripts where name = 'JMCreateBkpStatsRecord'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCreateBkpStatsRecord')
	delete from GXDBVersions where aliasname = 'JMCreateBkpStatsRecord'
GO

insert into GXDBVersions values(2, 'JMCreateBkpStatsRecord',  '00010001000200060000', 'JMCreateBkpStatsRecord', '00010001000200060000')
GO

