

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMCreateBkpAttemptStats.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Amey Karandikar
--	Date:   10/03/2005
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMCreateBkpAttemptStats.sp,v $ $Id: JMCreateBkpAttemptStats.sp,v 1.9.210.4 2020/06/28 03:36:33 gstoops Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMCreateBkpAttemptStats')
BEGIN
	print '>>> Drop Stored Procedure: JMCreateBkpAttemptStats <<<'
	drop procedure JMCreateBkpAttemptStats
END
IF EXISTS (select * from GxQscripts where name='JMCreateBkpAttemptStats')
	delete from GxQscripts where name = 'JMCreateBkpAttemptStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCreateBkpAttemptStats')
	delete from GXDBVersions where aliasname = 'JMCreateBkpAttemptStats'
GO
print '... Creating Procedure: JMCreateBkpAttemptStats'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMCreateBkpAttemptStats
  @jobid INTEGER,
  @commcellId INTEGER,
  @modifiedTime INTEGER
AS
  DECLARE @rowsInserted INTEGER
  DECLARE @errorCode INTEGER
	SET NOCOUNT ON
	DECLARE @OneHr FLOAT = 3600
	DECLARE @oneKB FLOAT = 1024
	DECLARE @oneGB FLOAT = (@oneKB * @oneKB* @oneKB)
	INSERT INTO JMBkpAtmptStats
	(jobId, number, phase, elapsedTime, servStartDate, servEndDate,unCompBytes,compBytes,
		numObjects,status,failureReason,writeTime,restartString,attributes,commCellId,numFolders,archGrpId,copyId,maxStreamsUsed,modifiedTime,nwTransBytes,totalAllocationTime,totalWaitTimeBeforeAllocation,
		readThroughput,writeThroughput,networkThroughput,sidbLookups,mediaAgent)
	SELECT jobId, attemptNum, phaseNum, elapsedTime, startTime, endTime, unCompBytes, compBytes,
	numFiles, status, failureReason, writeTime, substring(restartString,1,4096), attributes, @commcellId, numFolders, archGrpId, copyId, maxStreamsUsed, @modifiedTime, nwTransBytes, totalAllocationTime, totalWaitTimeBeforeAllocation,
    CASE WHEN readTime > 0
            THEN (@OneHr / @oneGB) * (CAST(readBytes AS FLOAT)/ CAST(readTime AS FLOAT))
            ELSE 0
            END,
    CASE WHEN physicalWriteTime > 0
            THEN (@OneHr / @oneGB) * (CAST(physicalWriteBytes AS FLOAT)/ CAST(physicalWriteTime AS FLOAT))
            ELSE 0
            END,
    CASE WHEN nwTransTime > 0
            THEN (@OneHr / @oneGB) * (CAST(nwTransBytes AS FLOAT)/ CAST(nwTransTime AS FLOAT))
            ELSE 0
            END,
    CASE WHEN sidbLookupTime > 0
            THEN 1000.0 * (CAST(sidbLookups AS FLOAT)/ CAST(sidbLookupTime AS FLOAT))
            ELSE 0
            END,
        mediaAgent
	FROM JMBkpAttemptInfo WITH (READUNCOMMITTED) WHERE jobId = @jobid
	and commCellId = @commcellId
	SET @rowsInserted	= @@ROWCOUNT
	SET @errorCode		= @@ERROR
	SELECT @rowsInserted, @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'JMCreateBkpAttemptStats')
	delete from GxQscripts where name = 'JMCreateBkpAttemptStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCreateBkpAttemptStats')
	delete from GXDBVersions where aliasname = 'JMCreateBkpAttemptStats'
GO

insert into GXDBVersions values(2, 'JMCreateBkpAttemptStats',  '00010009021000040000', 'JMCreateBkpAttemptStats', '00010009021000040000')
GO

