

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMComputeJobLoadReport.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMComputeJobLoadReport.sp,v $ $Id: JMComputeJobLoadReport.sp,v 1.1.4.3 2021/01/20 02:47:11 abilbrey Exp $";
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMComputeJobLoadReport')
BEGIN
	print '>>> Drop Stored Procedure: JMComputeJobLoadReport <<<'
	drop procedure JMComputeJobLoadReport
END
IF EXISTS (select * from GxQscripts where name='JMComputeJobLoadReport')
	delete from GxQscripts where name = 'JMComputeJobLoadReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMComputeJobLoadReport')
	delete from GXDBVersions where aliasname = 'JMComputeJobLoadReport'
GO
print '... Creating Procedure: JMComputeJobLoadReport'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMComputeJobLoadReport
-- default 0 current UTC End Job Time
  @inStartUTCTime INT = 0,
-- Default is 1 hour and range is 1 to 6 hours max
  @inReportHours TINYINT = 1,
-- 0 result set, 1 XML outputted
  @inXMLOutput TINYINT = 1,
-- 1 returns on the Summary information by default
  @inSummaryOnly TINYINT = 1,
-- 1 computes AppType Statistics
  @inAppTypeStats TINYINT = 0,
-- return XML in output argument only
  @outXMLOutput XML = NULL OUTPUT
AS
BEGIN
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	-- Get SQL Release to determine how to query the local SQL Server
	DECLARE @versionNumber VARCHAR(128) = CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR(128))
	DECLARE @releaseNumber VARCHAR(128) = LEFT(@versionNumber, CHARINDEX('.', @versionNumber) - 1)
	DECLARE @activityST INT
	DECLARE @activityET INT
	DECLARE @rcnt INT
	DECLARE @emsg VARCHAR(255) = ''
	DECLARE @retXML XML
	IF (@inReportHours < 1 OR @inReportHours > 6)
	BEGIN
		SET @emsg = 'JMComputeJobLoadReport: Input Error for @inReportHours[' + CAST(@inReportHours AS VARCHAR(12)) + '] valid input is 1 >= @inReportHours <= 6'
		;THROW 50001, @emsg, 255
		RETURN
	END
	DECLARE @reportWindow INT = @inReportHours * 60 * 60		-- compute total number of seconds
	IF (@inStartUTCTime = 0)
	BEGIN
		SET @activityET = dbo.getUnixTime(GETUTCDATE())	-- Current UTC Time
		SET @activityST = @activityET - @reportWindow	-- Report start job time is an N hours earlier
	END
	ELSE
	BEGIN
		SET @activityST = @inStartUTCTime
		SET @activityET = @activityST + @reportWindow	-- Report end job time is an N hours later
	END
	IF OBJECT_ID('tempdb..#jobs') IS NOT NULL
		DROP TABLE #jobs
	CREATE TABLE #jobs (
		jobId		INT,
		type		TINYINT,		-- 1 backup, 2 restore, 3 admin
		startTime	INT,
		endTime		INT,
		appType		INT				-- admin is opType value - future use
	)
	-- Now get all the JM jobs that are active during this 1 hour window
	INSERT INTO #jobs (jobid, type, startTime, endTime, appType)
		SELECT
			jobId,
			1 [type],
			servStartDate startTime,
			servEndDate endTime,
			appType
		FROM JMBkpStats WITH(NOLOCK)
		WHERE
			(
				(
					servStartDate >= @activityST		-- job started in this window
					AND servStartDate <= @activityET
				)
				OR (
					servEndDate >= @activityST			-- job completed in this window
					AND servEndDate <= @activityET
				)
				OR (
					servStartDate <= @activityST		-- job started before this window
					AND servEndDate >= @activityET		-- job is running in this window and did not complete
				)
			)
		UNION ALL
		SELECT
			jobId,
			2,
			servStartTime,
			servEndTime,
			appType
		FROM JMRestoreStats WITH(NOLOCK)
		WHERE
			(
				(
					servStartTime >= @activityST		-- job started in this window
					AND servStartTime <= @activityET
				)
				OR (
					servEndTime >= @activityST			-- job completed in this window
					AND servEndTime <= @activityET
				)
				OR (
					servStartTime <= @activityST		-- job started before this window
					AND servEndTime >= @activityET		-- job is running in this window and did not complete
				)
			)
		UNION ALL
		SELECT
			jobId,
			3,
			servStart,
			servEnd,
			opType
		FROM JMAdminJobStatsTable WITH(NOLOCK)
		WHERE
			(
				(
					servStart >= @activityST		-- job started in this window
					AND servStart <= @activityET
				)
				OR (
					servEnd >= @activityST			-- job completed in this window
					AND servEnd <= @activityET
				)
				OR (
					servStart <= @activityST		-- job started before this window
					AND servEnd >= @activityET		-- job is running in this window and did not complete
				)
			)
	SET @rcnt = @@ROWCOUNT
	IF (@rcnt = 0)
	BEGIN
		PRINT 'JMComputeJobLoadReport: no data to process'
		RETURN
	END
	IF OBJECT_ID('tempdb..#jobLoadStats') IS NOT NULL
		DROP TABLE #jobLoadStats
	CREATE TABLE #jobLoadStats (
		type		TINYINT,		-- record type: 1 totals, 2 average per Window, 3 max per Window, 4 min per Window, 5 jobWindow
		utcSTime	INT,
		utcETime	INT,
		totalJobs	INT,
		bkupJobs	INT,
		restoreJobs	INT,
		adminJobs	INT,
		appXML		XML NULL DEFAULT NULL,
		PRIMARY KEY (type, utcSTime, utcETime)
	)
	IF OBJECT_ID('tempdb..#jobWindows') IS NOT NULL
		DROP TABLE #jobWindows
	CREATE TABLE #jobWindows (
		winST	INT,
		winET	INT,
		PRIMARY KEY (winST, winET)
	)
	-- Populate Time Window with 1 minute interval rows from the start to the end date and time inputted
	DECLARE @winST INT = @activityST
	DECLARE @winET INT = @winST + 60		-- 1 minute window
	DECLARE @cnt INT = 1
	WHILE (@winST <= @activityET)
	BEGIN
		INSERT INTO #jobWindows (winST, winET)
			VALUES (@winST, @winET)
		SET @winST = @winET
		SET @winET = @winST + 60
	END
	DECLARE @winCnt INT = 0
	SELECT
		@winCnt = COUNT(*)
	FROM #jobWindows w
	-- Create an clustered index on jobs start and end times to improve performance
	CREATE CLUSTERED INDEX jobs_idx  ON #jobs (startTime, endTime)
	INSERT INTO #jobLoadStats (type, utcSTime, utcETime, totalJobs, bkupJobs, restoreJobs, adminJobs)
		SELECT
			5,		-- Job Window row
			w.winST,
			w.winET,
			COUNT(j.jobId) totalJobs,
			SUM(IIF(j.type = 1, 1, 0)) bkupJobs,
			SUM(IIF(j.type = 2, 1, 0)) restoreJobs,
			SUM(IIF(j.type = 3, 1, 0)) adminJobs
		FROM #jobs j
			INNER JOIN #jobWindows w ON
				(
					(
						j.startTime >= w.winST			-- job started in this window
						AND j.startTime <= w.winET
					)
					OR (
						j.endTime >= w.winST			-- job completed in this window
						AND j.endTime <= w.winET
					)
					OR (
						j.startTime <= w.winST			-- job started before this window
						AND j.endTime >= w.winET		-- job is running in this window and did not complete
					)
				)
		GROUP BY
			w.winST,
			w.winET
	-- Populate AppType and OpType stats
	IF (@inAppTypeStats <> 0)
	BEGIN
		UPDATE s
			SET appXML = (
				SELECT
					j.type [@type],
					CASE j.type
						WHEN 1 THEN 'bkup'
						WHEN 2 THEN 'restore'
						ELSE 'admin'
					END [@name],
					IIF((j.type IN (1,2)), j.appType, NULL) [@appType],
					IIF((j.type = 3), j.appType, NULL) [@opType],
					COUNT(j.appType) [@total]
				FROM #jobs j
				WHERE
					(
						(
							j.startTime >= s.utcSTime		-- job started in this window
							AND j.startTime <= s.utcETime
						)
						OR (
							j.endTime >= s.utcSTime			-- job completed in this window
							AND j.endTime <= s.utcETime
						)
						OR (
							j.startTime <= s.utcSTime		-- job started before this window
							AND j.endTime >= s.utcETime		-- job is running in this window and did not complete
						)
					)
				GROUP BY
					j.type,
					j.appType
				ORDER BY
					j.type ASC,
					j.appType ASC
				FOR XML PATH('AppType'), ROOT('AppTypeStats'), TYPE
			)
		FROM #jobLoadStats s
		WHERE s.type = 5
	END
	-- Populate JM Job Load Stats
	INSERT INTO #jobLoadStats (type, utcSTime, utcETime, totalJobs, bkupJobs, restoreJobs, adminJobs)
		SELECT
			1,		-- totals
			@activityST utcStartTime,
			@activityET utcEndTime,
			COUNT(j.jobId) totalJobs,
			SUM(IIF(j.type = 1, 1, 0)) bkupJobs,
			SUM(IIF(j.type = 2, 1, 0)) restoreJobs,
			SUM(IIF(j.type = 3, 1, 0)) adminJobs
		FROM #jobs j
		UNION ALL
		SELECT
			2,		-- averages
			@activityST utcStartTime,
			@activityET utcEndTime,
			AVG(j.totalJobs) totalJobs,
			AVG(j.bkupJobs) bkupJobs,
			AVG(j.restoreJobs) restoreJobs,
			AVG(j.adminJobs) adminJobs
		FROM #jobLoadStats j
		WHERE
			j.type = 5
		UNION ALL
		SELECT
			3,		-- max
			@activityST utcStartTime,
			@activityET utcEndTime,
			MAX(j.totalJobs) totalJobs,
			MAX(j.bkupJobs) bkupJobs,
			MAX(j.restoreJobs) restoreJobs,
			MAX(j.adminJobs) adminJobs
		FROM #jobLoadStats j
		UNION ALL
		SELECT
			4,		-- min
			@activityST utcStartTime,
			@activityET utcEndTime,
			MIN(j.totalJobs) totalJobs,
			MIN(j.bkupJobs) bkupJobs,
			MIN(j.restoreJobs) restoreJobs,
			MIN(j.adminJobs) adminJobs
		FROM #jobLoadStats j
	IF OBJECT_ID('TempDb..#AppTypeStats') IS NOT NULL
		DROP TABLE #AppTypeStats
	CREATE TABLE #AppTypeStats (
		[type]		TINYINT,
		[appType]	INT,
		[avg]		INT,
		[max]		INT,
		[min]		INT,
		PRIMARY KEY ([type], [appType])
	)
	IF (@inAppTypeStats <> 0)
	BEGIN
		INSERT INTO #AppTypeStats
			SELECT
				q1.type,
				q1.appType,
				AVG(q1.total) [avg],
				MAX(q1.total) [max],
				MIN(q1.total) [min]
			FROM (
					SELECT
						a.value('@type', 'INT') [type],
						ISNULL(a.value('@appType', 'INT'), 	a.value('@opType', 'INT')) [appType],
						a.value('@total', 'INT') [total]
					FROM #jobLoadStats s
						CROSS APPLY s.appXML.nodes('/AppTypeStats/AppType') t(a)
				) q1
			GROUP BY
				q1.type,
				q1.appType
		UPDATE s
			SET appXML = (
				SELECT
					a.type [@type],
					CASE a.type
						WHEN 1 THEN 'bkup'
						WHEN 2 THEN 'restore'
						ELSE 'admin'
					END [@name],
					IIF((a.type IN (1,2)), a.appType, NULL) [@appType],
					IIF((a.type = 3), a.appType, NULL) [@opType],
					CASE s.type
						WHEN 2 THEN a.[avg]
						WHEN 3 THEN a.[max]
						WHEN 4 THEN a.[min]
						ELSE NULL
					END [@total]
				FROM #AppTypeStats a
				FOR XML PATH('AppType'), ROOT('AppTypeStats'), TYPE
			)
		FROM #jobLoadStats s
		WHERE s.type IN (2, 3, 4)		-- avg, max, min summary rows
	END
	-- Compute Bucket Counts
	DECLARE @max INT
	SELECT
		@max = s.totalJobs
	FROM  #jobLoadStats s
	WHERE s.type = 3		-- max row
	DECLARE @bucketNum INT = 0
	SET @bucketNum = CASE
							WHEN @max < 500 THEN 5
							WHEN @max >= 500 AND @max < 1000 THEN 7
							WHEN @max >= 1000 THEN 11
						END
	DECLARE @bucketWindows TABLE (
		[bucket]	INT,
		[start]		INT,
		[end]		INT,
		[total]		INT DEFAULT 0,
		PRIMARY KEY ([start], [end], [bucket])
	)
	DECLARE @bucketSize INT = 0
	DECLARE @bucketXML XML
	-- Compute Bucket Windows
	IF (@bucketNum <> 0)
	BEGIN
		SET @bucketSize = @max / @bucketNum
		DECLARE @startBucket INT = 0
		DECLARE @endBucket INT = @bucketSize
		SET @cnt = 0
		WHILE (@cnt < @bucketNum)
		BEGIN
			INSERT INTO @bucketWindows ([bucket], [start], [end])
				VALUES (@cnt, @startBucket, @endBucket)
			SET @startBucket = @endBucket
			SET @endBucket = @endBucket + @bucketSize
			SET @cnt += 1
			-- last bucket
			IF ((@cnt + 1) = @bucketNum)
			BEGIN
				-- Set to max for rounding error and add 1 to pickup max bucket in query below for < operator
				SET @endBucket = @max + 1
			END
		END
		UPDATE b
			SET b.[total] = q.[total]
		FROM (
				SELECT
					b.[start],
					b.[end],
					COUNT(1) total
				FROM @bucketWindows b
					INNER JOIN #jobLoadStats s ON
						s.totalJobs >= b.[start]
						AND s.totalJobs < b.[end]
				WHERE s.type = 5
				GROUP BY
					b.[start],
					b.[end]
		) q
		INNER JOIN @bucketWindows b ON
			b.[start] = q.[start]
			AND b.[end] = q.[end]
		SET @bucketXML = (
			SELECT
				@bucketNum [@buckets],
				(
					SELECT
						b.[bucket] [@bucket],
						b.[start] [@start],
						b.[end] [@end],
						b.[total] [@total]
					FROM @bucketWindows b
					FOR XML PATH('Bucket'), TYPE
				)
				FOR XML PATH('Distribution'), TYPE
		)
	END
	-- Output only the requested information
	IF (@inXMLOutput = 0)
	BEGIN
		IF (@inSummaryOnly = 1)
		BEGIN
			SELECT
				CASE
					WHEN q.type = 1 THEN 'Totals'
					WHEN q.type = 2 THEN 'Averages per Window'
					WHEN q.type = 3 THEN 'Max per Window'
					WHEN q.type = 4 THEN 'Min per Window'
					ELSE NULL
				END record,
				dbo.getDateTime(q.utcSTime) utcSTime,
				dbo.getDateTime(q.utcETime) utcETime,
				q.totalJobs,
				q.bkupJobs,
				q.restoreJobs,
				q.adminJobs,
				q.appXML
			FROM #jobLoadStats q
			WHERE
				q.type IN (1, 2, 3, 4)		-- Summary rows only
		END
		ELSE
		BEGIN
			SELECT
				CASE
					WHEN q.type = 1 THEN 'Totals'
					WHEN q.type = 2 THEN 'Averages per Window'
					WHEN q.type = 3 THEN 'Max per Window'
					WHEN q.type = 4 THEN 'Min per Window'
					WHEN q.type = 5 THEN 'Job Window'
					ELSE NULL
				END record,
				dbo.getDateTime(q.utcSTime) utcSTime,
				dbo.getDateTime(q.utcETime) utcETime,
				q.totalJobs,
				q.bkupJobs,
				q.restoreJobs,
				q.adminJobs,
				q.appXML
			FROM #jobLoadStats q
		END
	END
	ELSE
	BEGIN
		-- Get SQL Scheduler and CPU Configuration
		DECLARE @schedulars XML = ''
		IF (@releaseNumber >= 13)		-- SQL 2016+
		BEGIN
			-- Fix for SQL 2014 SP installation
			DECLARE @schSQL NVARCHAR(MAX) = '
				SELECT
						(cores_per_socket * socket_count) [@physicalCores],
						cpu_count [@logicalCores],
						socket_count [@sockets],
						numa_node_count [@NUMAs],
						softnuma_configuration [@isSoftNUMA],
						(
							SELECT
								parent_node_id  [@scheduler],
								COUNT(DISTINCT scheduler_id) [@cores]
							FROM sys.dm_os_schedulers WITH(NOLOCK)
							WHERE scheduler_id < 255
								AND status = ''VISIBLE ONLINE''
							GROUP BY
								parent_node_id
							FOR XML PATH(''Schedular''), TYPE
						)
					FROM sys.dm_os_sys_info WITH(NOLOCK)
					FOR XML PATH(''Schedulars''), TYPE
				'
			DECLARE @schTbl TABLE (
				sch		XML
			)
			INSERT INTO @schTbl
				EXEC(@schSQL)
			IF (@@ROWCOUNT = 1)
			BEGIN
				SELECT @schedulars = sch FROM @schTbl
			END
		END
		ELSE
		BEGIN
			SET @schedulars = (
				SELECT
					cpu_count [@logicalCores],
					(cpu_count / hyperthread_ratio) [@sockets],
					(
						SELECT
							parent_node_id  [@scheduler],
							COUNT(DISTINCT scheduler_id) [@cores]
						FROM sys.dm_os_schedulers WITH(NOLOCK)
						WHERE scheduler_id < 255
							AND status = 'VISIBLE ONLINE'
						GROUP BY
							parent_node_id
						FOR XML PATH('Schedular'), TYPE
					)
				FROM sys.dm_os_sys_info WITH(NOLOCK)
				FOR XML PATH('Schedulars'), TYPE
			)
		END
		IF (@inSummaryOnly = 1)
		BEGIN
			SET @retXML = (
				SELECT
					@inReportHours [@hours],
					@schedulars,
					(
						SELECT
							@winCnt [@totalWindows],
							(
								SELECT
									CASE
										WHEN q.type = 1 THEN 'Totals'
										WHEN q.type = 2 THEN 'Averages per Window'
										WHEN q.type = 3 THEN 'Max per Window'
										WHEN q.type = 4 THEN 'Min per Window'
										ELSE NULL
									END [@type],
									dbo.getDateTime(q.utcSTime) [@utcSTime],
									dbo.getDateTime(q.utcETime) [@utcETime],
									q.totalJobs [@totalJobs],
									q.bkupJobs [@bkupJobs],
									q.restoreJobs [@restoreJobs],
									q.adminJobs [@adminJobs],
									q.appXML.query('/AppTypeStats')
								FROM #jobLoadStats q
								WHERE q.type IN (1, 2, 3, 4)		-- Summary rows only
								FOR XML PATH('Summary'), TYPE
							)
						FOR XML PATH('Statistics'), TYPE
					),
					@bucketXML
				FOR XML PATH('JMJobLoadStatsReport'), TYPE
			)
		END
		ELSE
		BEGIN
			SET @retXML = (
				SELECT
					@inReportHours [@hours],
					@schedulars,
					(
						SELECT
							@winCnt [@totalWindows],
							(
								SELECT
									CASE
										WHEN q.type = 1 THEN 'Totals'
										WHEN q.type = 2 THEN 'Averages per Window'
										WHEN q.type = 3 THEN 'Max per Window'
										WHEN q.type = 4 THEN 'Min per Window'
										ELSE NULL
									END [@type],
									dbo.getDateTime(q.utcSTime) [@utcSTime],
									dbo.getDateTime(q.utcETime) [@utcETime],
									q.totalJobs [@totalJobs],
									q.bkupJobs [@bkupJobs],
									q.restoreJobs [@restoreJobs],
									q.adminJobs [@adminJobs],
									q.appXML.query('/AppTypeStats')
								FROM #jobLoadStats q
								WHERE q.type IN (1, 2, 3, 4)		-- Summary rows
								FOR XML PATH('Summary'), TYPE
							)
						FOR XML PATH('Statistics'), TYPE
					),
					@bucketXML,
					(
						SELECT
							dbo.getDateTime(q.utcSTime) [@utcSTime],
							dbo.getDateTime(q.utcETime) [@utcETime],
							q.totalJobs [@totalJobs],
							q.bkupJobs [@bkupJobs],
							q.restoreJobs [@restoreJobs],
							q.adminJobs [@adminJobs],
							q.appXML.query('/AppTypeStats')
						FROM #jobLoadStats q
						WHERE q.type = 5
						FOR XML PATH('Window'), ROOT('JobWindows'), TYPE
					)
				FOR XML PATH('JMJobLoadStatsReport'), TYPE
			)
		END
		IF (@outXMLOutput IS NOT NULL)
		BEGIN
			SET @outXMLOutput = @retXML
		END
		ELSE
		BEGIN
			SELECT @retXML outputXML
		END
	END
	RETURN
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMComputeJobLoadReport')
	delete from GxQscripts where name = 'JMComputeJobLoadReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMComputeJobLoadReport')
	delete from GXDBVersions where aliasname = 'JMComputeJobLoadReport'
GO

insert into GXDBVersions values(2, 'JMComputeJobLoadReport',  '00010001000400030000', 'JMComputeJobLoadReport', '00010001000400030000')
GO

