

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMCleanUpCloudLaptopJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMCleanUpCloudLaptopJobs.sp,v $ $Id: JMCleanUpCloudLaptopJobs.sp,v 1.1.4.3 2018/03/27 08:48:30 jiechen Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   JMDeleteJobOptions   - Delete job options from task manager tables for given job id
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMCleanUpCloudLaptopJobs <<<'

IF EXISTS (select * from sysobjects where name='JMCleanUpCloudLaptopJobs')
	drop procedure JMCleanUpCloudLaptopJobs
IF EXISTS (select * from GxQscripts where name='JMCleanUpCloudLaptopJobs')
	delete from GxQscripts where name = 'JMCleanUpCloudLaptopJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCleanUpCloudLaptopJobs')
	delete from GXDBVersions where aliasname = 'JMCleanUpCloudLaptopJobs'
GO
print '... Creating Procedure: JMCleanUpCloudLaptopJobs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMCleanUpCloudLaptopJobs
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @clientID INT 
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  DECLARE @errorCode INTEGER
SET @errorCode = 0
BEGIN TRY
	BEGIN TRAN
		DELETE jobInfo
		FROM JMJobInfo jobInfo INNER JOIN
		JMBkpJobInfo bkpInfo WITH(NOLOCK) ON jobInfo.jobId = bkpInfo.jobId AND jobInfo.commCellId = bkpInfo.commcellId AND jobInfo.opType = 116 /*STATELESS_BACKUP*/
		INNER JOIN APP_Application app WITH(NOLOCK) ON bkpInfo.applicationId = app.id
		WHERE app.clientId = @clientID AND jobInfo.opType = 116 /*STATELESS_BACKUP*/
	COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	ROLLBACK TRAN
	SET @errorCode = 1
END CATCH
SELECT @errorCode
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'JMCleanUpCloudLaptopJobs')
	delete from GxQscripts where name = 'JMCleanUpCloudLaptopJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCleanUpCloudLaptopJobs')
	delete from GXDBVersions where aliasname = 'JMCleanUpCloudLaptopJobs'
GO

insert into GXDBVersions values(2, 'JMCleanUpCloudLaptopJobs',  '00010001000400030000', 'JMCleanUpCloudLaptopJobs', '00010001000400030000')
GO

