

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMChkJobRunningForMonitoringPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMChkJobRunningForMonitoringPolicy.sp,v $ $Id: JMChkJobRunningForMonitoringPolicy.sp,v 1.2.208.2 2018/03/22 03:04:07 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: JMChkJobRunningForMonitoringPolicy()
--  |
--  | Description:  Checks whether any job is running for the given agentless policy.
--  |
--  |	    Input:
--  |
--  |
--  |      Return:
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMChkJobRunningForMonitoringPolicy <<<'

IF EXISTS (select * from sysobjects where name='JMChkJobRunningForMonitoringPolicy')
	drop procedure JMChkJobRunningForMonitoringPolicy
IF EXISTS (select * from GxQscripts where name='JMChkJobRunningForMonitoringPolicy')
	delete from GxQscripts where name = 'JMChkJobRunningForMonitoringPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMChkJobRunningForMonitoringPolicy')
	delete from GXDBVersions where aliasname = 'JMChkJobRunningForMonitoringPolicy'
GO
print '... Creating Procedure: JMChkJobRunningForMonitoringPolicy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMChkJobRunningForMonitoringPolicy
  @monitoringPolicyId INTEGER,
  @ignoreStoppedJobs INTEGER,
  @STOPPED INTEGER,
  @DORMANT INTEGER
AS
  DECLARE @isJobRunningForMonitoringPolicy INTEGER
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE @defaultCCId INT = 2
	if @ignoreStoppedJobs = 0
		SELECT @isJobRunningForMonitoringPolicy = COUNT(*) FROM JMAdminJobInfoTable
		where commCellId = @defaultCCId and jobId in (
SELECT DISTINCT jobId FROM TM_JobOptions WHERE optionId=1464199408 AND jobId <> 0 AND @monitoringPolicyId = CAST(value AS INT))
	else
		SELECT @isJobRunningForMonitoringPolicy = COUNT(*) FROM JMAdminJobInfoTable
		where commCellId = @defaultCCId and jobId in (
SELECT DISTINCT jobId FROM TM_JobOptions WHERE optionId=1464199408 AND jobId <> 0 AND @monitoringPolicyId = CAST(value AS INT)) AND
			NOT EXISTS (SELECT * FROM JMJobInfo WHERE jobId = JMAdminJobInfoTable.jobId AND JMJobInfo.state IN (@STOPPED, @DORMANT))
	if @isJobRunningForMonitoringPolicy > 0
		SET @isJobRunningForMonitoringPolicy = 1
	SET NOCOUNT OFF
	select @isJobRunningForMonitoringPolicy
GO

IF EXISTS (select * from GxQscripts where name = 'JMChkJobRunningForMonitoringPolicy')
	delete from GxQscripts where name = 'JMChkJobRunningForMonitoringPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMChkJobRunningForMonitoringPolicy')
	delete from GXDBVersions where aliasname = 'JMChkJobRunningForMonitoringPolicy'
GO

insert into GXDBVersions values(2, 'JMChkJobRunningForMonitoringPolicy',  '00010002020800020000', 'JMChkJobRunningForMonitoringPolicy', '00010002020800020000')
GO

