

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMChkJobRunningForAgentlessPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMChkJobRunningForAgentlessPolicy.sp,v $ $Id: JMChkJobRunningForAgentlessPolicy.sp,v 1.3.210.2 2018/03/22 03:07:17 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: JMChkJobRunningForAgentlessPolicy()
--  |
--  | Description:  Checks whether any job is running for the given agentless policy.
--  |
--  |	    Input:
--  |
--  |
--  |      Return:
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMChkJobRunningForAgentlessPolicy <<<'

IF EXISTS (select * from sysobjects where name='JMChkJobRunningForAgentlessPolicy')
	drop procedure JMChkJobRunningForAgentlessPolicy
IF EXISTS (select * from GxQscripts where name='JMChkJobRunningForAgentlessPolicy')
	delete from GxQscripts where name = 'JMChkJobRunningForAgentlessPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMChkJobRunningForAgentlessPolicy')
	delete from GXDBVersions where aliasname = 'JMChkJobRunningForAgentlessPolicy'
GO
print '... Creating Procedure: JMChkJobRunningForAgentlessPolicy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMChkJobRunningForAgentlessPolicy
  @agentlessPolicyId INTEGER,
  @ignoreStoppedJobs INTEGER,
  @STOPPED INTEGER,
  @DORMANT INTEGER
AS
  DECLARE @isJobRunningForAgentlessPolicy INTEGER
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE @defaultCCId INT = 2
	if @ignoreStoppedJobs = 0
		SELECT @isJobRunningForAgentlessPolicy = COUNT(*) FROM JMAdminJobInfoTable
		where commCellId = @defaultCCId and jobId in (
SELECT DISTINCT jobId FROM TM_JobOptions WHERE optionId=140024 AND jobId <> 0 AND @agentlessPolicyId = CAST(value AS INT))
	else
		SELECT @isJobRunningForAgentlessPolicy = COUNT(*) FROM JMAdminJobInfoTable
		where commCellId = @defaultCCId and jobId in (
SELECT DISTINCT jobId FROM TM_JobOptions WHERE optionId=140024 AND jobId <> 0 AND @agentlessPolicyId = CAST(value AS INT)) AND
			NOT EXISTS (SELECT * FROM JMJobInfo WHERE jobId = JMAdminJobInfoTable.jobId AND JMJobInfo.state IN (@STOPPED, @DORMANT))
	if @isJobRunningForAgentlessPolicy > 0
		SET @isJobRunningForAgentlessPolicy = 1
	SET NOCOUNT OFF
	select @isJobRunningForAgentlessPolicy
GO

IF EXISTS (select * from GxQscripts where name = 'JMChkJobRunningForAgentlessPolicy')
	delete from GxQscripts where name = 'JMChkJobRunningForAgentlessPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMChkJobRunningForAgentlessPolicy')
	delete from GXDBVersions where aliasname = 'JMChkJobRunningForAgentlessPolicy'
GO

insert into GXDBVersions values(2, 'JMChkJobRunningForAgentlessPolicy',  '00010003021000020000', 'JMChkJobRunningForAgentlessPolicy', '00010003021000020000')
GO

