

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMChkBkpJobRunningForSC.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMChkBkpJobRunningForSC.sp,v $ $Id: JMChkBkpJobRunningForSC.sp,v 1.2.210.3 2018/03/22 03:00:54 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: JMChkBkpJobRunningForSC()
--  |
--  | Description:  Checks whether any backup job is running for the given subclient.
--  |               In the case of content change it checks whether any job running for the default subclient also.
--  |               If the case of template subclient(Configured in the subclient policy) it checks for the
--	|				associated subclient for the above two cases
--  |
--  |	    Input:
--  |
--  |
--  |      Return:
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMChkBkpJobRunningForSC <<<'

IF EXISTS (select * from sysobjects where name='JMChkBkpJobRunningForSC')
	drop procedure JMChkBkpJobRunningForSC
IF EXISTS (select * from GxQscripts where name='JMChkBkpJobRunningForSC')
	delete from GxQscripts where name = 'JMChkBkpJobRunningForSC'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMChkBkpJobRunningForSC')
	delete from GXDBVersions where aliasname = 'JMChkBkpJobRunningForSC'
GO
print '... Creating Procedure: JMChkBkpJobRunningForSC'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMChkBkpJobRunningForSC
  @subClientId INTEGER,
  @contentChanged INTEGER,
  @ignoreStoppedJobs INTEGER,
  @STOPPED INTEGER,
  @DORMANT INTEGER
AS
  DECLARE @isBackupsRunningForSc INTEGER
	Declare @appTypeId	INTEGER
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	create table #tempSCList(id int)
	select @appTypeId = appTypeId from app_application where id = @subClientId
if @appTypeId != 1030
		begin
			-- Add the subclient into temp table
			insert into #tempSCList values(@subClientId)
			if @contentChanged = 1
				-- Contents changed. Need to check for default subclient
				-- Add the default subclient into temp table
				insert into #tempSCList select id from app_application where
				backupset = (select backupset from app_application where id = @subClientId) and
				subclientstatus=8
		end
	else
		begin
			-- The tempSCList contains the list of associated subclient to the given template subclient
			insert into #tempSCList select componentNameId from APP_SubClientProp where attrName = N'Associated subclient Policy' and attrVal = CAST(@subClientId AS varchar(12)) and modified = 0
			if @contentChanged = 1
			begin
				-- Now insert the default subclient for the associated subclients
				insert into #tempSCList select id from app_application where
				backupset in (select backupset from app_application where id in (select id from #tempSCList))
				and subclientstatus = 8
			end
		end
	if @ignoreStoppedJobs = 0
		select @isBackupsRunningForSc = count(*) from JMBkpJobInfo WITH(NOLOCK) where applicationid in (select id from #tempSCList)
	else
		select @isBackupsRunningForSc = count(*) from JMBkpJobInfo WITH(NOLOCK) where applicationid in (select id from #tempSCList) and
		NOT EXISTS (SELECT 1 FROM JMJobInfo WITH(NOLOCK) WHERE jobId = JMBkpJobInfo.jobId AND JMJobInfo.commCellId = JMbkpJobInfo.commCellId AND JMJobInfo.state IN (@STOPPED, @DORMANT))
	if @isBackupsRunningForSc > 0
		SET @isBackupsRunningForSc = 1
	drop table #tempSCList
	SET NOCOUNT OFF
	select @isBackupsRunningForSc
GO

IF EXISTS (select * from GxQscripts where name = 'JMChkBkpJobRunningForSC')
	delete from GxQscripts where name = 'JMChkBkpJobRunningForSC'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMChkBkpJobRunningForSC')
	delete from GXDBVersions where aliasname = 'JMChkBkpJobRunningForSC'
GO

insert into GXDBVersions values(2, 'JMChkBkpJobRunningForSC',  '00010002021000030000', 'JMChkBkpJobRunningForSC', '00010002021000030000')
GO

