

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMCheckWFJobsNeedToBeResumed.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--  +========================================================================+
--  |      Name	 :  JMCheckWFJobsNeedToBeResumed
--  |
--  | Description:  It returns the WF jobs which need to be resumed based on their auto resume interval.
--	|
--  |      Output:  outWFJobID
--	|
--  +========================================================================+
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMCheckWFJobsNeedToBeResumed <<<'

IF EXISTS (select * from sysobjects where name='JMCheckWFJobsNeedToBeResumed')
	drop procedure JMCheckWFJobsNeedToBeResumed
IF EXISTS (select * from GxQscripts where name='JMCheckWFJobsNeedToBeResumed')
	delete from GxQscripts where name = 'JMCheckWFJobsNeedToBeResumed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCheckWFJobsNeedToBeResumed')
	delete from GXDBVersions where aliasname = 'JMCheckWFJobsNeedToBeResumed'
GO
print '... Creating Procedure: JMCheckWFJobsNeedToBeResumed'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMCheckWFJobsNeedToBeResumed
AS
  DECLARE @outWFJobID integer
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @currentTime INTEGER
	SET @currentTime = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
	select info.jobid from JMMisc misc, jmjoboptions options, jmjobinfo info
	where info.jobid = misc.jobid and info.jobid= options.jobid
	and misc.itemType = 21 and options.attributeName = 'Job AutoResume interval'  and info.state = 5  -- JM_JOB_SUSPEND_START_TIME 21 STOPPED 5
	and options.attributeValueInt > 0  and info.optype = 90  -- WORKFLOW_MGMT 90
	and	((@currentTime - misc.intData) > options.attributeValueInt)
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMCheckWFJobsNeedToBeResumed')
	delete from GxQscripts where name = 'JMCheckWFJobsNeedToBeResumed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCheckWFJobsNeedToBeResumed')
	delete from GXDBVersions where aliasname = 'JMCheckWFJobsNeedToBeResumed'
GO

insert into GXDBVersions values(2, 'JMCheckWFJobsNeedToBeResumed',  '00000000000000000000', 'JMCheckWFJobsNeedToBeResumed', '00000000000000000000')
GO

