

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMCheckUserJobVisibilityV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMCheckUserJobVisibilityV2.sp,v $ $Id: JMCheckUserJobVisibilityV2.sp,v 1.1.2.3 2018/09/04 18:33:05 sbonilla Exp $";
--
--  +========================================================================+
--  | Stored Precedure: JMCheckUserJobVisibilityV2
--  |
--  | Description:
--  |  Add JMJobDataStats table entries for the given backup job and copy.
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        Amey   Initial Edit
--  |   2.0        Aaron  Replacement for JMCheckUserJobVisibility to remove
--  |                     front-end JMGetJobVisibilityMask file cursor
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMCheckUserJobVisibilityV2 <<<'

IF EXISTS (select * from sysobjects where name='JMCheckUserJobVisibilityV2')
	drop procedure JMCheckUserJobVisibilityV2
IF EXISTS (select * from GxQscripts where name='JMCheckUserJobVisibilityV2')
	delete from GxQscripts where name = 'JMCheckUserJobVisibilityV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCheckUserJobVisibilityV2')
	delete from GXDBVersions where aliasname = 'JMCheckUserJobVisibilityV2'
GO
print '... Creating Procedure: JMCheckUserJobVisibilityV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMCheckUserJobVisibilityV2
  @inCommcellId INTEGER,
  @inJobid INTEGER,
  @inUserXML XML
AS
  DECLARE @userId int
  DECLARE @isJobVisible int
DECLARE @retVal			INT
DECLARE @isJobRunning	INT
DECLARE @jobStartedBy	INT
DECLARE @jobCategory	INT
DECLARE @srcClientid	INT
DECLARE @destClientid	INT
DECLARE @apptypeid		INT
DECLARE @instanceid		INT
DECLARE @backupsetid	INT
DECLARE @subclientid	INT
DECLARE @archGroupid	INT
DECLARE @opType			INT
SET @retVal = 1		-- failed
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF (@inUserXML IS NULL)
BEGIN
	SET @retVal = 2		-- no inputted users error
	RETURN @retVal
END
IF OBJECT_ID('tempdb.dbo.#UserJobVisibility') IS NOT NULL
	DROP TABLE #UserJobVisibility
CREATE TABLE #UserJobVisibility (userId INT PRIMARY KEY)
-- Parse User XML Document for valid userIds
INSERT INTO #UserJobVisibility
	SELECT
		u.id
	FROM
		@inUserXML.nodes('/Users/User') n(v)
		INNER JOIN UMUsers u WITH(READUNCOMMITTED) ON
			u.id = v.value('@Id', 'INT')
IF (@@ROWCOUNT = 0)
BEGIN
	IF OBJECT_ID('tempdb.dbo.#UserJobVisibility') IS NOT NULL
		DROP TABLE #UserJobVisibility
	SET @retVal = 2		-- no inputted users error
	RETURN @retVal
END
-- NOTE: Require READCOMMITTED Isolation level for this query
-- check if the job is running or completed so that the appropriate table can be checked
SELECT @jobCategory = JMJobStats.jobCategory, @isJobRunning = CASE status WHEN 1 THEN 1 ELSE 0 END FROM JMJobStats WHERE jobid = @inJobid AND commcellid = @inCommcellId
-- Set READUNCOMMITTED Isolation level for the rest of the SP execution
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF @isJobRunning IS null
BEGIN
	-- the job id was not found. So return false
	SET @retVal = 0
	SELECT userId, 0 AS isVisible FROM #UserJobVisibility
END
ELSE IF @isJobRunning = 1
BEGIN
	-- this is a running job.
	IF @jobCategory = 1 -- this is a running backup job
	BEGIN
		SELECT @jobStartedBy = userid, @srcClientid = clientid, @apptypeid = apptypeid, @instanceid = instance, @backupsetid = backupset, @subclientid = applicationid FROM RunningBackups WHERE jobid = @inJobid AND commcellId = @inCommcellId
		IF @@ROWCOUNT = 0
		BEGIN
			SET @retVal = 0
			-- if the row cannot be found then return error.
			SELECT userId, 0 AS isVisible FROM #UserJobVisibility
		END
		ELSE
		BEGIN
			-- at least one of the capabilities are needed to see a backup job
			SELECT userId AS UserId, CASE WHEN @jobStartedBy = userId THEN 1 ELSE dbo.isBkpJobVisible(userId,@inCommcellId,@srcClientid,@apptypeid,@instanceid,@backupsetid,@subclientid) END AS isVisible FROM #UserJobVisibility
		END
	END
	ELSE IF @jobCategory = 2 -- this is a running restore job
	BEGIN
		SELECT @jobStartedBy = userid, @srcClientid = srcClientid, @destClientid = destClientid, @apptypeid = apptype, @instanceid = instanceid, @backupsetid = bkpSetId FROM RunningRestores WHERE jobid = @inJobid AND commcellId = @inCommcellId
		IF @@ROWCOUNT = 0
		BEGIN
			-- if the row cannot be found then return error.
			SET @retVal = 0
			SELECT userId, 0 AS isVisible FROM #UserJobVisibility
		END
		ELSE
		BEGIN
			-- at least one of the capabilities are needed to see a restore job
			-- the user can have rights on either the source or the destination client id
			SELECT userId AS UserId, CASE WHEN @jobStartedBy = userId THEN 1 ELSE dbo.isRstJobVisible(userId,@inCommcellId,@srcClientid,@destClientId,@apptypeid,@instanceid,@backupsetid) END AS isVisible FROM #UserJobVisibility
		END
	END
	ELSE -- this is a running admin job
	BEGIN
		SELECT @jobStartedBy = userid, @archGroupid = archGrpId, @opType = opType FROM RunningAdminJobs WHERE jobid = @inJobid AND commcellId = @inCommcellId
		IF @@ROWCOUNT = 0
		BEGIN
			-- if the row cannot be found then return error.
			SET @retVal = 0
			SELECT userId, 0 AS isVisible FROM #UserJobVisibility
		END
		ELSE
		BEGIN
			SELECT userId AS UserId, CASE WHEN @jobStartedBy = userId THEN 1 ELSE dbo.isAdminJobVisible(userId,@inCommcellId,@archGroupid,@inJobid,@opType,0) END AS isVisible FROM #UserJobVisibility
		END
	END
END
ELSE
BEGIN
	-- this is a completed job.
	IF @jobCategory = 1 -- this is a completed backup job
	BEGIN
		SELECT @srcClientid = App_Application.clientid, @apptypeid = App_Application.apptypeid, @instanceid = App_Application.instance, @backupsetid = App_Application.backupset, @subclientid = appId FROM JMBkpStats, App_Application WHERE jobid = @inJobid AND commcellId = @inCommcellId AND JMBkpStats.appId = App_Application.id
		IF @@ROWCOUNT = 0
		BEGIN
			SET @retVal = 0
			-- if the row cannot be found then return error. However if the user id matches then return true for that user
			SELECT userId, 0 AS isVisible FROM #UserJobVisibility
		END
		ELSE
		BEGIN
			-- at least one of the capabilities are needed to see a backup job
			SELECT userId, dbo.isBkpJobVisible(userId,@inCommcellId,@srcClientid,@apptypeid,@instanceid,@backupsetid,@subclientid) AS isVisible FROM #UserJobVisibility
		END
	END
	ELSE IF @jobCategory = 2 -- this is a completed restore job
	BEGIN
		SELECT @srcClientid = srcClientid, @destClientid = destClientid, @apptypeid = apptype, @instanceid = instanceid, @backupsetid = bkpSetID FROM JMRestoreStats WHERE jobid = @inJobid AND commcellId = @inCommcellId
		IF @@ROWCOUNT = 0
		BEGIN
			-- if the row cannot be found then return error. However if the user id matches then return true for that user
			SET @retVal = 0
			SELECT userId, 0 AS isVisible FROM #UserJobVisibility
		END
		ELSE
		BEGIN
			-- at least one of the capabilities are needed to see a restore job
			-- the user can have rights on either the source or the destination client id
			SELECT userId, dbo.isRstJobVisible(userId,@inCommcellId,@srcClientid,@destClientId,@apptypeid,@instanceid,@backupsetid) AS isVisible FROM #UserJobVisibility
		END
	END
	ELSE -- this is a completed admin job
	BEGIN
		SELECT @archGroupid = archGrpId, @opType = opType, @srcClientid = ISNULL(Q.clientId, 0)
		FROM JMAdminJobStatsTable JA
		LEFT OUTER JOIN JMQinetixUpdateStatus Q ON Q.jobId = JA.jobId
		WHERE JA.jobid = @inJobid AND JA.commcellId = @inCommcellId
		IF @@ROWCOUNT = 0
		BEGIN
			SET @archGroupid = 0
		END
		SELECT userId, dbo.isAdminJobVisible(userId,@inCommcellId,@archGroupid,@inJobid,@opType,@srcClientid) AS isVisible FROM #UserJobVisibility
	END
END
IF OBJECT_ID('tempdb.dbo.#UserJobVisibility') IS NOT NULL
	DROP TABLE #UserJobVisibility
RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'JMCheckUserJobVisibilityV2')
	delete from GxQscripts where name = 'JMCheckUserJobVisibilityV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCheckUserJobVisibilityV2')
	delete from GXDBVersions where aliasname = 'JMCheckUserJobVisibilityV2'
GO

insert into GXDBVersions values(2, 'JMCheckUserJobVisibilityV2',  '00010001000200030000', 'JMCheckUserJobVisibilityV2', '00010001000200030000')
GO

