

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMCheckUserJobVisibility.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMCheckUserJobVisibility.sp,v $ $Id: JMCheckUserJobVisibility.sp,v 1.8.76.1 2018/03/22 03:19:12 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: JMCheckUserJobVisibility
--  |
--  | Description:
--  |  Add JMJobDataStats table entries for the given backup job and copy.
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        Amey   Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMCheckUserJobVisibility <<<'

IF EXISTS (select * from sysobjects where name='JMCheckUserJobVisibility')
	drop procedure JMCheckUserJobVisibility
IF EXISTS (select * from GxQscripts where name='JMCheckUserJobVisibility')
	delete from GxQscripts where name = 'JMCheckUserJobVisibility'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCheckUserJobVisibility')
	delete from GXDBVersions where aliasname = 'JMCheckUserJobVisibility'
GO
print '... Creating Procedure: JMCheckUserJobVisibility'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMCheckUserJobVisibility
  @inCommcellId INTEGER,
  @inJobid INTEGER
AS
DECLARE @retVal			INT
DECLARE @isJobRunning	INT
DECLARE @jobStartedBy	INT
DECLARE @jobCategory	INT
DECLARE @srcClientid	INT
DECLARE @destClientid	INT
DECLARE @apptypeid		INT
DECLARE @instanceid		INT
DECLARE @backupsetid	INT
DECLARE @subclientid	INT
DECLARE @archGroupid	INT
DECLARE @opType			INT
SET @retVal = 1
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- check if the job is running or completed so that the appropriate table can be checked
SELECT @jobCategory = JMJobStats.jobCategory, @isJobRunning = CASE status WHEN 1 THEN 1 ELSE 0 END FROM JMJobStats WHERE jobid = @inJobid AND commcellid = @inCommcellId
IF @isJobRunning IS null
BEGIN
	-- the job id was not found. So return false
	SET @retVal = 0
	SELECT userId, 0 AS isVisible FROM #UserJobVisibility
END
ELSE IF @isJobRunning = 1
BEGIN
	-- this is a running job.
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	IF @jobCategory = 1 -- this is a running backup job
	BEGIN
		SELECT @jobStartedBy = userid, @srcClientid = clientid, @apptypeid = apptypeid, @instanceid = instance, @backupsetid = backupset, @subclientid = applicationid FROM RunningBackups WHERE jobid = @inJobid AND commcellId = @inCommcellId
		IF @@ROWCOUNT = 0
		BEGIN
			SET @retVal = 0
			-- if the row cannot be found then return error.
			SELECT userId, 0 AS isVisible FROM #UserJobVisibility
		END
		ELSE
		BEGIN
			-- at least one of the capabilities are needed to see a backup job
			SELECT userId AS UserId, CASE WHEN @jobStartedBy = userId THEN 1 ELSE dbo.isBkpJobVisible(userId,@inCommcellId,@srcClientid,@apptypeid,@instanceid,@backupsetid,@subclientid) END AS isVisible FROM #UserJobVisibility
		END
	END
	ELSE IF @jobCategory = 2 -- this is a running restore job
	BEGIN
		SELECT @jobStartedBy = userid, @srcClientid = srcClientid, @destClientid = destClientid, @apptypeid = apptype, @instanceid = instanceid, @backupsetid = bkpSetId FROM RunningRestores WHERE jobid = @inJobid AND commcellId = @inCommcellId
		IF @@ROWCOUNT = 0
		BEGIN
			-- if the row cannot be found then return error.
			SET @retVal = 0
			SELECT userId, 0 AS isVisible FROM #UserJobVisibility
		END
		ELSE
		BEGIN
			-- at least one of the capabilities are needed to see a restore job
			-- the user can have rights on either the source or the destination client id
			SELECT userId AS UserId, CASE WHEN @jobStartedBy = userId THEN 1 ELSE dbo.isRstJobVisible(userId,@inCommcellId,@srcClientid,@destClientId,@apptypeid,@instanceid,@backupsetid) END AS isVisible FROM #UserJobVisibility
		END
	END
	ELSE -- this is a running admin job
	BEGIN
		SELECT @jobStartedBy = userid, @archGroupid = archGrpId, @opType = opType FROM RunningAdminJobs WHERE jobid = @inJobid AND commcellId = @inCommcellId
		IF @@ROWCOUNT = 0
		BEGIN
			-- if the row cannot be found then return error.
			SET @retVal = 0
			SELECT userId, 0 AS isVisible FROM #UserJobVisibility
		END
		ELSE
		BEGIN
			SELECT userId AS UserId, CASE WHEN @jobStartedBy = userId THEN 1 ELSE dbo.isAdminJobVisible(userId,@inCommcellId,@archGroupid,@inJobid,@opType,0) END AS isVisible FROM #UserJobVisibility
		END
	END
END
ELSE
BEGIN
	-- this is a completed job.
	IF @jobCategory = 1 -- this is a completed backup job
	BEGIN
		SELECT @srcClientid = App_Application.clientid, @apptypeid = App_Application.apptypeid, @instanceid = App_Application.instance, @backupsetid = App_Application.backupset, @subclientid = appId FROM JMBkpStats, App_Application WHERE jobid = @inJobid AND commcellId = @inCommcellId AND JMBkpStats.appId = App_Application.id
		IF @@ROWCOUNT = 0
		BEGIN
			SET @retVal = 0
			-- if the row cannot be found then return error. However if the user id matches then return true for that user
			SELECT userId, 0 AS isVisible FROM #UserJobVisibility
		END
		ELSE
		BEGIN
			-- at least one of the capabilities are needed to see a backup job
			SELECT userId, dbo.isBkpJobVisible(userId,@inCommcellId,@srcClientid,@apptypeid,@instanceid,@backupsetid,@subclientid) AS isVisible FROM #UserJobVisibility
		END
	END
	ELSE IF @jobCategory = 2 -- this is a completed restore job
	BEGIN
		SELECT @srcClientid = srcClientid, @destClientid = destClientid, @apptypeid = apptype, @instanceid = instanceid, @backupsetid = bkpSetID FROM JMRestoreStats WHERE jobid = @inJobid AND commcellId = @inCommcellId
		IF @@ROWCOUNT = 0
		BEGIN
			-- if the row cannot be found then return error. However if the user id matches then return true for that user
			SET @retVal = 0
			SELECT userId, 0 AS isVisible FROM #UserJobVisibility
		END
		ELSE
		BEGIN
			-- at least one of the capabilities are needed to see a restore job
			-- the user can have rights on either the source or the destination client id
			SELECT userId, dbo.isRstJobVisible(userId,@inCommcellId,@srcClientid,@destClientId,@apptypeid,@instanceid,@backupsetid) AS isVisible FROM #UserJobVisibility
		END
	END
	ELSE -- this is a completed admin job
	BEGIN
		SELECT @archGroupid = archGrpId, @opType = opType FROM JMAdminJobStatsTable WHERE jobid = @inJobid AND commcellId = @inCommcellId
		IF @@ROWCOUNT = 0
		BEGIN
			SET @archGroupid = 0
		END
		SELECT userId, dbo.isAdminJobVisible(userId,@inCommcellId,@archGroupid,@inJobid,@opType,0) AS isVisible FROM #UserJobVisibility
	END
END
RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'JMCheckUserJobVisibility')
	delete from GxQscripts where name = 'JMCheckUserJobVisibility'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCheckUserJobVisibility')
	delete from GXDBVersions where aliasname = 'JMCheckUserJobVisibility'
GO

insert into GXDBVersions values(2, 'JMCheckUserJobVisibility',  '00010008007600010000', 'JMCheckUserJobVisibility', '00010008007600010000')
GO

