

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMCheckSpoolCopyJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMCheckSpoolCopyJob')
BEGIN
	print '>>> Drop Stored Procedure: JMCheckSpoolCopyJob <<<'
	drop procedure JMCheckSpoolCopyJob
END
IF EXISTS (select * from GxQscripts where name='JMCheckSpoolCopyJob')
	delete from GxQscripts where name = 'JMCheckSpoolCopyJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCheckSpoolCopyJob')
	delete from GXDBVersions where aliasname = 'JMCheckSpoolCopyJob'
GO
print '... Creating Procedure: JMCheckSpoolCopyJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMCheckSpoolCopyJob
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--   PARAMETERS   &   OUTPUTS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_jobId BIGINT,
  @i_commcellId INT 
AS
  DECLARE @o_isPrimarySnapSpool INT
  DECLARE @o_secondarySyncVaultExists INT
BEGIN
SELECT DISTINCT TOP 1 (CASE WHEN (AR.retentionDays = 0 AND AR.fullCycles = 0 AND AR.retentionJobs = 0) THEN 1 ELSE 0 END) AS isPrimarySnapSpool,
                           CASE WHEN EXISTS (SELECT 1 FROM archGroupCopy AGC WITH (NOLOCK)
                                                         WHERE AGC.archGroupId = AG.id AND AGC.isSnapCopy > 0 AND AGC.isMirrorCopy = 0
                                                         AND AGC.id != AG.defaultSnapCopy AND AGC.type = 1 AND AGC.isActive = 1)
                           THEN 1 ELSE 0
                           END AS secondarySyncVaultExists
FROM archFile AF WITH (NOLOCK), archGroup AG WITH (NOLOCK), archAgingRule AR WITH (NOLOCK)
WHERE AF.jobId = @i_jobId
AND     AF.commcellId = @i_commcellId
AND     AF.fileType IN (1, 4)
AND   	AF.archGroupId = AG.id
AND     AG.defaultSnapCopy > 0
AND     AG.defaultSnapCopy = AR.copyId
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMCheckSpoolCopyJob')
	delete from GxQscripts where name = 'JMCheckSpoolCopyJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCheckSpoolCopyJob')
	delete from GXDBVersions where aliasname = 'JMCheckSpoolCopyJob'
GO

insert into GXDBVersions values(2, 'JMCheckSpoolCopyJob',  '00000000000000000000', 'JMCheckSpoolCopyJob', '00000000000000000000')
GO

