

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMCheckConflictingExchangeJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMCheckConflictingExchangeJob.sp,v $ $Id: JMCheckConflictingExchangeJob.sp,v 1.1.4.7 2018/09/26 08:59:36 jragunathan Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMCheckConflictingExchangeJob <<<'

IF EXISTS (select * from sysobjects where name='JMCheckConflictingExchangeJob')
	drop procedure JMCheckConflictingExchangeJob
IF EXISTS (select * from GxQscripts where name='JMCheckConflictingExchangeJob')
	delete from GxQscripts where name = 'JMCheckConflictingExchangeJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCheckConflictingExchangeJob')
	delete from GXDBVersions where aliasname = 'JMCheckConflictingExchangeJob'
GO
print '... Creating Procedure: JMCheckConflictingExchangeJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMCheckConflictingExchangeJob
  @inJobID int,
  @inOpType int,
  @inSubOpType int,
  @inSubClientId int
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @conflictingJobID integer;
BEGIN
	if OBJECT_ID('tempdb.dbo.#inputJobTable') is not null drop table dbo.#inputJobTable
	create table #inputJobTable
	(
		jobId    integer,
		jobLevel    integer,
		cmpVal nvarchar(MAX)
	)
	if OBJECT_ID('tempdb.dbo.#listOfJobIdsToCheck') is not null drop table dbo.#listOfJobIdsToCheck
	create table #listOfJobIdsToCheck
	(
		jobId    integer,
		subclientID    integer
	)
	if OBJECT_ID('tempdb.dbo.#checkConflictJobTable') is not null drop table dbo.#checkConflictJobTable
	create table #checkConflictJobTable
	(
		jobId    integer,
		jobLevel    integer,
		cmpVal nvarchar(MAX)
	)
	if OBJECT_ID('tempdb.dbo.#output') is not null drop table dbo.#output
	create table #output
	(
		jobId    integer
	)
	DECLARE @inMemberServerXML  XML
	DECLARE @jobLevelToTest		BIGINT
	DECLARE @checkConflictEnabled INT = 0
	DECLARE @clientId INT = 0
	DECLARE @subclientLevel INT = 1
	DECLARE @mailBoxesLevel INT = 2
	DECLARE @databasesLevel INT = 3
	DECLARE @adGroupsLevel INT = 4
	DECLARE @contentStoreMailboxesLevel INT = 5
	DECLARE @pstIngestionLevel INT = 6
	SET @clientId = ISNULL((SELECT clientid FROM APP_Application WHERE id=@inSubClientId), 0)
	IF	@clientId = 0 OR @inJobID <=0
		GOTO ERROR_2
	IF @inOpType = 4 AND @inSubOpType = 98
	BEGIN
		IF EXISTS (SELECT TOP 1 * FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'ExchangeOnePassdontAllowParallelJobs')
		BEGIN
			SELECT @checkConflictEnabled = CAST(value AS INT) FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'ExchangeOnePassdontAllowParallelJobs'
			IF	@checkConflictEnabled = 0
				GOTO ERROR_2
		END
		INSERT INTO #listOfJobIdsToCheck
		(jobId, subclientID)
		SELECT JMBkpJobInfo.jobId, JMBkpJobInfo.applicationId
		FROM JMBkpJobInfo
        INNER JOIN JMJobInfo ON
        JMBkpJobInfo.jobId = JMJobInfo.jobId AND
        JMBkpJobInfo.commcellId = JMJobInfo.commcellId
		INNER JOIN APP_Application ON
		JMBkpJobInfo.applicationId = APP_Application.id
		WHERE JMJobInfo.subOpType = @inSubOpType AND JMJobInfo.opType = @inOpType AND APP_Application.clientid = @clientId AND JMJobInfo.jobid <> @inJobID
	END
	ELSE IF @inOpType = 109 AND @inSubOpType = 0
	BEGIN
		IF EXISTS (SELECT TOP 1 * FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'ExchangeOnePassdontAllowParallelJobs')
		BEGIN
			SELECT @checkConflictEnabled = CAST(value AS INT) FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'ExchangeOnePassdontAllowParallelJobs'
			IF	@checkConflictEnabled = 0
				GOTO ERROR_2
		END
		INSERT INTO #listOfJobIdsToCheck
		(jobId, subclientID)
		SELECT JMBkpJobInfo.jobId, JMBkpJobInfo.applicationId
		FROM JMBkpJobInfo
        INNER JOIN JMJobInfo ON
        JMBkpJobInfo.jobId = JMJobInfo.jobId AND
        JMBkpJobInfo.commcellId = JMJobInfo.commcellId
		INNER JOIN APP_Application ON
		JMBkpJobInfo.applicationId = APP_Application.id
		WHERE JMJobInfo.opType = @inOpType AND APP_Application.clientid = @clientId AND JMJobInfo.jobid <> @inJobID
	END
	ELSE IF @inOpType = 113 AND @inSubOpType = 0
	BEGIN
		IF EXISTS (SELECT TOP 1 * FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'ExchangeOnePassdontAllowParallelCIJobs')
		BEGIN
			SELECT @checkConflictEnabled = CAST(value AS INT) FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'ExchangeOnePassdontAllowParallelCIJobs'
			IF	@checkConflictEnabled = 0
				GOTO ERROR_2
		END
		INSERT INTO #listOfJobIdsToCheck
		(jobId, subclientID)
		SELECT JMAdminJobInfoTable.jobId, JMAdminJobInfoTable.appid
		FROM JMAdminJobInfoTable
		LEFT OUTER JOIN APP_Application ON
		JMAdminJobInfoTable.appid = APP_Application.id
		WHERE JMAdminJobInfoTable.optype = @inOpType AND APP_Application.clientid = @clientId AND JMAdminJobInfoTable.jobId <> @inJobID
	END
	ELSE IF @inOpType = 4 AND @inSubOpType = 136
	BEGIN
		IF EXISTS (SELECT TOP 1 * FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'ExchangeOnePassdontAllowParallelPSTIngestionJobs')
		BEGIN
			SELECT @checkConflictEnabled = CAST(value AS INT) FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'ExchangeOnePassdontAllowParallelPSTIngestionJobs'
			IF	@checkConflictEnabled = 0
				GOTO ERROR_2
		END
		INSERT INTO #listOfJobIdsToCheck
		(jobId, subclientID)
		SELECT JMBkpJobInfo.jobId, JMBkpJobInfo.applicationId
		FROM JMBkpJobInfo
        INNER JOIN JMJobInfo ON
        JMBkpJobInfo.jobId = JMJobInfo.jobId AND
        JMBkpJobInfo.commcellId = JMJobInfo.commcellId
		INNER JOIN APP_Application ON
		JMBkpJobInfo.applicationId = APP_Application.id
		WHERE JMJobInfo.opType = @inOpType AND APP_Application.clientid = @clientId AND JMJobInfo.jobid <> @inJobID
	END
	ELSE
		GOTO ERROR_2
	SET @inMemberServerXML = dbo.GetXMLJobOptions(@inJobid).query('TMMsg_JobOption/backupOpts/exchOnePassOptions')
	IF @inMemberServerXML.exist('exchOnePassOptions/mailBoxes') = 1
	BEGIN
		INSERT INTO #inputJobTable
		(jobId, jobLevel, cmpVal)
		SELECT
		@inJobID, @mailBoxesLevel, Tbl.Col.value('@userGUID', 'nvarchar(MAX)') as val
		FROM @inMemberServerXML.nodes('exchOnePassOptions/mailBoxes/user') as Tbl(Col)
		SET @jobLevelToTest = @mailBoxesLevel
	END
	ELSE IF @inMemberServerXML.exist('exchOnePassOptions/databases') = 1
	BEGIN
		INSERT INTO #inputJobTable
		(jobId, jobLevel, cmpVal)
		SELECT
		@inJobID, @databasesLevel, Tbl.Col.value('@databaseName', 'nvarchar(MAX)') as val
		FROM @inMemberServerXML.nodes('exchOnePassOptions/databases') as Tbl(Col)
		SET @jobLevelToTest = @databasesLevel
	END
	ELSE IF @inMemberServerXML.exist('exchOnePassOptions/adGroups') = 1
	BEGIN
		INSERT INTO #inputJobTable
		(jobId, jobLevel, cmpVal)
		SELECT
		@inJobID, @adGroupsLevel, Tbl.Col.value('@adGroupName', 'nvarchar(MAX)') as val
		FROM @inMemberServerXML.nodes('exchOnePassOptions/adGroups') as Tbl(Col)
		SET @jobLevelToTest = @adGroupsLevel
	END
	ELSE IF @inMemberServerXML.exist('exchOnePassOptions/contentStoreMailboxes') = 1
	BEGIN
		INSERT INTO #inputJobTable
		(jobId, jobLevel, cmpVal)
		SELECT
		@inJobID, @contentStoreMailboxesLevel, Tbl.Col.value('@userGUID', 'nvarchar(MAX)') as val
		FROM @inMemberServerXML.nodes('exchOnePassOptions/contentStoreMailboxes/user') as Tbl(Col)
		SET @jobLevelToTest = @contentStoreMailboxesLevel
	END
	ELSE IF @inMemberServerXML.exist('exchOnePassOptions') = 0
	BEGIN
		IF @inSubClientId = 0
			GOTO ERROR_2
		INSERT INTO #inputJobTable
		(jobId, jobLevel, cmpVal)
		SELECT @inJobID, @subclientLevel, @inSubClientId
		SET @jobLevelToTest = @subclientLevel
	END
	ELSE IF @inMemberServerXML.exist('exchOnePassOptions/pstIngestions') = 1
	BEGIN
		INSERT INTO #inputJobTable
		(jobId, jobLevel, cmpVal)
		SELECT
		@inJobID, @pstIngestionLevel, Tbl.Col.value('@pstTaskName', 'nvarchar(MAX)') as val
		FROM @inMemberServerXML.nodes('exchOnePassOptions/pstIngestions') as Tbl(Col)
		SET @jobLevelToTest = @pstIngestionLevel
	END
	ELSE
		GOTO ERROR_2
	DECLARE @JobIdInTest INT = 0
	DECLARE @testJobMemberServerXML  XML
	DECLARE @inputRecordsCount INT = (SELECT COUNT(*) FROM #inputJobTable)
	DECLARE @conflictingJobsRecordsCount INT = 0
	DECLARE checkJobId CURSOR
	FOR SELECT jobId FROM #listOfJobIdsToCheck
	OPEN checkJobId
	FETCH checkJobId INTO @JobIdInTest
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @testJobMemberServerXML = dbo.GetXMLJobOptions(@JobIdInTest).query('TMMsg_JobOption/backupOpts/exchOnePassOptions')
		TRUNCATE TABLE #checkConflictJobTable
		IF @jobLevelToTest = @mailBoxesLevel AND @testJobMemberServerXML.exist('exchOnePassOptions/mailBoxes') = 1
		BEGIN
			INSERT INTO #checkConflictJobTable
			(jobId, jobLevel, cmpVal)
			SELECT
			@JobIdInTest, @mailBoxesLevel, Tbl.Col.value('@userGUID', 'nvarchar(MAX)') as val
			FROM @testJobMemberServerXML.nodes('exchOnePassOptions/mailBoxes/user') as Tbl(Col)
		END
		ELSE IF @jobLevelToTest = @databasesLevel AND @testJobMemberServerXML.exist('exchOnePassOptions/databases') = 1
		BEGIN
			INSERT INTO #checkConflictJobTable
			(jobId, jobLevel, cmpVal)
			SELECT
			@JobIdInTest, @databasesLevel, Tbl.Col.value('@databaseName', 'nvarchar(MAX)') as val
			FROM @testJobMemberServerXML.nodes('exchOnePassOptions/databases') as Tbl(Col)
		END
		ELSE IF @jobLevelToTest = @adGroupsLevel AND @testJobMemberServerXML.exist('exchOnePassOptions/adGroups') = 1
		BEGIN
			INSERT INTO #checkConflictJobTable
			(jobId, jobLevel, cmpVal)
			SELECT
			@JobIdInTest, @adGroupsLevel, Tbl.Col.value('@adGroupName', 'nvarchar(MAX)') as val
			FROM @testJobMemberServerXML.nodes('exchOnePassOptions/adGroups') as Tbl(Col)
		END
		ELSE IF @jobLevelToTest = @contentStoreMailboxesLevel AND @testJobMemberServerXML.exist('exchOnePassOptions/contentStoreMailboxes') = 1
		BEGIN
			INSERT INTO #checkConflictJobTable
			(jobId, jobLevel, cmpVal)
			SELECT
			@JobIdInTest, @contentStoreMailboxesLevel, Tbl.Col.value('@userGUID', 'nvarchar(MAX)') as val
			FROM @testJobMemberServerXML.nodes('exchOnePassOptions/contentStoreMailboxes/user') as Tbl(Col)
		END
		ELSE IF @jobLevelToTest = @subclientLevel AND @testJobMemberServerXML.exist('exchOnePassOptions') = 0
		BEGIN
			INSERT INTO #checkConflictJobTable
			(jobId, jobLevel, cmpVal)
			SELECT
			@JobIdInTest, @subclientLevel, subclientID
			FROM #listOfJobIdsToCheck
			WHERE jobId = @JobIdInTest
		END
		ELSE IF @jobLevelToTest = @pstIngestionLevel AND @testJobMemberServerXML.exist('exchOnePassOptions/pstIngestions') = 1
		BEGIN
			INSERT INTO #checkConflictJobTable
			(jobId, jobLevel, cmpVal)
			SELECT
			@JobIdInTest, @pstIngestionLevel, Tbl.Col.value('@pstTaskName', 'nvarchar(MAX)') as val
			FROM @testJobMemberServerXML.nodes('exchOnePassOptions/pstIngestions') as Tbl(Col)
		END
		SET @conflictingJobsRecordsCount = (SELECT COUNT(*) FROM #checkConflictJobTable)
		IF @conflictingJobsRecordsCount <> 0 AND @inputRecordsCount <> 0 AND @inputRecordsCount = @conflictingJobsRecordsCount
		BEGIN
			DELETE FROM #checkConflictJobTable
			WHERE cmpVal IN (SELECT cmpVal FROM #inputJobTable)
			IF NOT EXISTS(SELECT TOP 1 * FROM  #checkConflictJobTable)
			BEGIN
				INSERT INTO #output VALUES (@JobIdInTest)
			END
		END
		FETCH checkJobId INTO @JobIdInTest
END
	CLOSE checkJobId
	DEALLOCATE checkJobId
	SELECT DISTINCT jobId FROM #output
ERROR_2:
	if OBJECT_ID('tempdb.dbo.#listOfJobIdsToCheck') is not null drop table dbo.#listOfJobIdsToCheck
	if OBJECT_ID('tempdb.dbo.#inputJobTable') is not null drop table dbo.#inputJobTable
	if OBJECT_ID('tempdb.dbo.#checkConflictJobTable') is not null drop table dbo.#checkConflictJobTable
	if OBJECT_ID('tempdb.dbo.#output') is not null drop table dbo.#output
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMCheckConflictingExchangeJob')
	delete from GxQscripts where name = 'JMCheckConflictingExchangeJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCheckConflictingExchangeJob')
	delete from GXDBVersions where aliasname = 'JMCheckConflictingExchangeJob'
GO

insert into GXDBVersions values(2, 'JMCheckConflictingExchangeJob',  '00010001000400070000', 'JMCheckConflictingExchangeJob', '00010001000400070000')
GO

