

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMCheckConflictingEdgeJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMCheckConflictingEdgeJob.sp,v $ $Id: JMCheckConflictingEdgeJob.sp,v 1.3.66.7 2018/03/22 03:13:24 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMCheckConflictingEdgeJob <<<'

IF EXISTS (select * from sysobjects where name='JMCheckConflictingEdgeJob')
	drop procedure JMCheckConflictingEdgeJob
IF EXISTS (select * from GxQscripts where name='JMCheckConflictingEdgeJob')
	delete from GxQscripts where name = 'JMCheckConflictingEdgeJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCheckConflictingEdgeJob')
	delete from GXDBVersions where aliasname = 'JMCheckConflictingEdgeJob'
GO
print '... Creating Procedure: JMCheckConflictingEdgeJob'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMCheckConflictingEdgeJob
  @inJobID int,
  @inOpType int,
  @inAppId int,
  @inProxyClientId int,
  @inSubtaskId int
AS
  DECLARE @conflictingJobID integer;
  DECLARE @conflictingJobState integer;
BEGIN
	DECLARE @output TABLE
	(jobId INT, jobState INT)
	DECLARE @storeType INT = 0
	SELECT @storeType = CAST (attrVal AS INT)
	FROM APP_Application APP WITH (NOLOCK)
	INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON APP.clientId = CP.componentNameId AND CP.attrName = 'System Drive Type' AND CP.modified = 0
	WHERE APP.id = @inAppId
	IF @inOpType = 4 -- BACKUP
	BEGIN
		IF @storeType = 5 -- MIGRATION_STORE
		BEGIN
			-- There is no restriction. Multiple jobs are allowed in parallel.
			GOTO ALL_DONE
		END
		If @inSubtaskId <> 0
		BEGIN
			-- Include unpicked jobs also
			INSERT @output
			SELECT J.jobId, 0
			FROM TM_JobRequest JR WITH (NOLOCK)
			INNER JOIN TM_Jobs J WITH (NOLOCK) ON JR.jobRequestId = J.jobRequestId
INNER JOIN TM_JobOptions JO1 WITH (NOLOCK) ON J.jobId = JO1.jobId AND JO1.optionId = 160000
INNER JOIN TM_JobOptions JO2 WITH (NOLOCK) ON JO2.jobId = JO1.jobId AND JO2.optionId = 140007
            WHERE JO2.value = @inAppId AND JR.subTaskId = @inSubtaskId AND status IN (0, 1, 4097) AND JO1.value = @inProxyClientId AND J.jobId <> @inJobID
		END
		INSERT @output
		SELECT BKP.jobId, JOB.state
		FROM JMBkpJobInfo BKP WITH (NOLOCK)
		INNER JOIN JMJobInfo JOB WITH (NOLOCK) ON JOB.jobId = BKP.jobId AND JOB.commCellId = BKP.commcellId
		WHERE BKP.applicationId = @inAppId
		AND BKP.jobId <> @inJobID
		AND BKP.targetClientId = @inProxyClientId
        AND JOB.opType = 4  /*BACKUP*/
	END
	ELSE IF @inOpType = 14 -- SYNTHFULL
	BEGIN
		INSERT @output
		SELECT BKP.jobId, JOB.state
		FROM JMBkpJobInfo BKP WITH (NOLOCK)
		INNER JOIN JMJobInfo JOB WITH (NOLOCK) ON JOB.jobId = BKP.jobId AND JOB.commCellId = BKP.commcellId
		WHERE BKP.applicationId = @inAppId
		AND BKP.jobId <> @inJobID
        AND JOB.opType = 14 /*SYNTHFULL*/
	END
ALL_DONE:
	SELECT DISTINCT jobId, jobState FROM @output
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMCheckConflictingEdgeJob')
	delete from GxQscripts where name = 'JMCheckConflictingEdgeJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCheckConflictingEdgeJob')
	delete from GXDBVersions where aliasname = 'JMCheckConflictingEdgeJob'
GO

insert into GXDBVersions values(2, 'JMCheckConflictingEdgeJob',  '00010003006600070000', 'JMCheckConflictingEdgeJob', '00010003006600070000')
GO

