

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMCheckConflictingCloudAppsV2Job.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMCheckConflictingCloudAppsV2Job')
BEGIN
	print '>>> Drop Stored Procedure: JMCheckConflictingCloudAppsV2Job <<<'
	drop procedure JMCheckConflictingCloudAppsV2Job
END
IF EXISTS (select * from GxQscripts where name='JMCheckConflictingCloudAppsV2Job')
	delete from GxQscripts where name = 'JMCheckConflictingCloudAppsV2Job'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCheckConflictingCloudAppsV2Job')
	delete from GXDBVersions where aliasname = 'JMCheckConflictingCloudAppsV2Job'
GO
print '... Creating Procedure: JMCheckConflictingCloudAppsV2Job'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMCheckConflictingCloudAppsV2Job
  @inJobID int,
  @inOpType int,
  @inSubOpType int,
  @inSubClientId int
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @conflictingJobID integer;
BEGIN
	if OBJECT_ID('tempdb.dbo.#incomingJobDetails') is not null drop table dbo.#incomingJobDetails
	create table #incomingJobDetails
	(
		jobId    integer,
		jobLevel    integer,
		cmpVal nvarchar(MAX)
	)
	if OBJECT_ID('tempdb.dbo.#existingJobs') is not null drop table dbo.#existingJobs
	create table #existingJobs
	(
		jobId    integer
	)
	if OBJECT_ID('tempdb.dbo.#existingJobDetails') is not null drop table dbo.#existingJobDetails
	create table #existingJobDetails
	(
		jobId    integer,
		jobLevel    integer,
		cmpVal nvarchar(MAX)
	)
	DECLARE @inCloudAppOptionsXML  XML
	DECLARE @jobLevelToTest	INTEGER
	DECLARE @subclientLevel INT = 1
	DECLARE @userLevel INT = 2
	DECLARE @userGroupLevel INT = 3
	IF @inOpType = 4 AND @inSubOpType = 0
	BEGIN
		INSERT INTO #existingJobs
		SELECT BJI.jobId
		FROM JMBkpJobInfo BJI
        INNER JOIN JMJobInfo JI ON
        BJI.jobId = JI.jobId AND
        BJI.commcellId = JI.commcellId
		WHERE BJI.applicationId = @inSubClientId AND JI.opType = @inOpType AND JI.subOpType = @inSubOpType AND JI.jobid <> @inJobID
	END
	ELSE
		GOTO proc_exit
	SET @inCloudAppOptionsXML = dbo.GetXMLJobOptions(@inJobid).query('TMMsg_JobOption/backupOpts/cloudAppOptions')
	IF @inCloudAppOptionsXML.exist('cloudAppOptions/userAccounts') = 1
	BEGIN
		SET @jobLevelToTest = @userLevel
		INSERT INTO #incomingJobDetails
		SELECT @inJobID, @jobLevelToTest, Tbl.Col.value('@userGUID', 'nvarchar(MAX)') as val
		FROM @inCloudAppOptionsXML.nodes('cloudAppOptions/userAccounts/user') as Tbl(Col)
		INSERT INTO #existingJobDetails
		SELECT jobId, @jobLevelToTest, (CAST(VALUE AS XML)).value('/userAccounts[1]/user[1]/@userGUID', 'NVARCHAR(MAX)') FROM #existingJobs
			CROSS APPLY dbo.GetJobOptionList(jobId,2070886949)  --CLOUDAPPBKPOPTION_USER_ACCOUNTS 2070886949
	END
	ELSE IF @inCloudAppOptionsXML.exist('cloudAppOptions/userGroups') = 1
	BEGIN
		SET @jobLevelToTest = @userGroupLevel
		INSERT INTO #incomingJobDetails
		SELECT @inJobID, @jobLevelToTest, Tbl.Col.value('@id', 'nvarchar(MAX)') as val
		FROM @inCloudAppOptionsXML.nodes('cloudAppOptions/userGroups') as Tbl(Col)
		INSERT INTO #existingJobDetails
		SELECT jobId, @jobLevelToTest, (CAST(VALUE AS XML)).value('/userGroups[1]/@id', 'NVARCHAR(MAX)') FROM #existingJobs
			CROSS APPLY dbo.GetJobOptionList(jobId,2015044343)  --CLOUDAPPOPTIONS_USER_GROUPS 2015044343
	END
	ELSE IF @inCloudAppOptionsXML.exist('cloudAppOptions') = 0
	BEGIN
		IF @inSubClientId = 0
			GOTO proc_exit
		SET @jobLevelToTest = @subclientLevel
		INSERT INTO #incomingJobDetails
		SELECT @inJobID, @jobLevelToTest, @inSubClientId
		INSERT INTO #existingJobDetails
		SELECT EJ.jobId, @jobLevelToTest, @inSubClientId
			FROM #existingJobs EJ
				OUTER APPLY dbo.GetJobOptionList(EJ.jobId,2070886949) as V1 --CLOUDAPPBKPOPTION_USER_ACCOUNTS 2070886949
				OUTER APPLY dbo.GetJobOptionList(EJ.jobId,2015044343) as V2 --CLOUDAPPOPTIONS_USER_GROUPS 2015044343
			WHERE V1.value IS NULL AND V2.value IS NULL
	END
	ELSE
		GOTO proc_exit
	SELECT DISTINCT EJ.jobId FROM #existingJobDetails EJ
		INNER JOIN #incomingJobDetails IJ ON IJ.cmpVal = EJ.cmpVal
proc_exit:
	if OBJECT_ID('tempdb.dbo.#existingJobs') is not null drop table dbo.#existingJobs
	if OBJECT_ID('tempdb.dbo.#incomingJobDetails') is not null drop table dbo.#incomingJobDetails
	if OBJECT_ID('tempdb.dbo.#existingJobDetails') is not null drop table dbo.#existingJobDetails
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMCheckConflictingCloudAppsV2Job')
	delete from GxQscripts where name = 'JMCheckConflictingCloudAppsV2Job'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCheckConflictingCloudAppsV2Job')
	delete from GXDBVersions where aliasname = 'JMCheckConflictingCloudAppsV2Job'
GO

insert into GXDBVersions values(2, 'JMCheckConflictingCloudAppsV2Job',  '00000000000000000000', 'JMCheckConflictingCloudAppsV2Job', '00000000000000000000')
GO

