

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMCanEdgeSynthFulRun.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--			Author: Gokul Pattabiraman
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMCanEdgeSynthFulRun <<<'

IF EXISTS (select * from sysobjects where name='JMCanEdgeSynthFulRun')
	drop procedure JMCanEdgeSynthFulRun
IF EXISTS (select * from GxQscripts where name='JMCanEdgeSynthFulRun')
	delete from GxQscripts where name = 'JMCanEdgeSynthFulRun'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCanEdgeSynthFulRun')
	delete from GXDBVersions where aliasname = 'JMCanEdgeSynthFulRun'
GO
print '... Creating Procedure: JMCanEdgeSynthFulRun'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMCanEdgeSynthFulRun
  @inAppId INTEGER
AS
  DECLARE @outLastFullTime INT
  DECLARE @outLastIncrTime INT
  DECLARE @outCanRun INT
SET NOCOUNT ON
SET @outLastFullTime = 0
SET @outLastIncrTime = 0
SET @outCanRun = 0
SET @outLastFullTime = ISNULL((SELECT TOP 1 servEndDate
										  FROM JMBkpStats BKP
										  WHERE appId = @inAppId
										  AND bkpLevel IN (1/*FULL*/, 64/*SYNTHETIC_FULL*/, 128 /*SYNTHETIC_FULL_AND_INCR*/)
										  AND status IN (1/*JMSUCCESS*/)
										  ORDER BY servEndDate DESC), 0)
SET @outLastIncrTime = ISNULL((SELECT TOP 1 servEndDate
										  FROM JMBkpStats BKP
										  WHERE appId = @inAppId
										  AND bkpLevel IN (2/*INCR*/, 4/*DIFFERENTIAL*/)
										  AND status IN (1/*JMSUCCESS*/)
										  ORDER BY servEndDate DESC), 0)
IF @outLastFullTime > 0 AND @outLastIncrTime > @outLastFullTime
	SET @outCanRun = 1
SELECT @outLastFullTime, @outLastIncrTime, @outCanRun
GO

IF EXISTS (select * from GxQscripts where name = 'JMCanEdgeSynthFulRun')
	delete from GxQscripts where name = 'JMCanEdgeSynthFulRun'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCanEdgeSynthFulRun')
	delete from GXDBVersions where aliasname = 'JMCanEdgeSynthFulRun'
GO

insert into GXDBVersions values(2, 'JMCanEdgeSynthFulRun',  '00000000000000000000', 'JMCanEdgeSynthFulRun', '00000000000000000000')
GO

