

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMCalculateNextBackupLevel.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   09/21/2006
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMCalculateNextBackupLevel.sp,v $ $Id: JMCalculateNextBackupLevel.sp,v 1.1.2.13.4.1 2021/05/05 18:11:09 sbonilla Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMCalculateNextBackupLevel')
BEGIN
	print '>>> Drop Stored Procedure: JMCalculateNextBackupLevel <<<'
	drop procedure JMCalculateNextBackupLevel
END
IF EXISTS (select * from GxQscripts where name='JMCalculateNextBackupLevel')
	delete from GxQscripts where name = 'JMCalculateNextBackupLevel'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCalculateNextBackupLevel')
	delete from GXDBVersions where aliasname = 'JMCalculateNextBackupLevel'
GO
print '... Creating Procedure: JMCalculateNextBackupLevel'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMCalculateNextBackupLevel
  @i_subclientId INT,
  @i_appTypeId INT,
  @i_backupLevel INT OUTPUT,
  @i_taskId INT
AS
  DECLARE @o_backupLevel INT = @i_backupLevel
	DECLARE @nowUtcTime DATETIME = GETUTCDATE()
	DECLARE @nowUtcUnix INT = datediff(second, '01/01/1970', @nowUtcTime)
    DECLARE @lastBackup INT = 0
	DECLARE @commcellId INT = 0
	DECLARE @clientId INT = 0
	DECLARE @instanceId INT = 0
	DECLARE @backupSetId INT = 0
    DECLARE @newBackupLevel INT = 1 --FULL
DECLARE @planId INT = ISNULL((SELECT attrVal from APP_SubClientProp where componentNameId = @i_subclientId and modified = 0 and cs_attrName = checksum(N'Associated Plan') and attrName = 'Associated Plan'),0)
	DECLARE @numOfDefaultDays INT = -1
	IF @planId > 0
SET @numOfDefaultDays = ISNULL(dbo.AppPlanGetEntityValueV2(@planId, 'Days between auto convert of DB backup job', 0), -1)
	IF @numOfDefaultDays = -1
		SET @numOfDefaultDays = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='NumberOfDaysBetweenAutoConvertBackupLevel'), 7)
    DECLARE @allFullBackupLevel INT = 1 | 0x8000  --FULL, SEL_ONLINE_FULL
	DECLARE @numOfDays INT = @numOfDefaultDays
    DECLARE @backupInterval INT = 0
    DECLARE @diffInterval INT = 0
    DECLARE @checkForDifferential INT = 0
	DECLARE @isOperationAllowed INT = 0
	DECLARE @OperationmatchLevel INT
	DECLARE @utilization INT
    --IF BACKUP LEVEL IS ALREADY FULL THERE'S NO NEED TO DO ANY CALCULATION
    IF @o_backupLevel & @allFullBackupLevel <> 0
        GOTO EXIT_BACKUP_LEVEL
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	--For APPGRP_SqlServerAppType compare last differential to last full size; convert to full if the last differential is 75% of the last full
	IF EXISTS(SELECT 1 FROM dbo.GetAppTypesForAppGroup(82, 0) WHERE appTypeId = @i_appTypeId) --APPGRP_SqlServerAppType
	BEGIN
		--CHECK IF FULL BACKUP LEVEL IS ALLOWED BY AN OPERATION WINDOW
		SELECT @commcellId=origCCId, @clientId=clientId, @instanceId=instance, @backupSetId=backupSet
		FROM APP_Application (NOLOCK)
		WHERE id = @i_subclientId
		SELECT @isOperationAllowed=isOperationAllowed, @OperationmatchLevel=MatchLevel, @utilization=utilization
		FROM IsOperationAllowedAndMatchedLevel(@newBackupLevel, @commcellId, @clientId, @i_appTypeId, @instanceId, @backupSetId, @i_subclientId, 0, 0)
		IF @isOperationAllowed = 1
		BEGIN
			DECLARE @lastDiffSize BIGINT = 0
			DECLARE @lastFullSize BIGINT = 0
			DECLARE @fullCycleNum INT = 0
			SELECT TOP 1 @lastFullSize = totalUncompBytes, @fullCycleNum = fullCycleNum
			FROM JMBkpStats (NOLOCK)
			WHERE appId = @i_subclientId AND bkpLevel = 1 --FULL
			AND status IN (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
			ORDER BY servEndDate DESC
			IF @lastFullSize > 0
			BEGIN
				SELECT TOP 1 @lastDiffSize = totalUncompBytes
				FROM JMBkpStats (NOLOCK)
				WHERE appId = @i_subclientId AND bkpLevel = 4 --DIFFERENTIAL
				AND fullCycleNum IN (@fullCycleNum)
				AND status IN (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
				ORDER BY servEndDate DESC
				IF @lastDiffSize > 0
				BEGIN
					IF CAST(@lastDiffSize AS FLOAT) / CAST(@lastFullSize AS FLOAT) > .75 --then promote to FULL
					BEGIN
						SET @o_backupLevel = @newBackupLevel
						GOTO EXIT_BACKUP_LEVEL
					END
				END
			END
		END
	END
	--FOR SQL RUN DAILY DIFFERENTIAL/Incremental AND WEEKLY FULL
	--For DB Agents run differential as per RPO and run weekly full
    IF EXISTS(SELECT 1 FROM dbo.GetAppTypesForAppGroup(82, 0)   --APPGRP_SqlServerAppType
        WHERE appTypeId = @i_appTypeId)
    BEGIN
        SET @numOfDays = @numOfDefaultDays
        SET @checkForDifferential = 1
    END
	ELSE IF EXISTS(SELECT 1 FROM dbo.AppGetDBAppTypesForDiffPlanProcessing() WHERE appTypeId = @i_appTypeId )	--DB agents. run weekly full
	BEGIN
		--ONLY CHANGE BACKUP LEVEL FOR THESE CLOUD APPS INSTANCES (AMAZON_DYNAMODB)
		IF @i_appTypeId = 134	--CV_APPTYPE_CLOUD_APPS
		BEGIN
			SELECT @instanceId=instance
			FROM APP_Application
			WHERE id = @i_subclientId
			IF NOT EXISTS(
						SELECT 1 FROM APP_InstanceProp
						WHERE componentNameId = @instanceId
						AND attrName = 'Cloud Apps Instance Type'
						AND attrVal IN (N'22')	--AMAZON_DYNAMODB
					)
				GOTO EXIT_BACKUP_LEVEL
		END
		SET @numOfDays = @numOfDefaultDays
	END
	ELSE
        GOTO EXIT_BACKUP_LEVEL
    SET @backupInterval = @nowUtcUnix-(@numOfDays*24*60*60)
	IF EXISTS(SELECT 1 FROM TM_SubtaskOptions (NOLOCK) INNER JOIN TM_Subtask (NOLOCK) ON
			TM_SubtaskOptions.subtaskid = TM_Subtask.subtaskID AND TM_Subtask.taskID = @i_taskId
AND TM_SubtaskOptions.optionID = 458405394
			AND TM_SubTaskOptions.value='1') -- full backup level
	BEGIN
		SET @lastBackup = dbo.getunixtime(getutcdate())
		-- Set last backup time  as current utc time so that interval hasnt passed and backup doesnt get converted to FULL.
	END
	ELSE
	BEGIN
		--CHECK FOR FULL INTERVAL FIRST
		SELECT @lastBackup = ISNULL(MAX(servStartDate), 0)
		FROM
		(
			SELECT servStartDate
			FROM JMBkpStats
			WHERE appId = @i_subclientId
			AND bkpLevel & @allFullBackupLevel <> 0
			AND status IN (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
			UNION ALL	--CHEKC ALSO FOR SF JOBS
			SELECT servStartDate
			FROM JMBkpStats
			WHERE appId = @i_subclientId
			AND bkpLevel = 64	--SYNTHETIC FULL
			AND @checkForDifferential = 0
			AND status IN (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
		) T
	END
	--FOR SQL IF FULL INTERVAL HAS NOT RUN THEN CHECK IF DIFFERENTIAL NEEDS TO RUN
    IF @lastBackup > @backupInterval AND @checkForDifferential = 1
    BEGIN
        SET @newBackupLevel = 4 --DIFFERENTIAL
	    SET @numOfDays = 1
	    SET @backupInterval = @nowUtcUnix-(@numOfDays*24*60*60)
	SELECT @lastBackup = ISNULL(MAX(servStartDate), @lastBackup)
        FROM JMBkpStats
        WHERE appId = @i_subclientId
        AND bkpLevel = @newBackupLevel
        AND status IN (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
    END
	ELSE
	BEGIN
		IF EXISTS(SELECT 1 FROM APP_SubClientProp (NOLOCK)
		WHERE componentNameId = @i_subclientId
		AND modified = 0
		AND attrName = 'Oracle Online Selective Full'
		AND cs_attrName = CHECKSUM(N'Oracle Online Selective Full')
		AND attrVal = '1')
			SET @newBackupLevel = 0x8000	--SEL_ONLINE_FULL
	END
	--CHECK IF DEFAULT BACKUP INTERVAL HAS PASSED
    IF @lastBackup < @backupInterval
    BEGIN
	    SELECT @commcellId=origCCId, @clientId=clientId, @instanceId=instance, @backupSetId=backupSet
	    FROM APP_Application
	    WHERE id = @i_subclientId
		--CHECK IF THERE IS BACKUP LEVEL IS ALLOWED BY AN OPERATION WINDOW
	    SELECT @isOperationAllowed=isOperationAllowed, @OperationmatchLevel=MatchLevel, @utilization=utilization
	    FROM IsOperationAllowedAndMatchedLevel(@newBackupLevel, @commcellId, @clientId, @i_appTypeId, @instanceId, @backupSetId, @i_subclientId, @i_taskId, 0)
    END
    IF @isOperationAllowed = 1
        SET @o_backupLevel = @newBackupLevel
EXIT_BACKUP_LEVEL:
    SELECT @o_backupLevel
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'JMCalculateNextBackupLevel')
	delete from GxQscripts where name = 'JMCalculateNextBackupLevel'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCalculateNextBackupLevel')
	delete from GXDBVersions where aliasname = 'JMCalculateNextBackupLevel'
GO

insert into GXDBVersions values(2, 'JMCalculateNextBackupLevel',  'v1.1.2.13.4.1', 'JMCalculateNextBackupLevel', 'v1.1.2.13.4.1')
GO

