

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMCalculateDynamicPhasePercentages.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +=================================================================================+
--  |   Procedure:  JMCalculateDynamicPhasePercentages()
--  |
--  | Description:  Updates the dynamic phase percentages for a subclient
--  |
--  |       Input:  appId, opType, subOptype, bkpLevel, isDataSP, isLogSP, isDiffSP
--  |
--  |      Output:  Dynamic phase percentage string
-- 	|
--  |      Return:  xxx
--	|
--	|		 Flow:  1. Retunrs back without doing anything if there is a  valid prop
--	|				   that is set in the last 12 hours.
--	|				2. Gets the last 100 clean(jobs with no phase reattempts) jobs
--	|				   with the specified opType, subOpType, bkpLevel, isDataSP,
--	|				   isLogSP, isDiffSP for the appId.
--	|				3. It also calculates the weighted mean as 0.01, 0.02...0.99, 1
--	|				   with the most recent job having the max weight.
--	|				4. Then it calculates the dynamic phase percentages using the
--	|				   weight previous calculated.
--	|				5. It then inserts this percentage string into the subclient
--	|				   prop table for future use.
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------------------	        --------------------------------
--  |   1.1        Jawahar Ragunathan           Initial Edit
--  +=================================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMCalculateDynamicPhasePercentages')
BEGIN
	print '>>> Drop Stored Procedure: JMCalculateDynamicPhasePercentages <<<'
	drop procedure JMCalculateDynamicPhasePercentages
END
IF EXISTS (select * from GxQscripts where name='JMCalculateDynamicPhasePercentages')
	delete from GxQscripts where name = 'JMCalculateDynamicPhasePercentages'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCalculateDynamicPhasePercentages')
	delete from GXDBVersions where aliasname = 'JMCalculateDynamicPhasePercentages'
GO
print '... Creating Procedure: JMCalculateDynamicPhasePercentages'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMCalculateDynamicPhasePercentages
  @i_commcellId INT,
  @i_appId INT,
  @i_opType INT,
  @i_subOpType INT,
  @i_bkpLevel INT,
  @i_isDataSP INT,
  @i_isLogSP INT,
  @i_isDiffSP INT
AS
  DECLARE @dynamicPhasePercentages nvarchar(1024)
  DECLARE @dynamicPhaseTimings nvarchar(1024)
SET NOCOUNT ON
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	IF OBJECT_ID('tempdb.dbo.#jobsWithWeightage') IS NOT NULL DROP TABLE #jobsWithWeightage
	CREATE TABLE #jobsWithWeightage(jobId INT, totalElapsedTime FLOAT, weightage FLOAT)
	DECLARE @percentageListAttrName nvarchar(128);
	DECLARE @percentageListAttrVal nvarchar(1024) = '';
	SET @percentageListAttrName = 'Dynamic Phase Percentages_' + CONVERT(NVARCHAR(8), @i_opType) + '_' + CONVERT(NVARCHAR(8), @i_subOpType) + '_' + CONVERT(NVARCHAR(8), @i_bkpLevel)
																	+ '_' + CONVERT(NVARCHAR(8), @i_isDataSP) + '_' + CONVERT(NVARCHAR(8), @i_isLogSP) + '_' + CONVERT(NVARCHAR(8), @i_isDiffSP)
	DECLARE @timingsListAttrName nvarchar(128);
	DECLARE @timingsListAttrVal nvarchar(1024) = '';
	SET @timingsListAttrName = 'Dynamic Phase Timings_' + CONVERT(NVARCHAR(8), @i_opType) + '_' + CONVERT(NVARCHAR(8), @i_subOpType) + '_' + CONVERT(NVARCHAR(8), @i_bkpLevel)
															+ '_' + CONVERT(NVARCHAR(8), @i_isDataSP) + '_' + CONVERT(NVARCHAR(8), @i_isLogSP) + '_' + CONVERT(NVARCHAR(8), @i_isDiffSP)
	DECLARE @nowTime INT = dbo.GetUnixTime (GetUTCdate());
	IF EXISTS(SELECT 0 FROM APP_SubClientProp WHERE componentNameId = @i_appId AND attrName = @percentageListAttrName AND cs_attrName = CHECKSUM(@percentageListAttrName) AND (created > (@nowTime-(12*60*60))) and modified = 0)
		GOTO proc_exit;
	DECLARE @sumOfWeights FLOAT = 0;
	DECLARE @minJobs INT;
	DECLARE @maxJobs INT;
	DECLARE @noOfJobs INT;
	SELECT @minJobs = CONVERT(INT, value) FROM GXGlobalParam WHERE name = 'JMMinJobsForDynamicPhasePercentageCalc'
	IF (@minJobs IS NULL) SET @minJobs = 5;
	SELECT @maxJobs = CONVERT(INT, value) FROM GXGlobalParam WHERE name = 'JMMaxJobsForDynamicPhasePercentageCalc'
	IF (@maxJobs IS NULL) SET @maxJobs = 100;
	INSERT INTO #jobsWithWeightage
	SELECT TOP (@maxJobs) JAS.jobId, SUM(elapsedTime), (ROW_NUMBER() over(ORDER BY JAS.jobId desc)) FROM JMBkpAtmptStats JAS WITH(NOLOCK)
			INNER JOIN JMBkpStats JBS WITH(NOLOCK) ON JAS.jobId = JBS.jobId AND JBS.appId = @i_appId AND JBS.opType = @i_opType AND JBS.bkpLevel = @i_bkpLevel AND JBS.status = 1
			INNER JOIN JMJobStats JS WITH(NOLOCK) ON JS.jobId = JAS.jobId AND JS.subOpType = @i_subOpType
			WHERE ((@i_isDataSP = 0 AND JBS.dataArchGrpId = 0) OR (@i_isDataSP <> 0 AND JBS.dataArchGrpId <> 0))
					AND ((@i_isLogSP = 0 AND JBS.logArchGrpId = 0) OR (@i_isLogSP <> 0 AND JBS.logArchGrpId <> 0))
					AND ((@i_isDiffSP = 0 AND JBS.diffArchGrpId = 0) OR (@i_isDiffSP <> 0 AND JBS.diffArchGrpId <> 0))
			GROUP BY JAS.jobId HAVING MAX(NUMBER) = 1 AND SUM(elapsedTime) > 0 AND COUNT(0) > 1
	SELECT @noOfJobs = COUNT(0) FROM #jobsWithWeightage
	IF (@noOfJobs < @minJobs)
		GOTO proc_exit;
	UPDATE #jobsWithWeightage SET weightage = ((@noOfJobs - weightage + 1) / CONVERT(FLOAT, @noOfJobs))
	SELECT @sumOfWeights = SUM(weightage) FROM #jobsWithWeightage
	SELECT @percentageListAttrVal =
				 '0,' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([1]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([2]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([3]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([4]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([5]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([6]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([7]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([8]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([9]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([10]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([11]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([12]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([13]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([14]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([15]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([16]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([17]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([18]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([19]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([20]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([21]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([22]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([23]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([24]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([25]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([26]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([27]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([28]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([29]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([30]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([31]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([32]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([33]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([34]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum(([35]/totalElapsedTime)*100*weightage)/@sumOfWeights, 0))),
			@timingsListAttrVal =
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([1]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([2]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([3]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([4]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([5]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([6]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([7]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([8]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([9]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([10]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([11]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([12]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([13]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([14]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([15]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([16]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([17]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([18]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([19]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([20]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([21]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([22]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([23]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([24]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([25]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([26]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([27]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([28]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([29]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([30]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([31]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([32]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([33]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([34]*weightage)/@sumOfWeights, 0))) + ',' +
				 CONVERT(NVARCHAR(8), FLOOR(ISNULL(sum([35]*weightage)/@sumOfWeights, 0)))
	FROM
	(select JAS.phase, elapsedTime, JAS.jobId from JMBkpAtmptStats JAS WITH(NOLOCK)) src
	PIVOT
	(
		min (elapsedTime)
		FOR phase IN
		([0], [1], [2], [3], [4], [5], [6], [7], [8], [9], [10], [11], [12], [13], [14], [15], [16], [17], [18], [19], [20], [21], [22], [23], [24], [25], [26], [27], [28], [29], [30], [31], [32], [33], [34], [35])
	) AS pvt
	INNER JOIN #jobsWithWeightage JW on pvt.jobId = JW.jobid
	UPDATE APP_SubClientProp WITH (ROWLOCK) SET attrVal = @percentageListAttrVal, created = @nowTime
		WHERE componentNameId = @i_appId AND attrName = @percentageListAttrName AND cs_attrName = CHECKSUM(@percentageListAttrName) AND attrType = 1 AND modified = 0
	IF @@ROWCOUNT = 0
		INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType,  attrVal, created, modified, ccpId)
			VALUES (@i_appId, @percentageListAttrName, 1, @percentageListAttrVal, @nowTime, 0, 0)
	UPDATE APP_SubClientProp WITH (ROWLOCK) SET attrVal = @timingsListAttrVal, created = @nowTime
		WHERE componentNameId = @i_appId AND attrName = @timingsListAttrName AND cs_attrName = CHECKSUM(@timingsListAttrName) AND attrType = 1 AND modified = 0
	IF @@ROWCOUNT = 0
		INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType,  attrVal, created, modified, ccpId)
			VALUES (@i_appId, @timingsListAttrName, 1, @timingsListAttrVal, @nowTime, 0, 0)
proc_exit:
	SELECT @percentageListAttrVal as 'PercentageList', @timingsListAttrVal as 'RunTimeList';
	IF OBJECT_ID('tempdb.dbo.#jobsWithWeightage') IS NOT NULL DROP TABLE #jobsWithWeightage
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMCalculateDynamicPhasePercentages')
	delete from GxQscripts where name = 'JMCalculateDynamicPhasePercentages'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCalculateDynamicPhasePercentages')
	delete from GXDBVersions where aliasname = 'JMCalculateDynamicPhasePercentages'
GO

insert into GXDBVersions values(2, 'JMCalculateDynamicPhasePercentages',  '00000000000000000000', 'JMCalculateDynamicPhasePercentages', '00000000000000000000')
GO

