

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMCDRSetFailureReason.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--      Author: Eugene Volohov
--      Date:   28/11/2006
--
--      | Input:                pairID  - pair id
--                                                          status      - initial status
--
--      | Output:               jobId   - job id
--                                                              existed - job existing flag
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMCDRSetFailureReason.sp,v $ $Id: JMCDRSetFailureReason.sp,v 1.6.210.1 2018/03/22 03:07:11 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMCDRSetFailureReason <<<'

IF EXISTS (select * from sysobjects where name='JMCDRSetFailureReason')
	drop procedure JMCDRSetFailureReason
IF EXISTS (select * from GxQscripts where name='JMCDRSetFailureReason')
	delete from GxQscripts where name = 'JMCDRSetFailureReason'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCDRSetFailureReason')
	delete from GXDBVersions where aliasname = 'JMCDRSetFailureReason'
GO
print '... Creating Procedure: JMCDRSetFailureReason'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMCDRSetFailureReason
  @jobId INTEGER,
  @messageId INTEGER,
  @serialId INTEGER,
  @append INTEGER,
  @localeId INTEGER
AS
  DECLARE @success INTEGER
	DECLARE		@failureMessage NVARCHAR(1024)
	DECLARE		@idVal NVARCHAR(255)
	DECLARE		@existingText NVARCHAR(4000)
	DECLARE @defaultCCId INT = 2
	IF @messageId = 0 BEGIN
		-- just clean up failure reason message
		-- clean up 'main' table
		UPDATE	JMCdrJobs
		SET		failureReason = N''
		WHERE	JMCdrJobs.jobId = @jobId
		and		JMCdrJobs.commCellId = @defaultCCId
		-- we do not have to clean up attempts table, because attempts are not restartable
	END
	ELSE BEGIN
--		SET @idVal = CAST(123 as NVARCHAR) + N','
--		SELECT @failureMessage = dbo.JMGetLocalizedMessageFunc( @localeId, @idVal )
		SET @failureMessage = CAST(@serialId as NVARCHAR)
		IF LEN( @failureMessage ) > 0 BEGIN
			SET @success = 1
			IF @append = 1 BEGIN
				-- getting current conent
				SELECT	@existingText = JMCdrJobs.failureReason
				FROM	JMCdrJobs
				WHERE	JMCdrJobs.jobId = @jobId
				and		JMCdrJobs.commCellId = @defaultCCId
				SET @existingText = @existingText + @failureMessage + N','
				-- update main table
				UPDATE	JMCdrJobs
				SET		failureReason = @existingText
				WHERE	JMCdrJobs.jobId = @jobId
				and		JMCdrJobs.commCellId = @defaultCCId
				-- update attempts table
				UPDATE	JMCdrAttempts
				SET		failureReason = @existingText
				WHERE	(JMCdrAttempts.jobId = @jobId)
				and		JMCdrAttempts.commCellId = @defaultCCId
				and (JMCdrAttempts.id = (select max(JMCdrAttempts.id) from JMCdrAttempts where jobId =  @jobId and commCellId = @defaultCCId))
			END
			ELSE BEGIN
				-- update main table
				UPDATE	JMCdrJobs
				SET		failureReason = @failureMessage + N','
				WHERE	JMCdrJobs.jobId = @jobId
				and		JMCdrJobs.commCellId = @defaultCCId
				-- update attempts table
				UPDATE	JMCdrAttempts
				SET		failureReason = @failureMessage + N','
				WHERE	(JMCdrAttempts.jobId = @jobId)
				and		JMCdrAttempts.commCellId = @defaultCCId
				and (JMCdrAttempts.id = (select max(JMCdrAttempts.id) from JMCdrAttempts where jobId =  @jobId and commCellId = @defaultCCId))
			END
		END
		ELSE BEGIN
			SET @success = 0
		END
	END
    SELECT @success
GO

IF EXISTS (select * from GxQscripts where name = 'JMCDRSetFailureReason')
	delete from GxQscripts where name = 'JMCDRSetFailureReason'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCDRSetFailureReason')
	delete from GXDBVersions where aliasname = 'JMCDRSetFailureReason'
GO

insert into GXDBVersions values(2, 'JMCDRSetFailureReason',  '00010006021000010000', 'JMCDRSetFailureReason', '00010006021000010000')
GO

