

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMBuildFailureReasonCache.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Gokul Pattabiraman
--	Date:   11/15/2010
-- ----------------------------------------------------------------------*/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMBuildFailureReasonCache <<<'

IF EXISTS (select * from sysobjects where name='JMBuildFailureReasonCache')
	drop procedure JMBuildFailureReasonCache
IF EXISTS (select * from GxQscripts where name='JMBuildFailureReasonCache')
	delete from GxQscripts where name = 'JMBuildFailureReasonCache'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMBuildFailureReasonCache')
	delete from GXDBVersions where aliasname = 'JMBuildFailureReasonCache'
GO
print '... Creating Procedure: JMBuildFailureReasonCache'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMBuildFailureReasonCache
  @i_jobId INTEGER,
  @i_commCellId INTEGER,
  @i_reasonCode varchar(256),
  @i_localeId INTEGER,
  @i_clearOldCache INTEGER
AS
SET NOCOUNT ON
IF @i_clearOldCache = 1
BEGIN
	DELETE FROM JMFailureReasonLocaleMsgCache
	WHERE jobID = @i_jobId AND commCellId = @i_commCellId AND localeID = @i_localeId
END
IF @i_reasonCode <> ''
	AND NOT EXISTS ( SELECT 1 FROM JMFailureReasonLocaleMsgCache WITH (NOLOCK)
				WHERE jobID = @i_jobId AND commCellId = @i_commCellId AND reasonCode = @i_reasonCode
				AND localeID = @i_localeId)
BEGIN
	DECLARE @localisedString nvarchar(2048)
	SELECT @localisedString = dbo.JMGetLocalizedMessageFunc(@i_localeId,@i_reasonCode)
	INSERT INTO JMFailureReasonLocaleMsgCache
	VALUES(@i_jobId, @i_commCellId, @i_reasonCode, @i_localeId, @localisedString)
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMBuildFailureReasonCache')
	delete from GxQscripts where name = 'JMBuildFailureReasonCache'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMBuildFailureReasonCache')
	delete from GXDBVersions where aliasname = 'JMBuildFailureReasonCache'
GO

insert into GXDBVersions values(2, 'JMBuildFailureReasonCache',  '00000000000000000000', 'JMBuildFailureReasonCache', '00000000000000000000')
GO

