

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMAreAdminJobsRunningForArchGroupCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMAreAdminJobsRunningForArchGroupCopy.sp,v $ $Id: JMAreAdminJobsRunningForArchGroupCopy.sp,v 1.1.2.6 2020/05/10 01:17:05 pveeravalli Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMAreAdminJobsRunningForArchGroupCopy')
BEGIN
	print '>>> Drop Stored Procedure: JMAreAdminJobsRunningForArchGroupCopy <<<'
	drop procedure JMAreAdminJobsRunningForArchGroupCopy
END
IF EXISTS (select * from GxQscripts where name='JMAreAdminJobsRunningForArchGroupCopy')
	delete from GxQscripts where name = 'JMAreAdminJobsRunningForArchGroupCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMAreAdminJobsRunningForArchGroupCopy')
	delete from GXDBVersions where aliasname = 'JMAreAdminJobsRunningForArchGroupCopy'
GO
print '... Creating Procedure: JMAreAdminJobsRunningForArchGroupCopy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMAreAdminJobsRunningForArchGroupCopy
  @i_copyId integer,
  @i_ignoreSuspendedJobs integer = 0,
  @i_opType varchar(1024)= ''
AS
  DECLARE @o_areJobsRunning tinyint;
  DECLARE @o_runningJobIds varchar(MAX);
SET NOCOUNT ON
IF OBJECT_ID('tempdb..#lt_Copies') IS NOT NULL DROP TABLE #lt_Copies
CREATE TABLE #lt_Copies (copyId smallint, archGroupId int)
IF OBJECT_ID('tempdb..#tmpRunningJobs') IS NOT NULL DROP TABLE #tmpRunningJobs
CREATE TABLE #tmpRunningJobs (jobId BIGINT)
DECLARE @l_archGroupId integer
DECLARE @l_dedupeFlags integer
DECLARE @l_extendedFlags integer
SELECT	@l_archGroupId = archGroupId, @l_dedupeFlags = dedupeFlags, @l_extendedFlags = extendedFlags
FROM	archGroupCopy WITH(READUNCOMMITTED)
WHERE	id = @i_copyId
INSERT INTO #lt_Copies
SELECT @i_copyId, @l_archGroupId
--If input copy is global policy get all dependent copies
IF (@l_extendedFlags & (1 | 4096)) > 0
OR (@l_dedupeFlags & 268435456) > 0
BEGIN
    INSERT  INTO #lt_Copies
    SELECT  DC.id, DC.archGroupId
    FROM    #lt_Copies I
            INNER JOIN archCopyToGlobalPolicy DC2GAG WITH (READUNCOMMITTED) ON DC2GAG.globalPolicyId = I.archGroupId
            INNER JOIN archGroupCopy DC WITH (READUNCOMMITTED) ON DC.id = DC2GAG.copyId
END
--if input copy is dependent of global get global policy copy
ELSE IF (@l_extendedFlags & (2 | 8192)) > 0
OR (@l_dedupeFlags & 134217728) > 0
BEGIN
	INSERT 	INTO #lt_Copies
	SELECT  GAG.defaultCopy, GAG.Id
	FROM    #lt_Copies I
			INNER JOIN archCopyToGlobalPolicy DC2GAG WITH (READUNCOMMITTED) ON DC2GAG.copyId = I.copyId
			INNER JOIN archGroup GAG WITH(READUNCOMMITTED) ON  GAG.Id = DC2GAG.globalPolicyId
END
--Populate transitive copies
INSERT 	INTO #lt_Copies
SELECT 	TC.id, TC.archGroupId
FROM	#lt_Copies C,
		archCopyMediaRefreshProp MR WITH (READUNCOMMITTED),
		archGroupCopy TC WITH (READUNCOMMITTED)
WHERE	MR.copyId = C.copyId
		AND MR.targetCopyId = TC.id
AND TC.type = 5
--Check admin jobs are running to any of the above copies
DECLARE @SQLQuery nvarchar(max) =
N'
	INSERT INTO #tmpRunningJobs
	SELECT 	J.jobId
	FROM 	JMAdminJobInfoTable J WITH(READUNCOMMITTED),
			JMJobInfo JI WITH(READUNCOMMITTED), #lt_Copies C
	WHERE
		J.jobId = JI.jobId AND J.commCellId = JI.commCellId
		AND
		(
			J.archGrpCopyID = C.copyId
			OR
			(
				J.archGrpID = C.archGroupId
				AND
					(
						CASE
							WHEN J.opType IN (13 /*AUXCOPY*/, 74 /*MEDIAREFRESHING*/)
								THEN (CASE WHEN EXISTS(SELECT 1 FROM archChunkToCopy WITH(READUNCOMMITTED) WHERE adminJobId = J.jobId
									AND (destCopyId = C.copyId OR archCopyId = C.copyId)) THEN 1 ELSE 0 END)
							WHEN J.opType = 104 /*AUXCOPY2*/
								THEN (CASE WHEN EXISTS(SELECT 1 FROM archChunkToReplicate WITH(READUNCOMMITTED) WHERE adminJobId = J.jobId
									AND (destCopyId = C.copyId OR SrcCopyId = C.copyId)) THEN 1 ELSE 0 END)
							WHEN J.opType IN (53 /*OFFLINECONTENTINDEX*/, 57 /*ONLINECONTENTINDEX*/)
								THEN (CASE WHEN EXISTS(SELECT 1 FROM archContentIndexingAF WITH(READUNCOMMITTED) WHERE archCopyId = C.copyId
AND operationType = 1) THEN 1 ELSE 0 END)
							WHEN J.opType = 31 /*ARCHIVECHECK*/
								THEN (CASE WHEN EXISTS(SELECT 1 FROM archChunkToVerify WITH(READUNCOMMITTED)
														WHERE adminJobId = J.jobId AND archCopyId = C.copyId)
												OR EXISTS(SELECT 1 FROM archChunkToVerify2 WITH(READUNCOMMITTED)
															WHERE adminJobId = J.jobId AND
															srcCopyId = C.copyId)
												THEN 1 ELSE 0 END)
							WHEN J.archGrpCopyID = 0 THEN 1
							ELSE 0
						END
					) = 1
			)
		)
'
IF @i_ignoreSuspendedJobs > 0
	SET @SQLQuery += N' AND JI.state NOT IN (5 /*STOPPED*/, 14 /*DORMANT*/, 20 /*INACTIVE*/)'
IF @i_opType <> ''
	SET @SQLQuery += N' AND J.opType IN ' + @i_opType
/*
SET @SQLQuery =
N'IF EXISTS ( ' + @SQLQuery + N' )
BEGIN
	SELECT 1
END
ELSE
BEGIN
	SELECT 0
END'*/
EXEC (@SQLQuery)
IF EXISTS (SELECT 1 FROM #tmpRunningJobs)
BEGIN
	DECLARE @runningJobs varchar(MAX)
	SELECT  @runningJobs = COALESCE(@runningJobs + ', ', '') + convert(varchar(10),jobID)
				FROM #tmpRunningJobs
	SELECT 1, @runningJobs
END
ELSE	SELECT 0, ''
IF OBJECT_ID('tempdb..#lt_Copies') IS NOT NULL DROP TABLE #lt_Copies
IF OBJECT_ID('tempdb..#tmpRunningJobs') IS NOT NULL DROP TABLE #tmpRunningJobs
GO

IF EXISTS (select * from GxQscripts where name = 'JMAreAdminJobsRunningForArchGroupCopy')
	delete from GxQscripts where name = 'JMAreAdminJobsRunningForArchGroupCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMAreAdminJobsRunningForArchGroupCopy')
	delete from GXDBVersions where aliasname = 'JMAreAdminJobsRunningForArchGroupCopy'
GO

insert into GXDBVersions values(2, 'JMAreAdminJobsRunningForArchGroupCopy',  '00010001000200060000', 'JMAreAdminJobsRunningForArchGroupCopy', '00010001000200060000')
GO

