

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMAdminPostStatsActivity.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  JMPostStatsActivity()
--  |				 Description:  Post JobStats activity like updation/cleanup of various properites
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMAdminPostStatsActivity.sp,v $ $Id: JMAdminPostStatsActivity.sp,v 1.1.2.3 2018/03/27 08:52:26 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMAdminPostStatsActivity <<<'

IF EXISTS (select * from sysobjects where name='JMAdminPostStatsActivity')
	drop procedure JMAdminPostStatsActivity
IF EXISTS (select * from GxQscripts where name='JMAdminPostStatsActivity')
	delete from GxQscripts where name = 'JMAdminPostStatsActivity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMAdminPostStatsActivity')
	delete from GXDBVersions where aliasname = 'JMAdminPostStatsActivity'
GO
print '... Creating Procedure: JMAdminPostStatsActivity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMAdminPostStatsActivity
  @i_jobId integer,
  @i_status integer
AS
  DECLARE @errorCode integer;
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#clientIds') IS NOT NULL
	DROP TABLE #clientIds
create table #clientIds
(
	clientid INT
)
BEGIN TRY
	SET @errorCode = 0
	DECLARE @optype INT = 0
	DECLARE @subOpType INT = 0
	DECLARE @unixTimeNow BIGINT = 0
	DECLARE @commcellID INT = 2
	DECLARE @applicationSize BIGINT = 0
	DECLARE @sizeOnMedia BIGINT = 0
	DECLARE @encryptionType INTEGER
	DECLARE @appID INTEGER = 0
	IF @i_jobId <= 0
	BEGIN
		SET @errorCode = @i_jobId
		GOTO ERROR_EXIT
	END
	SET @unixTimeNow = dbo.getUnixTime(GetUTCDate())
	BEGIN TRAN
	SELECT
		  @optype = A.opType,
		  @subOpType = A.subOpType,
		  @appID = B.appID
	From JMJobInfo(NOLOCK) A INNER JOIN JMAdminJobInfoTable(NOLOCK) B
			ON A.jobId = B.jobId and A.commCellId = B.commcellId
	WHERE	A.jobId = @i_jobId And A.commCellId = @commcellID
	-- All success cases should go here
	IF @i_status IN (1, 3, 14) /* JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS*/
	BEGIN
		IF @appID > 0
		BEGIN
			SET @sizeOnMedia = ISNULL((select	SUM(sizeOnMedia) from JMJobDataStats J inner join archGroup AG on AG.id = J.archGrpId
										where j.jobId  = @i_jobId
										and j.commCellId =  @commcellID and j.archGrpCopyId = AG.defaultCopy),0)
			INSERT INTO JMJobOptions
VALUES(@i_jobId, @commcellId, 73, 'Size on Media', @sizeOnMedia, '')
			--Encryption is always 2
		END
	END
	COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = 1
	IF (XACT_STATE()) <> 0
    BEGIN
		ROLLBACK TRANSACTION;
    END
END CATCH;
ERROR_EXIT:
	SELECT  @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'JMAdminPostStatsActivity')
	delete from GxQscripts where name = 'JMAdminPostStatsActivity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMAdminPostStatsActivity')
	delete from GXDBVersions where aliasname = 'JMAdminPostStatsActivity'
GO

insert into GXDBVersions values(2, 'JMAdminPostStatsActivity',  '00010001000200030000', 'JMAdminPostStatsActivity', '00010001000200030000')
GO

