

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMAddVsaCatalogJobIdForBackupJob.sp] ---------- 

--  +========================================================================+
--  | Stored Proc:  JMAddVsaCatalogJobIdForBackupJob()
--  |
--  | Description:
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMAddVsaCatalogJobIdForBackupJob')
BEGIN
	print '>>> Drop Stored Procedure: JMAddVsaCatalogJobIdForBackupJob <<<'
	drop procedure JMAddVsaCatalogJobIdForBackupJob
END
IF EXISTS (select * from GxQscripts where name='JMAddVsaCatalogJobIdForBackupJob')
	delete from GxQscripts where name = 'JMAddVsaCatalogJobIdForBackupJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMAddVsaCatalogJobIdForBackupJob')
	delete from GXDBVersions where aliasname = 'JMAddVsaCatalogJobIdForBackupJob'
GO
print '... Creating Procedure: JMAddVsaCatalogJobIdForBackupJob'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMAddVsaCatalogJobIdForBackupJob
  @i_xmlText XML
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
DECLARE @i_catalogJobId BIGINT = 0
DECLARE @i_vmBackupJobId BIGINT = 0
DECLARE @i_commCellId integer = 0
DECLARE @out_xml XML
DECLARE @errorCode integer = 0
DECLARE @errorMsg NVARCHAR(MAX) = N''
DECLARE @catalogJobId_DB BIGINT = 0
SET @i_commCellId = ISNULL ( ( SELECT R.ref.value('@commCellId', 'integer') FROM @i_xmlText.nodes ( '/JobManager_AddVsaCatalogJobIdForBackupJobReq' ) R ( ref ) ), 0 )
SET @i_catalogJobId = ISNULL ( ( SELECT R.ref.value('@catalogJobId', 'BIGINT') FROM @i_xmlText.nodes ( '/JobManager_AddVsaCatalogJobIdForBackupJobReq' ) R ( ref ) ), 0 )
SET @i_vmBackupJobId = ISNULL ( ( SELECT R.ref.value('@vmBackupJobId', 'BIGINT') FROM @i_xmlText.nodes ( '/JobManager_AddVsaCatalogJobIdForBackupJobReq' ) R ( ref ) ), 0 )
IF @i_catalogJobId = 0
BEGIN
	SET @errorCode = -1
	SET @errorMsg = N'catalog job id value is missing'
	GOTO ERROR_EXIT
END
IF @i_vmBackupJobId = 0
BEGIN
	SET @errorCode = -2
	SET @errorMsg = N'VM backup job id value is missing'
	GOTO ERROR_EXIT
END
IF @i_commCellId = 0
BEGIN
	SET @errorCode = -3
	SET @errorMsg = N'commcell id value is missing'
	GOTO ERROR_EXIT
END
-- JMCATALOG_JOB_ID_FOR_BKP_JOB = 92
-- JMCATALOG_JOB_ID_FOR_BKP_JOB_NAME = 'Catalog job id for backup job'
SELECT @catalogJobId_DB = attributeValueInt FROM JMJobOptions where (jobId = @i_vmBackupJobId AND commCellId = @i_commCellId AND attributeId = 92)
IF (@catalogJobId_DB = 0)
BEGIN
	INSERT INTO JMJobOptions (jobId, commCellId, attributeId, attributeName, attributeValueInt, attributeValue)
	VALUES (@i_vmBackupJobId, @i_commCellId, 92, 'Catalog job id for backup job', @i_catalogJobId, N'')
END
ELSE IF (@catalogJobId_DB <> @i_catalogJobId)
BEGIN
	SET @errorCode = -4
	SET @errorMsg = N'VM backup job is already being cataloged by another job'
	GOTO ERROR_EXIT
END
ERROR_EXIT:
SET @out_xml = (SELECT
		@errorCode AS '@errorCode',
		@errorMsg AS '@errorMsg'
FOR XML PATH ( 'JobManager_AddVsaCatalogJobIdForBackupJobResp' ))
SELECT	@out_xml
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMAddVsaCatalogJobIdForBackupJob')
	delete from GxQscripts where name = 'JMAddVsaCatalogJobIdForBackupJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMAddVsaCatalogJobIdForBackupJob')
	delete from GXDBVersions where aliasname = 'JMAddVsaCatalogJobIdForBackupJob'
GO

insert into GXDBVersions values(2, 'JMAddVsaCatalogJobIdForBackupJob',  '00000000000000000000', 'JMAddVsaCatalogJobIdForBackupJob', '00000000000000000000')
GO

