

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMAddOracleRACStreamInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMAddOracleRACStreamInfo.sp,v $ $Id: JMAddOracleRACStreamInfo.sp,v 1.1 2014/08/11 21:08:02 jraju Exp $";
---- =============================================
---- Author:		Jaya Rama Raju Inavolu
---- Description:	Get the job options
---- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMAddOracleRACStreamInfo <<<'

IF EXISTS (select * from sysobjects where name='JMAddOracleRACStreamInfo')
	drop procedure JMAddOracleRACStreamInfo
IF EXISTS (select * from GxQscripts where name='JMAddOracleRACStreamInfo')
	delete from GxQscripts where name = 'JMAddOracleRACStreamInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMAddOracleRACStreamInfo')
	delete from GXDBVersions where aliasname = 'JMAddOracleRACStreamInfo'
GO
print '... Creating Procedure: JMAddOracleRACStreamInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMAddOracleRACStreamInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inputXml XML
AS
BEGIN
  DECLARE @outputXml XML 
	DECLARE @errorCode INT
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @jmRacStreamInfo TABLE
	(
		jobId					int,
		racInstanceId			int,
		racHostId				int,
		dataStreamsNeeded		int,
		dataStreamsAllocated	int,
		logsStreamsNeeded		int,
		logsStreamsAllocated	int,
		status					int,
		commCellId				int
	)
	INSERT INTO @jmRacStreamInfo
	SELECT
	ISNULL(i.col.value('@jobId', 'int'), 0),
	ISNULL(i.col.value('@racIntanceId', 'int'), 0),
	ISNULL(i.col.value('@racHostId', 'int'), 0),
	ISNULL(i.col.value('@dataStreamsNeeded', 'int'), 0),
	ISNULL(i.col.value('@dataStreamsAllocated', 'int'), 0),
	ISNULL(i.col.value('@logStreamsNeeded', 'int'), 0),
	ISNULL(i.col.value('@logsStreamsAllocated', 'int'), 0),
	ISNULL(i.col.value('@status', 'int'), 0),
	ISNULL(i.col.value('@commCellId', 'int'), 2)
	FROM
	@inputXml.nodes('JobManager_AddOracleRACStreamInfoReq/racStreamInfo') i(col)
	INSERT INTO JmOracleRACStreamInfo
	SELECT *FROM @jmRacStreamInfo
	SET @errorCode = @@error
	SET @outputXml =
	(
		SELECT
		@errorCode '@errorCode',
		CASE WHEN @errorCode <> 0 THEN ERROR_MESSAGE() ELSE '' END '@errorMessage'
		FOR XML PATH('error'), ROOT('JobManager_AddOracleRACStreamInfoResp')
	)
	IF @outputXml IS NULL
		SET @outputXml = '<JobManager_GetOracleRACStreamInfoResp/>'
	SELECT @outputXml
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMAddOracleRACStreamInfo')
	delete from GxQscripts where name = 'JMAddOracleRACStreamInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMAddOracleRACStreamInfo')
	delete from GXDBVersions where aliasname = 'JMAddOracleRACStreamInfo'
GO

insert into GXDBVersions values(2, 'JMAddOracleRACStreamInfo',  '00010001000000000000', 'JMAddOracleRACStreamInfo', '00010001000000000000')
GO

