

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMAddJobPendingParam.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Prakash Varadharajan
--	Date:   02/10/2004
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMAddJobPendingParam.sp,v $ $Id: JMAddJobPendingParam.sp,v 1.7.200.5 2020/04/29 07:02:06 sbonilla Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMAddJobPendingParam')
BEGIN
	print '>>> Drop Stored Procedure: JMAddJobPendingParam <<<'
	drop procedure JMAddJobPendingParam
END
IF EXISTS (select * from GxQscripts where name='JMAddJobPendingParam')
	delete from GxQscripts where name = 'JMAddJobPendingParam'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMAddJobPendingParam')
	delete from GXDBVersions where aliasname = 'JMAddJobPendingParam'
GO
print '... Creating Procedure: JMAddJobPendingParam'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMAddJobPendingParam
  @i_MsgId integer
AS
  DECLARE @r_MsgId integer
  DECLARE @r_ErrorStr varchar(255)
	DECLARE @EventId	INTEGER
	DECLARE @LocaleId	INTEGER
	DECLARE @Index		INTEGER
	DECLARE @UniqPosition	INTEGER
	DECLARE @Position	INTEGER
	DECLARE @NumParam	INTEGER
	SET NOCOUNT ON
	SET @r_ErrorStr	= 'NO ERROR'
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SELECT @EventId = MessageId
	FROM	JMFailureReasonMsg
	WHERE	id = @i_MsgId
	SELECT @NumParam = ArgCount
	FROM 	EvLocaleMsgs
	WHERE 	MessageId 	= @EventId
	AND	LocaleId	= 0		-- Assuming all language will have same number of args as English
	SET @Index 		= 1		-- Index of the position column from EvParamTmp
	SET @UniqPosition	= 1		-- This holds the position that goes into the 'position' col of EvParam
	IF object_id('tempdb.dbo.#JMFailureReasonMsgParamTmp_InfoTable') is not null
		DROP TABLE #JMFailureReasonMsgParamTmp_InfoTable
CREATE TABLE #JMFailureReasonMsgParamTmp_InfoTable (MsgId INT, EventId INT, Position INT, Type INT, Size INT, Data NVARCHAR(1023))
	CREATE CLUSTERED INDEX JMFailureReasonMsgParamTmp_InfoTable_idx ON #JMFailureReasonMsgParamTmp_InfoTable (MsgId)
	WHILE 1 = 1
	BEGIN
		-- Check to see if we are done with the param count
		WHILE @NumParam < (@UniqPosition & 0xF)
		BEGIN
			-- Now rollback one level of nesting
			SET @UniqPosition = @UniqPosition/16
			IF @UniqPosition = 0
				BREAK;		-- At the top most level
			SELECT	@EventId = EventId
			FROM	#JMFailureReasonMsgParamTmp_InfoTable
			WHERE	MsgId		= @i_MsgId
			AND	Position	= @UniqPosition
			SELECT	@NumParam = ArgCount
			FROM	EvLocaleMsgs
			WHERE	MessageId	= @EventId
			AND	LocaleId	= 0
			SET @UniqPosition = @UniqPosition+1
		END
		IF @UniqPosition = 0
			BREAK;
		IF NOT EXISTS (SELECT * FROM JMFailureReasonMsgParamTmp WHERE MsgId = @i_MsgId AND Position = @Index)
			BREAK				-- Not enough Parameters
		INSERT INTO #JMFailureReasonMsgParamTmp_InfoTable (MsgId, EventId, Position, Type, Size, Data)
		SELECT MsgId, @EventId, @UniqPosition, Type, Size, Data
		FROM JMFailureReasonMsgParamTmp WITH(NOLOCK)
		WHERE MsgId	= @i_MsgId
		AND Position	= @Index
		-- Check to see if the parameter is an event id
		IF (13 = (SELECT DataType FROM EvLocaleMsgArgInfo WHERE LocaleID = 0 AND MessageId = @EventId AND ArgPos = (@UniqPosition&0xf)))
		BEGIN
			SET @UniqPosition = (@UniqPosition*16)
			SELECT @EventId = Data
			FROM JMFailureReasonMsgParamTmp
			WHERE MsgId	= @i_MsgId
			AND Position	= @Index
			SELECT @NumParam = ArgCount
			FROM EvLocaleMsgs
			WHERE MessageId = @EventId
			AND LocaleId	= 0
		END
		SET @UniqPosition = @UniqPosition + 1
		SET @Index = @Index + 1
	END
	INSERT INTO JMFailureReasonMsgParam (MsgId, EventId, Position, Type, Size, Data)
	SELECT MsgId, EventId, Position, Type, Size, Data
	FROM #JMFailureReasonMsgParamTmp_InfoTable WITH(NOLOCK)
	-- Check for the number of parameters
	IF EXISTS (SELECT * FROM JMFailureReasonMsgParamTmp WHERE MsgId	= @i_MsgId AND Position = @Index)
	BEGIN
		SET @i_MsgId = -1
		SET @r_ErrorStr = 'Too Many parameters'
		GOTO EXIT_PROC
	END
	ELSE IF (@UniqPosition <> 0)
	BEGIN
		SET @i_MsgId = -2
		SET @r_ErrorStr = 'Not enough Parameters'
		GOTO EXIT_PROC
	END
EXIT_PROC:
	-- Return the Message ID inserted/changed
	IF @i_MsgId is null
		SET @i_MsgId = 0
	SELECT @i_MsgId , @r_ErrorStr
	SET NOCOUNT OFF
	IF object_id('tempdb.dbo.#JMFailureReasonMsgParamTmp_InfoTable') is not null
		DROP TABLE #JMFailureReasonMsgParamTmp_InfoTable
GO


IF EXISTS (select * from GxQscripts where name = 'JMAddJobPendingParam')
	delete from GxQscripts where name = 'JMAddJobPendingParam'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMAddJobPendingParam')
	delete from GXDBVersions where aliasname = 'JMAddJobPendingParam'
GO

insert into GXDBVersions values(2, 'JMAddJobPendingParam',  '00010007020000050000', 'JMAddJobPendingParam', '00010007020000050000')
GO

