

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/IsValidGalaxyUserXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/IsValidGalaxyUserXML.sp,v $ $Id: IsValidGalaxyUserXML.sp,v 1.1.2.4 2019/07/18 13:31:09 ygondi Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='IsValidGalaxyUserXML')
BEGIN
	print '>>> Drop Stored Procedure: IsValidGalaxyUserXML <<<'
	drop procedure IsValidGalaxyUserXML
END
IF EXISTS (select * from GxQscripts where name='IsValidGalaxyUserXML')
	delete from GxQscripts where name = 'IsValidGalaxyUserXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IsValidGalaxyUserXML')
	delete from GXDBVersions where aliasname = 'IsValidGalaxyUserXML'
GO
print '... Creating Procedure: IsValidGalaxyUserXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure IsValidGalaxyUserXML
  @i_xml XML
AS
  DECLARE @o_xml XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @userId      NVARCHAR(255) = ISNULL((SELECT ref.value('@userName', 'NVARCHAR(MAX)') FROM @i_xml.nodes ('App_GalaxyUserValidationReq') R(ref)),
                                                             (SELECT [login] FROM UMUSers WHERE userGuid = (SELECT ref.value('@userGuid', 'VARCHAR(64)') FROM @i_xml.nodes ('App_GalaxyUserValidationReq') R(ref))))
DECLARE @userPswd    NVARCHAR(255) = (SELECT ref.value('@userPswd', 'NVARCHAR(MAX)') FROM @i_xml.nodes ('App_GalaxyUserValidationReq') R(ref))
DECLARE @localeId       INT = 0
DECLARE @o_retVal       INT = 0
DECLARE @o_userId       INT = 0
DECLARE @o_userGUID     NVARCHAR(255) = ''
DECLARE	@o_emailAddr	NVARCHAR(255) = ''
DECLARE	@o_userName		NVARCHAR(255) = '' --required for authenticating linked cloud user where userid, name ,guid will be that of localuser when the hidden cloud user tries to login
-- -- SP BODY BEGIN : IsValidGalaxyUser.spb -------------------------------------------------------------------------------------------------------------------------
DECLARE @tblPassword    nvarchar(255)
    DECLARE @binValue       varbinary(255)
    DECLARE @nValue         nvarchar(255)
    DECLARE @errorString    nvarchar(max)
    DECLARE @errorCode int = 0
    DECLARE @nowDay int = dbo.GetUnixTime(GETUTCDATE())/(60*60*24)
    DECLARE @thenDay int = 0
    DECLARE @policy int
    DECLARE @userEnabled int
DECLARE @userSalt nvarchar(255)
	DECLARE @passwordVersion VARCHAR
	DECLARE @isPasswordExpired int = 0
	DECLARE @flags int = 0
	DECLARE @linkedLocalUserId int = 0
    SELECT @tblPassword = password, @o_userId=id,@userSalt=Salt, @o_userGUID=userGuid, @o_emailAddr=email, @flags=flags, @userEnabled=enabled, @policy=policy,@thenDay=(datePasswordSet/(60*60*24)),@o_userName=login FROM UMUsers WHERE login=@userId
	SELECT @passwordVersion= SUBSTRING(@tblPassword,1,1)
	IF(@o_userId = 0)
    begin
        SET @errorString = 'Username/Password are incorrect'
        SET @errorCode = 1116 --INVALID_COMMCELL_LOGIN
        goto proc_exit
    end
    IF(@userEnabled=0)
    BEGIN
        SET @errorString = 'Account Disabled'
        SET @errorCode =  1131 --LOGIN_ERROR_CODES(ERROR_ACCOUNT_DISABLED)
        goto proc_exit
    END
	IF EXISTS (select 1 from UMUsersProp where attrName='Disable login for SAML Users' and componentNameId=@o_userId)
	BEGIN
		SET @errorString = 'User Regular Login Disabled'
        SET @errorCode =  1150 --LOGIN_ERROR_CODES(USER_REGULAR_LOGIN_DISABLED)
        goto proc_exit
	END
    --Check Password version
IF(@passwordVersion='1' OR @passwordVersion= '2' OR @passwordVersion= '3')
            EXEC isValidUserManaged @tblPassword, @userPswd, @o_retVal OUTPUT, @errorString OUTPUT
	ELSE
	BEGIN
			EXEC ValidateUserNew @tblPassword,@userPswd,@userSalt,@o_retVal OUTPUT,@errorString OUTPUT
	END
        IF(@o_retVal = 0)
        BEGIN
            SET @errorString = 'Username/Password are incorrect'
            SET @errorCode =  1116 --LOGIN_ERROR_CODES(INVALID_COMMCELL_LOGIN)
            goto proc_exit
        END
	EXECUTE sec_isPasswordExpired @o_userId, @o_isExpired = @isPasswordExpired OUTPUT
    IF(@isPasswordExpired = 1)
    BEGIN
        SET @o_retVal = 0
        SET @errorString = 'Password Expired'
        SET @errorCode =  1132 --LOGIN_ERROR_CODES(ERROR_ACCOUNT_EXPIRED)
        goto proc_exit
    END
    --Make sure value is 0 or 1 only
    --SET @nValue = @binValue
    --IF @nValue IS NULL
    --  SET @nValue = 0
    --SET @o_retVal = @nValue
proc_exit:
	-- if logged in user is cloud user, send back the local users details
IF @flags & 0X010 = 0X010
	BEGIN
	 	SELECT @linkedLocalUserId = componentNameId
		FROM UMUsersProp
WHERE attrName = 'Linked CommvaultId' and
				attrVal = CAST( @o_userId as nvarchar(max))
		IF @linkedLocalUserId <> 0
			SELECT @o_userId = @linkedLocalUserId, @o_userGUID = userGuid, @o_emailAddr = email ,@o_userName = login
			FROM UMUsers WHERE id = @linkedLocalUserId
	END
	--refresh credentials in cache
	IF @errorCode = 0
    BEGIN
        EXEC sec_updateUserCredentials @o_userId
	END
-- -- SP BODY END : AppGetThirdPartyEncryptedKeysXML.spb ---------------------------------------------------------------------------------------------------------------------------
SET @o_xml =
(
    SELECT  @o_retVal           AS '@status',
            @errorCode          AS '@errorCode',
            @errorString        AS '@errorString',
            @o_emailAddr        AS '@email',
            (SELECT
                @o_userId       AS '@userId',
                @o_userGUID     AS '@userGUID',
                @o_userName     AS '@userName'
             FOR XML PATH('userEntity'), TYPE )
    FOR XML PATH('App_UserValidationResp'), TYPE
)
SELECT @o_xml AS [o_xml]
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'IsValidGalaxyUserXML')
	delete from GxQscripts where name = 'IsValidGalaxyUserXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IsValidGalaxyUserXML')
	delete from GXDBVersions where aliasname = 'IsValidGalaxyUserXML'
GO

insert into GXDBVersions values(2, 'IsValidGalaxyUserXML',  '00010001000200040000', 'IsValidGalaxyUserXML', '00010001000200040000')
GO

