

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/IsSchedPolEditAllowed.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/IsSchedPolEditAllowed.sp,v $ $Id: IsSchedPolEditAllowed.sp,v 1.7.210.2 2018/03/20 00:50:43 jiechen Exp $";
--
--  +========================================================================+
--  |      Procedure:  IsSchedPolEditAllowed()
--  |
--  | Description:  Check the user rights for schedule policy
--  |
--  |       Input:  userId
--  |
--  |      Output:  Returns rows that match input criteria
--  |      Return:  None
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        Anand Vibhor     Initial Edit
--  +========================================================================+
-- Cursor Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: IsSchedPolEditAllowed <<<'

IF EXISTS (select * from sysobjects where name='IsSchedPolEditAllowed')
	drop procedure IsSchedPolEditAllowed
IF EXISTS (select * from GxQscripts where name='IsSchedPolEditAllowed')
	delete from GxQscripts where name = 'IsSchedPolEditAllowed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IsSchedPolEditAllowed')
	delete from GXDBVersions where aliasname = 'IsSchedPolEditAllowed'
GO
print '... Creating Procedure: IsSchedPolEditAllowed'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure IsSchedPolEditAllowed
-- Cursor Input
  @userId integer,
  @taskType integer,
  @schetemplateId integer
AS
  DECLARE @retVal integer
SET NOCOUNT ON
DECLARE @templateType 		integer
DECLARE @scheInstanceId 	integer
DECLARE @scheInstanceCount 	integer
DECLARE @scheRightsCount 	integer
DECLARE @scheCount	 	integer
SET @templateType = @taskType
set @retVal = 0
set @scheInstanceCount = (select count(*) from schedTemplateInstance where schedTemplateId = @schetemplateId )
if (@scheInstanceCount > 0)
BEGIN
set @scheInstanceId = (select TOP 1 id from schedTemplateInstance where schedTemplateId = @schetemplateId )
   IF object_id('tempdb.dbo.#entitiesWithViewSchedCapability') is not null DROP TABLE #entitiesWithViewSchedCapability
create table  #entitiesWithViewSchedCapability ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
   EXEC sec_getUserObjects @userId, 0, 0, '#entitiesWithViewSchedCapability'
--BACKUP
if (@templateType & 2 = 2)
BEGIN
set @scheCount = (select COUNT(*) from schedule where schedtemplateInstanceId = @scheInstanceId and tasktype = 1 and ((flags & 1) <> 1 ) AND ((flags & 128) <> 128 ))
set @scheRightsCount = (SELECT  COUNT(DISTINCT id) from scheduleview sc
   INNER JOIN #entitiesWithViewSchedCapability sec ON
   ((capabilities = 2816911 OR @userId = sc.userId) OR
   (
      (((capabilities&2048) <> 0) AND ((capabilities & 4) <> 0)) AND
      (
         ((sc.clientId  = sec.clientId  OR
			(sec.clientId = 0 AND sec.clientGroupId = 0 AND sec.mediaAgentId=0 AND
			 sec.libraryId=0 AND sec.archGroupId=0 AND vtContainerId=0 AND vtPolicyId=0 AND vtShelfId=0)
			) OR
         (sc.clientId = 0 AND sec.clientGroupId = sc.clientGroupId))
         AND  (sc.appTypeId   = sec.appTypeId   OR  sc.appTypeId = 0  OR sec.appTypeId = 0   )
        AND  (sc.instanceId    = sec.instanceId  OR  sc.instanceId  = 0  OR sec.instanceId = 0  )
         AND  (sc.backupSetId   = sec.backupSetId OR  sc.backupSetId = 0  OR sec.backupSetId = 0 )
         AND  (sc.subClientId   = sec.subClientId OR  sc.subClientId = 0  OR sec.subClientId = 0 )
      )
   ))
where sc.schedtemplateInstanceId = @scheInstanceId and sc.taskType = 1 AND ((sc.flags & 1) <> 1 ) AND ((sc.flags & 128) <> 128 ))
if @scheCount = @scheRightsCount
 set  @retVal = 1
else
 set  @retVal = 0
END
-- Aux copy
ELSE IF (@templateType & 4 = 4)
BEGIN
set @scheCount = (select COUNT(*) from schedule where schedtemplateInstanceId = @scheInstanceId and tasktype = 4 and ((flags & 1) <> 1 ) AND ((flags & 128) <> 128 ))
  set @scheRightsCount = (SELECT  COUNT(DISTINCT id) from scheduleview sc
   INNER JOIN #entitiesWithViewSchedCapability sec ON @userId = sc.userId OR
		((capabilities&1) <> 0)
		AND
		(
			( --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
			EXISTS(select * from schedadminparam par where par.admintaskid=sc.taskId AND sec.archGroupId <> 0 AND par.type=2231 AND par.data=CAST(sec.archGroupId AS VARCHAR(10)))
		)
		OR --CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
		(
			sec.commCellId = 2 AND sec.clientId=0 AND sec.clientGroupId=0 AND sec.appTypeId = 0 AND sec.instanceId = 0 AND sec.backupSetId = 0 AND sec.subClientId = 0 AND sec.mediaAgentId = 0
			AND sec.libraryId = 0 AND sec.archGroupId = 0 AND sec.libraryId = 0 AND sec.vtContainerId = 0 AND sec.vtPolicyId = 0 AND sec.vtShelfId = 0
		)
		)
where sc.schedtemplateInstanceId = @scheInstanceId and sc.taskType = 4 AND ((sc.flags & 1) <> 1 ) AND ((sc.flags & 128) <> 128 ))
if @scheCount = @scheRightsCount
 set  @retVal = 1
else
 set  @retVal = 0
END
-- Admin (SRM reports & SNAP copy to tape)
ELSE IF (@templateType & 16 = 16) OR (@templateType & 32 = 32) OR (@templateType & 64 = 64)
BEGIN
set @scheCount = (select COUNT(*) from schedule where schedtemplateInstanceId = @scheInstanceId and tasktype = 4 and ((flags & 1) <> 1 ) AND ((flags & 128) <> 128 ))
  set @scheRightsCount = (SELECT  COUNT(DISTINCT id) from scheduleview sc
   INNER JOIN #entitiesWithViewSchedCapability sec ON @userId = sc.userId OR
  (((capabilities & 1 ) <> 0 and
   sec.commcellId <> 0 and sec.clientGroupId = 0 and sec.clientId = 0 and sec.apptypeid = 0 and sec.instanceid = 0 and
   sec.subclientId = 0 and sec.mediaAgentId = 0 and sec.libraryId = 0 and sec.archGroupid = 0)
   )
where sc.schedtemplateInstanceId = @scheInstanceId and sc.taskType = 4 AND ((sc.flags & 1) <> 1 ) AND ((sc.flags & 128) <> 128 ))
if @scheCount = @scheRightsCount
 set  @retVal = 1
else
 set  @retVal = 0
END
END
ELSE
 set @retval = 1
SELECT @retval
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'IsSchedPolEditAllowed')
	delete from GxQscripts where name = 'IsSchedPolEditAllowed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IsSchedPolEditAllowed')
	delete from GXDBVersions where aliasname = 'IsSchedPolEditAllowed'
GO

insert into GXDBVersions values(2, 'IsSchedPolEditAllowed',  '00010007021000020000', 'IsSchedPolEditAllowed', '00010007021000020000')
GO

