

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/IsSAMLAutoRedirectRuleEnableForUser.sp] ---------- 

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='IsSAMLAutoRedirectRuleEnableForUser')
BEGIN
	print '>>> Drop Stored Procedure: IsSAMLAutoRedirectRuleEnableForUser <<<'
	drop procedure IsSAMLAutoRedirectRuleEnableForUser
END
IF EXISTS (select * from GxQscripts where name='IsSAMLAutoRedirectRuleEnableForUser')
	delete from GxQscripts where name = 'IsSAMLAutoRedirectRuleEnableForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IsSAMLAutoRedirectRuleEnableForUser')
	delete from GXDBVersions where aliasname = 'IsSAMLAutoRedirectRuleEnableForUser'
GO
print '... Creating Procedure: IsSAMLAutoRedirectRuleEnableForUser'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure IsSAMLAutoRedirectRuleEnableForUser
  @i_username NVARCHAR(510),
  @i_email NVARCHAR(510),
  @i_appKey NVARCHAR(40),
  @i_companyNameFromSamlResponse NVARCHAR(510) = '',
  @o_isEligible INT OUTPUT, -- 1 true, 0 false.
  @o_domainId INT = -1 OUTPUT, --optional Parameter.
  @o_domainName NVARCHAR(512) = '' OUTPUT, --optional Parameter.
  @o_errorString NVARCHAR(1024) = '' OUTPUT,
  @o_errorCode INT = 0 OUTPUT 
AS
-- add TRY catch block
	BEGIN
		SET NOCOUNT ON
		SET @o_isEligible = 0
		IF((@i_username IS NULL AND @i_email IS NULL) OR @i_appKey IS NULL OR LEN(@i_appKey) <> 15)
		BEGIN
			SET @o_errorString = 'supplied username or email is empty or appkey is invalid'
			SET @o_errorCode = 1
			GOTO PROC_EXIT
		END
		DECLARE @appId INT = 0
		DECLARE @domainNameFromusernameOremail NVARCHAR(512)
		SELECT @appId = id from App_ThirdPartyApp (nolock) where appKey = @i_appKey
		IF(LEN(@i_companyNameFromSamlResponse)>0)
		BEGIN
		 	-- if companyName is specified- SAML app has to be a Commcell level app.
		 	--Check whether is it a valid company name.
			IF NOT EXISTS (SELECT 1 from UMDSProviders (nolock) where domainName = @i_companyNameFromSamlResponse and serviceType = 5) -- check only org.
			BEGIN
			--Invalid companyName -- check the hostname also.
				IF EXISTS(SELECT 1 from UMDSProviders (nolock) where hostname = @i_companyNameFromSamlResponse and serviceType = 5) -- checking hostname of the company
				BEGIN
					SET @i_companyNameFromSamlResponse = (SELECT TOP 1 domainName from UMDSProviders (nolock) where hostname = @i_companyNameFromSamlResponse and serviceType = 5)
				END
				ELSE
				BEGIN
					SET @o_errorString = CONCAT(@o_errorString, CONCAT('supplied companyNameFromSamlResponse param is not a company. company name received is ',@i_companyNameFromSamlResponse))
					SET @o_errorCode = 2
					GOTO PROC_EXIT
				END
			END
		 	--DECLARE @ownerCompanyId INT
		 	--select @ownerCompanyId = umds.ownerCompany from App_ThirdPartyApp app with (nolock)  join UMDSProviderProp umdsProp with (nolock)
            --                        on CAST(app.id as nvarchar)= umdsProp.attrVal
            --                        join UMDSProviders umds with (nolock) on umds.id = componentNameId
            --                        where app.appKey = @i_appKey and umdsProp.attrName = 'SAML IDP' and umdsProp.modified = 0
			--IF(@ownerCompanyId<>0)
			--BEGIN
			--ownerCompanyId is not 0, SAML app is not commcell level app!-
			--	GOTO PROC_EXIT
			--END
			--It is a commcell level SAML app. Since CompanyName is specified in the SAML response. Give it the first preference.
			--Ignore checking the Domain given in the redirect rule.
			IF(CHARINDEX('\',@i_username)>0) -- if username, domain part of username and company name should match.
			BEGIN
				SET @domainNameFromusernameOremail = substring(@i_username,0,charindex('\',@i_username))
				--user should be the company user or the domain user of the company.
				IF(@domainNameFromusernameOremail = @i_companyNameFromSamlResponse)
				BEGIN
					SET @o_domainName = @i_companyNameFromSamlResponse
					SET @o_domainId = (SELECT id from UMDSProviders (nolock) where domainName = @i_companyNameFromSamlResponse)
					SET @o_isEligible = 1
					GOTO PROC_EXIT
				END
				DECLARE @tempTable TABLE (domainId INT , domainName nvarchar(510), ownerCompanyId INT , ownerCompanyName nvarchar(510))
				Insert into @tempTable
					select A.id,A.domainName,B.id, B.domainName from UMDSProviders A (nolock), UMDSProviders B (nolock) where A.domainName = @domainNameFromusernameOremail and A.ownerCompany = B.id
				IF(ISNULL((SELECT 1 from @tempTable where ownerCompanyName = @i_companyNameFromSamlResponse), 0 ) = 1)
				BEGIN
					SET @o_domainName = @domainNameFromusernameOremail
					SET @o_domainId = (SELECT domainId from @tempTable where domainName = @domainNameFromusernameOremail)
					SET @o_isEligible = 1
					GOTO PROC_EXIT
				END
				ELSE
				BEGIN
					SET @o_errorString = CONCAT(@o_errorString, CONCAT('Domain name of the given username is not the part of the company.', @i_companyNameFromSamlResponse))
					SET @o_errorCode = 3
					GOTO PROC_EXIT
					--error.
				END
			END
			IF(CHARINDEX('@',@i_username)>0 AND (@i_email IS NULL OR @i_email = ''))
			BEGIN
				SET @i_email = @i_username--preparing for email checks
			END
			IF(CHARINDEX('@',@i_email) > 0)
			BEGIN
				--email.
				--do we need to check for primary SMTP of company?
				--Pick the smtp address and check whether is it present in the redirect rule.
				SET @domainNameFromusernameOremail = substring(@i_email,charindex('@',@i_email)+1,len(@i_email))
				SET @o_domainId = -1
				IF(ISNULL((SELECT 1 from APP_ComponentProp as ACP (nolock) where componentType = 112 AND longVal = @appId
						AND (ACP.stringVal = @domainNameFromusernameOremail OR ACP.stringVal like @domainNameFromusernameOremail+';%'
						OR ACP.stringVal like '%;'+@domainNameFromusernameOremail +';%' OR ACP.stringVal like '%;'+@domainNameFromusernameOremail)),-1) = 1)
				BEGIN
				--ignore the domain defined in redirect rule, take companyNameFromSamlResponse
					SELECT @o_domainId = id from UMDSProviders (nolock) where domainName = @i_companyNameFromSamlResponse
					SET @o_domainName = @i_companyNameFromSamlResponse
					SET @o_isEligible = 1
					GOTO PROC_EXIT
				END
				ELSE
				BEGIN
					SET @o_errorString = CONCAT(@o_errorString, 'email smtp address is not matching the redirect rule of the saml app.')
					SET @o_errorCode = 4
					GOTO PROC_EXIT
				END
			END
			ELSE
			BEGIN
				SET @o_errorString = CONCAT(@o_errorString, 'given username is not email or domain user. Cannot authorize the user.')
				SET @o_errorCode = 5
				GOTO PROC_EXIT
			END
		END
		IF(CHARINDEX('\',@i_username)>0)
		BEGIN
			SET @domainNameFromusernameOremail = substring(@i_username,0,charindex('\',@i_username))
			--Get the UMDSProviders.id from UMDSProviders table for the found domain.
			IF EXISTS ( SELECT 1 from APP_ComponentProp (nolock) where componentType = 112 AND componentId  in (SELECT  id from UMDSProviders (nolock) where domainName = @domainNameFromusernameOremail) AND longVal = @appId)
			BEGIN
				SELECT @o_domainId = (SELECT TOP 1 componentId from APP_ComponentProp where componentType = 112 AND componentId  in (SELECT id from UMDSProviders where domainName = @domainNameFromusernameOremail) AND longVal = @appId)
				SET @o_isEligible = 1 -- redirection rule present.
				SET @o_domainName = @domainNameFromusernameOremail
				SET @o_errorString = ''
				SET @o_errorCode = 0
				GOTO PROC_EXIT
			END
			ELSE -- where redirection is enabled by i_email
			BEGIN
				SET @o_errorString = CONCAT(@o_errorString, 'Could not verify Redirect rule based on username')
				SET @o_errorCode = 6
			END
		END
		--If the flow has reached till this point, the eligibility couldn't been found using username. So before proceeding the email checks, check whether the @i_username has emailID in it and i_email is empty/NULL.
		IF(CHARINDEX('@',@i_username)>0 AND (@i_email IS NULL OR @i_email = ''))
		BEGIN
			SET @i_email = @i_username
		END
		IF (CHARINDEX('@',@i_email) > 0)
		BEGIN
			SET @domainNameFromusernameOremail = substring(@i_email,charindex('@',@i_email)+1,len(@i_email))
			SET @o_domainId = -1
			SELECT @o_domainId = ACP.componentId from APP_ComponentProp as ACP (nolock) where componentType = 112 AND longVal = @appId
					AND (ACP.stringVal = @domainNameFromusernameOremail OR ACP.stringVal like @domainNameFromusernameOremail+';%' OR ACP.stringVal like '%;'+@domainNameFromusernameOremail +';%' OR ACP.stringVal like '%;'+@domainNameFromusernameOremail)
			--IF (@domainNamesChain IS NOT NULL)
			--BEGIN
			--	INSERT INTO @SplittedDomainNamesTempTable SELECT domainNames_t.Data from dbo.split((@domainNamesChain),';') domainNames_t --populated table will have an entry for sure.
			--END
			IF (@o_domainId <> -1) -- default value.
			BEGIN
				SET @o_isEligible = 1
				SELECT @o_domainName = domainName from UMDSProviders (nolock) where id = @o_domainId
				SET @o_errorString = ''
				SET @o_errorCode = 0
				GOTO PROC_EXIT
			END
			ELSE
			BEGIN
				SET @o_errorString = CONCAT(@o_errorString, 'Could not verify Redirect rule based on email')
				SET @o_errorCode = 7
			END
		END
		ELSE
			BEGIN
				SET @o_errorString = CONCAT(@o_errorString,  'Could not verify redirect rule based on username or email. Incorrect input supplied')
				SET @o_errorCode = 8
			END
		PROC_EXIT:
		SET NOCOUNT OFF
	END
GO

IF EXISTS (select * from GxQscripts where name = 'IsSAMLAutoRedirectRuleEnableForUser')
	delete from GxQscripts where name = 'IsSAMLAutoRedirectRuleEnableForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IsSAMLAutoRedirectRuleEnableForUser')
	delete from GXDBVersions where aliasname = 'IsSAMLAutoRedirectRuleEnableForUser'
GO

insert into GXDBVersions values(2, 'IsSAMLAutoRedirectRuleEnableForUser',  '00000000000000000000', 'IsSAMLAutoRedirectRuleEnableForUser', '00000000000000000000')
GO

