

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/IsLastFullCycleJobsAged.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/IsLastFullCycleJobsAged.sp,v $ $Id: IsLastFullCycleJobsAged.sp,v 1.1.2.3 2017/02/10 19:55:36 sjohnson Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: IsLastFullCycleJobsAged <<<'

IF EXISTS (select * from sysobjects where name='IsLastFullCycleJobsAged')
	drop procedure IsLastFullCycleJobsAged
IF EXISTS (select * from GxQscripts where name='IsLastFullCycleJobsAged')
	delete from GxQscripts where name = 'IsLastFullCycleJobsAged'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IsLastFullCycleJobsAged')
	delete from GXDBVersions where aliasname = 'IsLastFullCycleJobsAged'
GO
print '... Creating Procedure: IsLastFullCycleJobsAged'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure IsLastFullCycleJobsAged
  @i_ClientId INTEGER,
  @i_AppTypeId INTEGER,
  @i_InstanceId INTEGER,
  @i_BackupSetId INTEGER,
  @i_SubClientId INTEGER
AS
  DECLARE @o_flags INTEGER
DECLARE @ClientId INTEGER = @i_ClientId
DECLARE @SubClientId INTEGER = @i_SubClientId
DECLARE @BackupSetId INTEGER = @i_BackupSetId
DECLARE @AppTypeId INTEGER = @i_AppTypeId
DECLARE @InstanceId INTEGER = @i_InstanceId
DECLARE @SubclientInfo TABLE(SubclientId INTEGER)
DECLARE @SubclientCycleInfo TABLE(subclientId INTEGER, FullCycleNumber INTEGER)
DECLARE @flags INTEGER = 0
-- 1 - AGED 2- NOT AGED, 4 - ERROR
IF @SubClientId <> 0
BEGIN
	INSERT INTO @SubclientInfo SELECT @SubClientId
END
ELSE IF @BackupSetId <> 0
BEGIN
	INSERT INTO @SubclientInfo SELECT id FROM APP_Application WITH (NOLOCK) WHERE backupSet = @BackupSetId
END
ELSE IF @InstanceId > 1
BEGIN
	INSERT INTO @SubClientInfo SELECT id FROM APP_Application WITH (NOLOCK) WHERE instance = @InstanceId
END
ELSE IF @ClientId <> 0 AND @AppTypeId = 0
BEGIN
	INSERT INTO @SubclientInfo SELECT id FROM APP_Application WITH (NOLOCK) WHERE clientId = @ClientId
END
ELSE IF @ClientId <> 0 AND @AppTypeId <> 0
BEGIN
	INSERT INTO @SubclientInfo SELECT id FROM APP_Application WITH (NOLOCK) WHERE clientId = @ClientId AND appTypeId = @AppTypeId
END
ELSE
BEGIN
	-- If valid input is not passed
	SELECT @flags = 4
	GOTO EXIT_SP
END
IF NOT EXISTS(SELECT 1 FROM @SubclientInfo)
BEGIN
	-- If no subclient was selected
	SELECT @flags = 4
	GOTO EXIT_SP
END
INSERT INTO @SubclientCycleInfo
SELECT SC.SubclientId,SCP.attrVal FROM @SubclientInfo SC
LEFT OUTER JOIN APP_SubClientProp SCP WITH(NOLOCK) ON SC.SubclientId = SCP.componentNameId AND SCP.attrName = 'sys:full cycle num' AND SCP.modified = 0
IF EXISTS(SELECT 1 FROM @SubclientCycleInfo WHERE FullCycleNumber = NULL)
BEGIN
	-- If no backup job was ran, return as aged so next backup job will be full
	SELECT @flags = 1
	GOTO EXIT_SP
END
IF NOT EXISTS
(
	-- If all backup jobs are aged and meta data present in the JMBkpStats also aged then return as aged
	SELECT 1 FROM @SubclientCycleInfo SCP
	INNER JOIN JMBkpStats JM WITH(NOLOCK) ON JM.appId = SCP.subclientId AND JM.fullCycleNum = SCP.FullCycleNumber
)
BEGIN
	SELECT @flags = 1
	GOTO EXIT_SP
END
--need to consider this for snap copy based on AG snap copy column
IF EXISTS
(
	-- If any one backup job is aged then return as aged
	SELECT * FROM @SubclientCycleInfo SCP
	INNER JOIN JMBkpStats JM WITH(NOLOCK) ON JM.appId = SCP.subclientId AND JM.fullCycleNum = SCP.FullCycleNumber
	INNER JOIN archGroup AG WITH(NOLOCK) ON JM.dataArchGrpId = AG.id
INNER JOIN JMJobDataStats JMD WITH(NOLOCK) ON JM.jobId = JMD.jobId AND JM.commCellId = JMD.commCellId AND (JMD.disabled & 256) = 256
	WHERE JMD.archGrpCopyId = AG.defaultCopy
)
BEGIN
	SELECT @flags = 1
	GOTO EXIT_SP
END
-- If no jobs are aged return as not aged
SELECT @flags = 2
EXIT_SP:
SELECT @flags
GO

IF EXISTS (select * from GxQscripts where name = 'IsLastFullCycleJobsAged')
	delete from GxQscripts where name = 'IsLastFullCycleJobsAged'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IsLastFullCycleJobsAged')
	delete from GXDBVersions where aliasname = 'IsLastFullCycleJobsAged'
GO

insert into GXDBVersions values(2, 'IsLastFullCycleJobsAged',  '00010001000200030000', 'IsLastFullCycleJobsAged', '00010001000200030000')
GO

