

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/IsForceClientSideDownloadSet.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Check whether the given client has ForceClientSideDownload set in either client level or client group level.
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='IsForceClientSideDownloadSet')
BEGIN
	print '>>> Drop Stored Procedure: IsForceClientSideDownloadSet <<<'
	drop procedure IsForceClientSideDownloadSet
END
IF EXISTS (select * from GxQscripts where name='IsForceClientSideDownloadSet')
	delete from GxQscripts where name = 'IsForceClientSideDownloadSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IsForceClientSideDownloadSet')
	delete from GXDBVersions where aliasname = 'IsForceClientSideDownloadSet'
GO
print '... Creating Procedure: IsForceClientSideDownloadSet'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure IsForceClientSideDownloadSet
  @inputxml XML
AS
SET NOCOUNT ON
DECLARE @clientId INT
DECLARE @option INT
DECLARE @forceClientSideDownload INT = -1
DECLARE @showForceClientSideDownload INT = -1
DECLARE @patchDownloadProtocol VARCHAR(MAX)
--Refer ForceClientSideDownload ENUM in App.x
DECLARE @ForceClientSideDownloadNo INT = 0
DECLARE @ForceClientSideDownloadYes INT = 1
DECLARE @ForceClientSideDownloadDefault INT = 2
  DECLARE @o_outxml XML
SET @option	= ISNULL((SELECT ref.value('@option', 'INTEGER')FROM @inputXML.nodes('App_IsForceClientSideDownloadSetReq') R(ref)), 0)
SET @clientId	= ISNULL((SELECT ref.value('@clientId', 'INTEGER')FROM @inputXML.nodes('App_IsForceClientSideDownloadSetReq') R(ref)), 0)
SET @patchDownloadProtocol = (SELECT value FROM GXGlobalParam WITH(nolock) WHERE name = 'Patch Download Protocol')
IF @option = 0
BEGIN
	SET @forceClientSideDownload = ISNULL((SELECT attrVal FROM App_ClientProp WITH(nolock) WHERE componentNameId = @clientId AND attrName = 'Force Client Side Download' AND modified = 0), @ForceClientSideDownloadDefault)
	IF @forceClientSideDownload = @ForceClientSideDownloadDefault
	BEGIN
		IF EXISTS
			(SELECT 1 FROM APP_ComponentProp as cp WITH(NOLOCK)
			INNER JOIN APP_ClientGroupAssoc as cga WITH(NOLOCK)
			ON cp.componentId = cga.clientGroupId
			AND cp.propertyTypeId = 3700
			AND cp.longVal = 1
			AND cga.clientId = @clientId)
		BEGIN
			SET @forceClientSideDownload = @ForceClientSideDownloadYes
		END
		ELSE
		BEGIN
			SET @forceClientSideDownload = @ForceClientSideDownloadNo
		END
	END
	IF @patchDownloadProtocol = 'FTP'
	BEGIN
		SET @forceClientSideDownload = @ForceClientSideDownloadNo
	END
END
ELSE
BEGIN
	IF @patchDownloadProtocol <> 'FTP'  AND
	EXISTS (SELECT 1 FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'Patch Use New Download' and value = '1')
		SET @showForceClientSideDownload = 1
	ELSE
		SET @showForceClientSideDownload = 0
END
SELECT
CASE @showforceClientSideDownload WHEN -1 THEN NULL ELSE @showForceClientSideDownload END AS 'showForceClientSideDownload',
CASE @forceClientSideDownload WHEN -1 THEN NULL ELSE @forceClientSideDownload END AS 'forceClientSideDownload'
FOR XML PATH(''), ROOT('App_IsForceClientSideDownloadSetResp')
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'IsForceClientSideDownloadSet')
	delete from GxQscripts where name = 'IsForceClientSideDownloadSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IsForceClientSideDownloadSet')
	delete from GXDBVersions where aliasname = 'IsForceClientSideDownloadSet'
GO

insert into GXDBVersions values(2, 'IsForceClientSideDownloadSet',  '00000000000000000000', 'IsForceClientSideDownloadSet', '00000000000000000000')
GO

