

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/IsCloudLibraryConfiguredOnStore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/IsCloudLibraryConfiguredOnStore.sp,v $ $Id: IsCloudLibraryConfiguredOnStore.sp,v 1.1.4.4 2020/12/24 01:27:21 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='IsCloudLibraryConfiguredOnStore')
BEGIN
	print '>>> Drop Stored Procedure: IsCloudLibraryConfiguredOnStore <<<'
	drop procedure IsCloudLibraryConfiguredOnStore
END
IF EXISTS (select * from GxQscripts where name='IsCloudLibraryConfiguredOnStore')
	delete from GxQscripts where name = 'IsCloudLibraryConfiguredOnStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IsCloudLibraryConfiguredOnStore')
	delete from GXDBVersions where aliasname = 'IsCloudLibraryConfiguredOnStore'
GO
print '... Creating Procedure: IsCloudLibraryConfiguredOnStore'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure IsCloudLibraryConfiguredOnStore
  @i_adminJobId int,
  @i_srcSIDBStoreId int
AS
  DECLARE @o_retVal integer;
  DECLARE @o_isCloudLibraryConfiguredOnStore integer;
  DECLARE @o_isMicroPruningDisabled integer;
  DECLARE @o_isPrunerMAFound integer;
SET NOCOUNT ON
DECLARE @l_retVal			integer = 0
DECLARE @l_isCloudLibraryConfiguredOnStore		integer = 0
DECLARE @l_isMicroPruningDisabled	integer = 0
DECLARE @l_isPrunerMANotFound		integer = 0
DECLARE @l_srcMediaAgentId INTEGER = dbo.GetOptionInt(1564054677, @i_adminJobId, 0, 0)
BEGIN TRY
	SELECT	TOP 1 @l_isCloudLibraryConfiguredOnStore = 1
	FROM	MMVolume MV WITH (READUNCOMMITTED), MMMountPath MP WITH (READUNCOMMITTED)
	WHERE	MV.SIDBStoreId = @i_srcSIDBStoreId
		AND MV.MediaSideId = MP.MediaSideId
		AND MP.MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
	IF ( @l_isCloudLibraryConfiguredOnStore = 1)
	BEGIN
		DECLARE @copyMountPathTable TABLE (archCopyId INTEGER, MountPathId INTEGER, MountPathTypeId INT, MountPathAttribute INT)
		DECLARE @copyClientTable TABLE (archCopyId INTEGER, ClientId INTEGER, DeviceAccessType INTEGER)
		INSERT INTO @copyMountPathTable(archCopyId, MountPathId, MountPathTypeId, MountPathAttribute)
		SELECT	DISTINCT S.archGroupCopyId,  MP.MountPathId, MP.MountPathTypeId, MP.Attribute
		FROM	MMVolume MV WITH (NOLOCK), archStream S WITH (NOLOCK), MMMountPath MP WITH (NOLOCK)
		WHERE	MV.SIDBStoreId = @i_srcSIDBStoreId
				AND MV.MediaGroupId = S.MediaGroupId
				AND MV.MediaSideId = MP.MediaSideId
IF EXISTS (SELECT TOP 1 1 FROM @copyMountPathTable MP WHERE MP.MountPathAttribute & 32 = 0 )
		BEGIN
SET @l_retVal = 1
			GOTO CX_EXIT
		END
		DECLARE @iCopyId INT = (SELECT	CS.CopyId
								FROM	archCopySIDBStore CS WITH (READUNCOMMITTED)
										INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED)  ON CS.CopyId = AGC.id
								WHERE	CS.SIDBStoreId = @i_srcSIDBStoreId
AND AGC.dedupeFlags & 134217728 = 0)
		INSERT INTO @copyClientTable (archCopyId, ClientId, DeviceAccessType)
		SELECT	DISTINCT CV.archCopyId, C.ClientId, C.DeviceAccessType
		FROM	MMDataPath DPath WITH (READUNCOMMITTED)
				INNER JOIN MMDrivePool DPool WITH (READUNCOMMITTED)  ON DPool.DrivePoolId = DPath.DrivePoolId
				INNER JOIN  MMMountPath MP WITH (READUNCOMMITTED)   ON MP.MasterPoolId = DPool.MasterPoolId
				INNER JOIN @copyMountPathTable CV ON MP.MountPathId = CV.MountPathId
				INNER JOIN MMMountPathToStorageDevice SD WITH (NOLOCK) ON CV.MountPathId = SD.MountPathId
				INNER JOIN MMDeviceController C WITH (NOLOCK) ON SD.DeviceId = C.DeviceId AND DPool.ClientId = C.ClientId
		WHERE   DPath.CopyId = @iCopyId
AND MP.Attribute & 256 > 0
AND MP.Attribute & 32 > 0
AND DPath.flag & (/*MMS2_PREFERRED_PRUNER |*/ 64 | 4) = (/*MMS2_PREFERRED_PRUNER |*/ 64 | 4)
				AND MP.MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
		IF NOT EXISTS(SELECT 1 FROM @copyClientTable)
		BEGIN
			INSERT INTO @copyClientTable (archCopyId, ClientId, DeviceAccessType)
			SELECT DISTINCT CV.archCopyId, DC.ClientId, DC.DeviceAccessType
			FROM   MMDeviceController DC WITH (READUNCOMMITTED)
				INNER JOIN MMMountPathToStorageDevice MSD WITH (READUNCOMMITTED)  ON DC.DeviceId = MSD.DeviceId
				INNER JOIN MMMountPath MP WITH (READUNCOMMITTED)  ON MSD.MountPathId = MP.MountPathId
				INNER JOIN @copyMountPathTable CV ON MP.MountPathId = CV.MountPathId
				INNER JOIN MMDrivePool DPool WITH (READUNCOMMITTED)  ON MP.MasterPoolId = DPool.MasterPoolId AND DPool.ClientId = DC.ClientId
				INNER JOIN MMDataPath DPath WITH (READUNCOMMITTED)  ON DPool.DrivePoolId = DPath.DrivePoolId AND DPath.CopyId = @iCopyId
			WHERE
MP.Attribute & 256 = 0
AND MP.Attribute & 32 > 0
				AND MP.MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
AND (DC.UseCount & 1) > 0
		END
		/*If the pruner MA not found in the datapath, go across all the MA configured on mountpaths*/
		IF NOT EXISTS(SELECT 1 FROM @copyClientTable)
		BEGIN
			INSERT INTO @copyClientTable (archCopyId, ClientId, DeviceAccessType)
			SELECT DISTINCT CV.archCopyId, DC.ClientId, DC.DeviceAccessType
			FROM   MMDeviceController DC WITH (READUNCOMMITTED)
				INNER JOIN MMMountPathToStorageDevice MSD WITH (READUNCOMMITTED)  ON DC.DeviceId = MSD.DeviceId
				INNER JOIN MMMountPath MP WITH (READUNCOMMITTED)  ON MSD.MountPathId = MP.MountPathId
				INNER JOIN @copyMountPathTable CV ON MP.MountPathId = CV.MountPathId
				INNER JOIN MMDrivePool DPool WITH (READUNCOMMITTED)  ON MP.MasterPoolId = DPool.MasterPoolId AND DPool.ClientId = DC.ClientId
			WHERE
MP.Attribute & 256 = 0
AND MP.Attribute & 32 > 0
				AND MP.MountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
AND (DC.UseCount & 1) > 0
		END
		IF NOT EXISTS (SELECT 1 FROM @copyClientTable)
		BEGIN
SET @l_retVal = 2
			GOTO CX_EXIT
		END
		IF (NOT EXISTS (SELECT TOP 1 1 FROM @copyClientTable WHERE ClientId = @l_srcMediaAgentId) AND (@l_srcMediaAgentId > 0))
		BEGIN
SET @l_retVal = 3
			GOTO CX_EXIT
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	;THROW;
END CATCH
CX_EXIT:
SELECT	@l_retVal, @l_isCloudLibraryConfiguredOnStore, @l_isMicroPruningDisabled, @l_isPrunerMANotFound
GO

IF EXISTS (select * from GxQscripts where name = 'IsCloudLibraryConfiguredOnStore')
	delete from GxQscripts where name = 'IsCloudLibraryConfiguredOnStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IsCloudLibraryConfiguredOnStore')
	delete from GXDBVersions where aliasname = 'IsCloudLibraryConfiguredOnStore'
GO

insert into GXDBVersions values(2, 'IsCloudLibraryConfiguredOnStore',  '00010001000400040000', 'IsCloudLibraryConfiguredOnStore', '00010001000400040000')
GO

