

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/IsClientResourceUsageMeetingThreshold.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  IsClientResourceUsageMeetingThreshold()
--  |
--  | Description:  Returns true/false
--  |
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Mohammad Dilshad		Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='IsClientResourceUsageMeetingThreshold')
BEGIN
	print '>>> Drop Stored Procedure: IsClientResourceUsageMeetingThreshold <<<'
	drop procedure IsClientResourceUsageMeetingThreshold
END
IF EXISTS (select * from GxQscripts where name='IsClientResourceUsageMeetingThreshold')
	delete from GxQscripts where name = 'IsClientResourceUsageMeetingThreshold'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IsClientResourceUsageMeetingThreshold')
	delete from GXDBVersions where aliasname = 'IsClientResourceUsageMeetingThreshold'
GO
print '... Creating Procedure: IsClientResourceUsageMeetingThreshold'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure IsClientResourceUsageMeetingThreshold
  @clientId INT,
  @resourceType INT,
  @thresholdPercentage INT ,
  @numberOfHours INT = 2,
  @referenceTime INT = 0,
  @comparisonType INT = 0
AS
  DECLARE @result INT
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	SELECT CASE WHEN @comparisonType = 0 AND avgPercentage >= @thresholdPercentage THEN 1
		WHEN @comparisonType = 1 AND avgPercentage <= @thresholdPercentage THEN 1
		ELSE 0 END AS result  FROM
		(
			SELECT COUNT(percentageConsumed) AS dataCount, AVG(percentageConsumed) AS avgPercentage FROM
			(
				SELECT TOP (@numberOfHours * 4) CASE WHEN @resourceType = 0 THEN 100 - percentFreePhysicalMemory ELSE cpuUsage END AS percentageConsumed
					FROM [HistoryDB].[dbo].MMPerformanceHistory WHERE clientId = @clientId AND DBO.GetUnixTime(creationDate) >= @referenceTime ORDER BY creationDate DESC
			)T1
		)T2 WHERE dataCount > 4
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'IsClientResourceUsageMeetingThreshold')
	delete from GxQscripts where name = 'IsClientResourceUsageMeetingThreshold'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IsClientResourceUsageMeetingThreshold')
	delete from GXDBVersions where aliasname = 'IsClientResourceUsageMeetingThreshold'
GO

insert into GXDBVersions values(2, 'IsClientResourceUsageMeetingThreshold',  '00000000000000000000', 'IsClientResourceUsageMeetingThreshold', '00000000000000000000')
GO

