

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/IsClientPartOfSmartNetworkTopology.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/IsClientPartOfSmartNetworkTopology.sp,v $ $Id: IsClientPartOfSmartNetworkTopology.sp,v 1.1.4.3 2019/03/13 23:17:29 pparvatham Exp $";
-- This SP checks if the given client is part of a Smart Network Topology
-- @i_clientId INTEGER
-- Returns 1 if client is part of Smart Network Topology, 0 otherwise
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='IsClientPartOfSmartNetworkTopology')
BEGIN
	print '>>> Drop Stored Procedure: IsClientPartOfSmartNetworkTopology <<<'
	drop procedure IsClientPartOfSmartNetworkTopology
END
IF EXISTS (select * from GxQscripts where name='IsClientPartOfSmartNetworkTopology')
	delete from GxQscripts where name = 'IsClientPartOfSmartNetworkTopology'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IsClientPartOfSmartNetworkTopology')
	delete from GXDBVersions where aliasname = 'IsClientPartOfSmartNetworkTopology'
GO
print '... Creating Procedure: IsClientPartOfSmartNetworkTopology'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure IsClientPartOfSmartNetworkTopology
  @i_clientId INTEGER,
  @o_isPartOfSmartTopology INTEGER OUTPUT 
AS
  DECLARE @isPartOfSmartTopology integer = 0
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
/* If client is part of smart topology */
SELECT @isPartOfSmartTopology = 1
FROM APP_FirewallTopology AFT
INNER JOIN APP_FirewallTopologyAssoc AFTA
ON AFT.topologyId = AFTA.topologyId AND ( AFT.flag & 1 = 1)
INNER JOIN APP_ClientGroupAssoc ACGA
ON AFTA.groupId = ACGA.clientGroupId
WHERE ACGA.clientId = @i_clientId
IF @isPartOfSmartTopology = 1
	GOTO RETURN_FROM_HERE
/* We still have to check for MAs, CS, Index Server etc */
-- Topology Association : Table containing smart topology AND its associated groups
IF OBJECT_ID('tempdb..#topoAssoc') IS NOT NULL
    DROP TABLE #topoAssoc
CREATE TABLE #topoAssoc
(
    topologyId INT,
    internalGrp INT,
    externalGrp INT
    PRIMARY KEY (topologyId)
)
-- Insert topology associations
INSERT INTO #topoAssoc (topologyId, internalGrp, externalGrp)
SELECT TopoAssoc.topologyId, TopoAssoc.internalGrp ,TopoAssoc.externalGrp
FROM
(
SELECT topologyId, MAX(CASE WHEN fwGroupType = 1 THEN groupId ELSE -2147483648 END) internalGrp, MAX(CASE WHEN fwGroupType = 2 THEN groupId ELSE -2147483648 END) externalGrp  FROM APP_FirewallTopologyAssoc group by topologyId
) TopoAssoc
INNER JOIN APP_FirewallTopology AFT ON TopoAssoc.topologyId = AFT.topologyId AND AFT.flag & 1 = 1
IF OBJECT_ID('tempdb..#tempTbl') IS NOT NULL
    DROP TABLE #tempTbl
CREATE TABLE #tempTbl
(
    topologyId INT,
    internalClientId INT,
    externalClientId INT
)
CREATE CLUSTERED INDEX Idx_tempTbl_externalClientId ON #tempTbl(externalClientId)
CREATE NONCLUSTERED INDEX Idx_tempTbl_internalClientId ON #tempTbl(internalClientId)
-- Expand non-mnemonic client group IN [@topoAssoc.externalGrp, #topoAssoc.internalGrp] to clientIds. Leave the mnemonic as IS
INSERT INTO #tempTbl (topologyId, internalClientId, externalClientId)
SELECT TA.topologyId
,CASE WHEN ACGA.clientId IS NULL THEN CASE WHEN internalGrp < 0 THEN internalGrp ELSE 0 END ELSE ACGA.clientId END internalClientId
,CASE WHEN ACGA1.clientId IS NULL THEN CASE WHEN externalGrp < 0 THEN externalGrp ELSE 0 END ELSE ACGA1.clientId END externalClientId
FROM #topoAssoc TA
LEFT JOIN APP_ClientGroupAssoc ACGA ON TA.internalGrp = ACGA.clientGroupId
LEFT JOIN APP_ClientGroupAssoc ACGA1 ON TA.externalGrp = ACGA1.clientGroupId
IF OBJECT_ID('tempdb..#topoAssoc') IS NOT NULL
    DROP TABLE #topoAssoc
-- Check if the client is CS and part of smart topology
IF @i_clientId=2
BEGIN
	SELECT @isPartOfSmartTopology = 1
	FROM #tempTbl TT where (TT.internalClientId < 0 OR TT.externalClientId < 0)
	IF @isPartOfSmartTopology = 1
		GOTO RETURN_FROM_HERE
END
--
--Get all clients for the mnemonic client group using the non-mnemonic group
--
--Code Below Here is From AppGetClientMediaAgentMap.spb
BEGIN
	IF OBJECT_ID('tempdb.dbo.#ClientMediaAgentMap') IS NOT NULL
		DROP TABLE #ClientMediaAgentMap
	CREATE TABLE #ClientMediaAgentMap
	(
		clientId INT,
		mediaAgentId INT,
		PRIMARY KEY(clientId,mediaAgentId)
	);
	IF OBJECT_ID('tempdb..#lt_Clients') IS NOT NULL DROP TABLE #lt_Clients
	CREATE TABLE #lt_Clients
	(
		clientId	INT
		PRIMARY KEY(clientId)
	)
	IF OBJECT_ID('tempdb.dbo.#tempArchGrp') IS NOT NULL
		DROP TABLE #tempArchGrp
	CREATE TABLE #tempArchGrp
	(
		clientId	INT,
		archGroupId	INT,
		primaryCopyId smallint,
		primarySnapCopyId smallint
	)
	CREATE CLUSTERED INDEX  tempArchGrp_idx1 ON #tempArchGrp(primaryCopyId)
	CREATE NONCLUSTERED INDEX  tempArchGrp_idx2 ON #tempArchGrp(primarySnapCopyId, clientId)
DECLARE @cs_assocPlan INT = checksum('Associated Plan')
	-- Get all index servers
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
	CREATE TABLE #getIndexServers
						(     serverURL NVARCHAR(512),
								clientId INT,
								clientName NVARCHAR(256),
								cloudId INT,
								hostName NVARCHAR(256),
								basePort INT,
								engineName  NVARCHAR(256),
								serverType INT,
								indexServerClientId INT,
								internalCloudName NVARCHAR(256)
						)
	EXEC DM2GetIndexServers
	-- Get Source Clients
		INSERT 	INTO #lt_Clients
		SELECT	CN.id
		FROM	App_Client CN WITH(READUNCOMMITTED)
		INNER JOIN #tempTbl T ON
		T.internalClientId > 0 AND CN.id=T.internalClientId
		WHERE CN.id > 1
		UNION
		SELECT CN.id
		FROM App_Client CN WITH(READUNCOMMITTED)
		INNER JOIN #tempTbl T ON
		T.externalClientId > 0 AND CN.id=T.externalClientId
		WHERE CN.id > 1
	--
	--Find destination clients
	--
	IF @@ROWCOUNT > 0
	BEGIN
		-- Get all the storage policies
		INSERT INTO #tempArchGrp
		SELECT 	distinct APP.clientId, AG.id, AG.defaultCopy, AG.defaultSnapCopy
		FROM	#lt_Clients CN
				INNER JOIN App_Application APP WITH(READUNCOMMITTED)
				ON CN.clientId = APP.clientId
				INNER JOIN 	archGroup AAG WITH(READUNCOMMITTED)
				ON APP.dataArchGrpId = AAG.id,
				archGroup AG
		WHERE 	AG.id in (AAG.id, AAG.incrSP)
				AND AG.id > 1
		UNION
		SELECT 	distinct APP.clientId, AG.id, AG.defaultCopy, AG.defaultSnapCopy
		FROM	#lt_Clients CN
				INNER JOIN App_Application APP WITH(READUNCOMMITTED)
				ON CN.clientId = APP.clientId
				INNER JOIN 	archGroup AAG WITH(READUNCOMMITTED)
				ON APP.logArchGrpId = AAG.id,
				archGroup AG
		WHERE 	AG.id in (AAG.id, AAG.incrSP)
				AND AG.id > 1
		--Get client to infrastructure map
		INSERT INTO #ClientMediaAgentMap
		-- MediaAgents
		SELECT 	TA.clientId, DPool.clientId
		FROM 	#tempArchGrp TA,
				MMDataPath DPath WITH(READUNCOMMITTED),
				MMDrivePool DPool WITH(READUNCOMMITTED)
		WHERE	TA.primarySnapCopyId = DPath.copyId
				AND DPath.copyId > 0
				AND DPath.DrivePoolId = DPool.DrivePoolId
		UNION
		SELECT 	TA.clientId, DPool.clientId
		FROM 	#tempArchGrp TA,
				MMDataPath DPath WITH(READUNCOMMITTED),
				MMDrivePool DPool WITH(READUNCOMMITTED)
		WHERE	TA.primaryCopyId = DPath.copyId
				AND DPath.copyId > 0
				AND DPath.DrivePoolId = DPool.DrivePoolId
		UNION
		-- DDB Engines
		SELECT 	TA.clientId, SS.clientId
		FROM 	#tempArchGrp TA,
				archCopySIDBStore CPS WITH(READUNCOMMITTED),
				IdxSIDBStore S WITH(READUNCOMMITTED),
				IdxSIDBSubStore SS WITH(READUNCOMMITTED)
		WHERE	TA.primaryCopyId = CPS.copyId
				AND CPS.SIDBStoreId = S.SIDBStoreId
				AND S.sealedTime = 0 --ActiveStores
				AND S.SIDBStoreId = SS.SIDBStoreId
		UNION
		-- IndexServers: Exchange
		SELECT 	CN.clientId, S.clientId
		FROM 	#lt_Clients CN,
				APP_IDAName IDN WITH(READUNCOMMITTED),
				App_IdaProp IP WITH(READUNCOMMITTED), #getIndexServers S
		WHERE  	CN.clientId = IDN.clientId
				AND IP.componentNameId = IDN.ID
				AND IP.attrName = 'OnePass Index Server'
				AND IP.modified = 0
				AND S.indexServerClientId = CAST (IP.AttrVal AS INT)
		UNION
		-- IndexServers: Edge
		SELECT  CN.clientId, S.clientId
		FROM  	#lt_Clients CN,
				App_EdgeDriveAssociation EDGE WITH(READUNCOMMITTED), #getIndexServers S
		WHERE  	CN.clientId = EDGE.clientId
AND S.indexServerClientId = EDGE.entityId AND EDGE.entityType = 3
		UNION
		-- IndexServers: Edge Laptop clients
		SELECT	CN.clientId, EDW.webserverId
		FROM 	#lt_Clients CN
				INNER JOIN App_Client CL  WITH(READUNCOMMITTED) ON CN.clientId = CL.id
				INNER JOIN App_SyncCloudConfig SC  WITH(READUNCOMMITTED) ON CL.id = SC.clientId
				INNER JOIN App_SyncCloudFolder SF  WITH(READUNCOMMITTED) ON SC.syncWebFolderId = SF.syncWebFolderId
				INNER JOIN APP_Application APP  WITH(READUNCOMMITTED) ON APP.id = SC.subclientId
				INNER JOIN AppEdgeDriveWebserverAssociation EDW  WITH(READUNCOMMITTED) ON EDW.edgeClientId = APP.clientId
WHERE 	CL.status & 0x1000 > 0
AND SF.flag &  0x10 > 0
AND APP.subclientStatus & 0x20000 > 0
		UNION
		-- IndexServers: FileSystem
		SELECT  CN.clientId, S.clientId
		FROM  	#lt_Clients CN,
				App_Application APP WITH(READUNCOMMITTED),
				App_IndexDBInfo idx WITH(READUNCOMMITTED), #getIndexServers S
		WHERE	CN.clientId = APP.clientId
				AND idx.backupSetId = APP.backupSet
				AND S.indexServerClientId = idx.currentIdxServer
		UNION
		-- IndexServers: Plan VSA
		SELECT  T.clientId, S.clientId
		FROM  	(
					SELECT 	CN.clientId, CAST(CP.attrVal AS INT) PlanId
					FROM 	#lt_Clients CN,
							App_clientProp CP WITH(READUNCOMMITTED)
					WHERE 	CN.clientId = CP.componentNameId
AND CP.attrName = 'Associated Plan'
							AND CP.modified = 0
					UNION
					SELECT 	CN.clientId, CAST(SCP.attrVal AS INT) PlanId
					FROM 	#lt_Clients CN,
							App_Application SC WITH(READUNCOMMITTED),
							App_SubclientProp SCP WITH(READUNCOMMITTED)
					WHERE 	CN.clientId = SC.clientId
							AND SCP.componentNameId = SC.id
							AND SCP.cs_attrName = @cs_assocPlan
AND SCP.attrName = 'Associated Plan'
							AND SCP.modified = 0
				) AS T,
				App_PlanProp PROP WITH(READUNCOMMITTED), #getIndexServers S
		WHERE	PROP.componentNameId = T.PlanId
				AND PROP.attrName = 'Analytics Index Server Id'
				AND PROP.modified = 0
				AND S.indexServerClientId = CAST (PROP.AttrVal AS INT)
		UNION
		-- Remote SoftwareCache: Client Level
		SELECT  CN.clientId, UA.clientId
		FROM  	#lt_Clients CN,
				App_clientProp CP WITH(READUNCOMMITTED),
				PatchUpdateAgentInfo UA WITH(READUNCOMMITTED)
		WHERE 	CN.clientId = CP.componentNameId
				AND CP.attrName = N'UPDATE CACHE AGENT ID'
				AND CP.modified = 0
				AND CAST(CP.attrVal AS INT) = UA.id
		UNION
		-- Remote SoftwareCache: ClientGroup Level
		SELECT  CN.clientId, UA.clientId
		FROM  	#lt_Clients CN,
				App_ClientGroupAssoc CGA WITH(READUNCOMMITTED),
				APP_ComponentProp CP WITH(READUNCOMMITTED),
				PatchUpdateAgentInfo UA WITH(READUNCOMMITTED)
		WHERE 	CN.clientId = CGA.clientId
				AND CGA.clientGroupId = CP.componentId
AND CP.componentType = 8
AND CP.propertyTypeId = 1300
				AND CP.modified = 0
				AND CP.longVal = UA.id
		--
		--Remove entries if source and dest are same
		--
		DELETE 	#ClientMediaAgentMap
		WHERE	clientId = mediaAgentId
		-- Remove entries for invalid MAs.
		-- Example: On deleting a DDB MA without deleting relevant partition info (feature introduced in SP19), a MA entry with clientid=1 (NOCLIENT) is used as a placeholder.
		-- Such MA ids are invalid for general processing
		DELETE 	#ClientMediaAgentMap
		WHERE	mediaAgentId < 2
	END
	IF OBJECT_ID('tempdb..#lt_Clients') IS NOT NULL 			DROP TABLE #lt_Clients
	IF OBJECT_ID('tempdb.dbo.#tempArchGrp') IS NOT NULL 		DROP TABLE #tempArchGrp
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
END
SELECT @isPartOfSmartTopology = 1
FROM #ClientMediaAgentMap
WHERE mediaAgentId = @i_clientId
IF OBJECT_ID('tempdb..#tempTbl') IS NOT NULL
    DROP TABLE #tempTbl
IF OBJECT_ID('tempdb..#ClientMediaAgentMap') IS NOT NULL
    DROP TABLE #ClientMediaAgentMap
RETURN_FROM_HERE:
SET @o_isPartOfSmartTopology = @isPartOfSmartTopology
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'IsClientPartOfSmartNetworkTopology')
	delete from GxQscripts where name = 'IsClientPartOfSmartNetworkTopology'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IsClientPartOfSmartNetworkTopology')
	delete from GXDBVersions where aliasname = 'IsClientPartOfSmartNetworkTopology'
GO

insert into GXDBVersions values(2, 'IsClientPartOfSmartNetworkTopology',  '00010001000400030000', 'IsClientPartOfSmartNetworkTopology', '00010001000400030000')
GO

