

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/IndexCopyUpdateReferenceTime.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2012  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/IndexCopyUpdateReferenceTime.sp,v $ $Id: IndexCopyUpdateReferenceTime.sp,v 1.1.2.9 2020/08/06 08:06:01 nuppu Exp $"
--
--  +========================================================================+
--  | Stored Precedure: IndexCopyUpdateReferenceTime()
--  |
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='IndexCopyUpdateReferenceTime')
BEGIN
	print '>>> Drop Stored Procedure: IndexCopyUpdateReferenceTime <<<'
	drop procedure IndexCopyUpdateReferenceTime
END
IF EXISTS (select * from GxQscripts where name='IndexCopyUpdateReferenceTime')
	delete from GxQscripts where name = 'IndexCopyUpdateReferenceTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IndexCopyUpdateReferenceTime')
	delete from GXDBVersions where aliasname = 'IndexCopyUpdateReferenceTime'
GO
print '... Creating Procedure: IndexCopyUpdateReferenceTime'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure IndexCopyUpdateReferenceTime
  @inXML XML
AS
  DECLARE @outXml XML
BEGIN
BEGIN TRY
	BEGIN TRAN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON
	DECLARE @jobId bigint
	DECLARE @commcellId int = 2
	DECLARE @errorCode INT = 0
	DECLARE @errorMsg nvarchar(max) = ''
	DECLARE @lockResult						int = -1
	DECLARE @lockName						varchar(64) = ''
	DECLARE @definitionId INT
	DECLARE @IndexCopyJobStatsXML nvarchar(max) = '<ExchangeVirtualAgent_IndexCopyStats/>'
	DECLARE @successfulSC	INT = 0
	DECLARE @failedSC		INT = 0
	DECLARE @pendingSC		INT = 0
	DECLARE @totalSC		INT = 0
	DECLARE @inProgressSC	INT = 0
	DECLARE @jobXmlFromDB	XML
	DECLARE @itemCount	bigint
	DECLARE @itemSize	bigint
	DECLARE @noOfItemsCIed	bigint
	DECLARE @caseStatsXML	XML
	DECLARE @caseSubclientId	INT = 0
	DECLARE @jobTotalItems	BIGINT = 0
	DECLARE @jobAppSize		BIGINT = 0
	DECLARE @indexCopyRefTimeTbl TABLE
	(
		defId				int,
		srcAppId			int,
		destAppId			int,
		refTime				bigint,
		status				int,
		reason				varchar(4096),
		itemCount			bigint,
		itemSize			bigint
	)
	-- None of these temp tables should ever exist when this procedure is called!
	IF object_id('tempdb.dbo.#jobStatsXMLTbl') IS NOT NULL
	   DROP TABLE #jobStatsXMLTbl
	SET @jobId = ISNULL((Select Tbl.Col.value('@jobId', 'bigint') From @inXML.nodes('ExchangeVirtualAgent_IndexCopyStats') Tbl(Col)), 0)
	SET @commcellId = ISNULL((Select Tbl.Col.value('@commcellId', 'int') From @inXML.nodes('ExchangeVirtualAgent_IndexCopyStats') Tbl(Col)), 2)
	-- Case level subclient stats
	SET @itemCount = ISNULL((Select Tbl.Col.value('@itemCount', 'bigint') From @inXML.nodes('ExchangeVirtualAgent_IndexCopyStats/totalStats/scStats') Tbl(Col)), 0)
	SET @itemSize = ISNULL((Select Tbl.Col.value('@itemSize', 'bigint') From @inXML.nodes('ExchangeVirtualAgent_IndexCopyStats/totalStats/scStats') Tbl(Col)), 0)
	SET @noOfItemsCIed = ISNULL((Select Tbl.Col.value('@itemsCIed', 'bigint') From @inXML.nodes('ExchangeVirtualAgent_IndexCopyStats/totalStats/scStats') Tbl(Col)), 0)
	-- Job level Subclient stats.
	SET @jobTotalItems = ISNULL((Select Tbl.Col.value('@itemCount', 'bigint') From @inXML.nodes('ExchangeVirtualAgent_IndexCopyStats/jobItemStats') Tbl(Col)), 0)
	SET @jobAppSize = ISNULL((Select Tbl.Col.value('@itemSize', 'bigint') From @inXML.nodes('ExchangeVirtualAgent_IndexCopyStats/jobItemStats') Tbl(Col)), 0)
	INSERT INTO @indexCopyRefTimeTbl
	SELECT
	ISNULL(Tbl.Col.value('@definitionId', 'int'), -1),
	ISNULL(Tbl.Col.value('(src/@subclientId)[1]', 'int'), -1),
	ISNULL(Tbl.Col.value('(dest/@subclientId)[1]', 'int'), -1),
	ISNULL(Tbl.Col.value('@referenceTime', 'bigint'), 0),
	ISNULL(Tbl.Col.value('@status', 'int'), '3'/*Skipped*/),
	ISNULL(Tbl.Col.value('@reason', 'varchar(max)'), ''),
	ISNULL(Tbl.Col.value('(itemStats/@itemCount)[1]', 'bigint'), 0),
	ISNULL(Tbl.Col.value('(itemStats/@itemSize)[1]', 'bigint'), 0)
	FROM @inXML.nodes('/ExchangeVirtualAgent_IndexCopyStats/scInfo') as Tbl(Col)
	SELECT *
	INTO #jobStatsXMLTbl
	FROM @indexCopyRefTimeTbl
	SET @caseSubclientId = ISNULL((SELECT TOP 1 destAppId FROM @indexCopyRefTimeTbl), 0)
	SET @lockName = 'IndexCopyUpdateReferenceTimeLock_' + cast(@jobId as varchar(16))
	EXEC @lockResult = sp_getapplock @Resource = @lockName, @LockMode = 'Exclusive', @LockTimeout = 60000
	IF @lockResult NOT IN (0, 1)
	BEGIN
		SET @errorCode = @lockResult
		SET @errorMsg = 'Procedure [IndexCopyUpdateReferenceTime] Failed to acquired lock on:'+@lockName
		ROLLBACK TRAN
		GOTO FINISH
	END
	IF EXISTS (SELECT TOP 1 1 FROM CMReference T , @indexCopyRefTimeTbl input
       where T.commcellId = @commcellId AND
       T.definitionId = input.defId AND
       T.srcAppId = input.srcAppId AND
       T.destAppId = input.destAppId )
       BEGIN
              Update T
              SET
              T.refTime = (CASE WHEN input.Status = 1/*ExchangeVirtualAgent::OperationStatus_SUCCESSFUL*/ THEN input.refTime ELSE T.refTime END),
              T.status = input.status
              FROM CMReference T, @indexCopyRefTimeTbl input
              Where
              T.refJobId = @jobId AND
              T.commcellId = @commcellId AND
              T.definitionId = input.defId AND
              T.srcAppId = input.srcAppId AND
              T.destAppId = input.destAppId
       END
       ELSE
       BEGIN
		   INSERT INTO CMReference
		   SELECT input.defId, input.destAppId, input.srcAppId, input.refTime, @jobId, @commcellId, 0, input.status, 0, 0
		   FROM @indexCopyRefTimeTbl input
       END
	IF @lockResult IN (0, 1)
		EXEC @lockResult = sp_releaseapplock @Resource = @lockName
	-- Job Details Tab
SET @jobXmlFromDB =  ISNULL((SELECT data From JMMisc Where jobid = @jobId and commcellId = @commcellId and itemType = 28), '<ExchangeVirtualAgent_IndexCopyStats/>')
	INSERT INTO #jobStatsXMLTbl
	SELECT
	ISNULL(Tbl.Col.value('@definitionId', 'int'), -1),
	ISNULL(Tbl.Col.value('(src/@srcAppId)[1]', 'int'), -1),
	ISNULL(Tbl.Col.value('(dest/@destAppId)[1]', 'int'), -1),
	ISNULL(Tbl.Col.value('@referenceTime', 'bigint'), -1),
	ISNULL(Tbl.Col.value('@status', 'int'), -1),
	ISNULL(Tbl.Col.value('@reason', 'varchar(max)'), -1),
	ISNULL(Tbl.Col.value('(itemStats/@itemCount)[1]', 'bigint'), 0),
	ISNULL(Tbl.Col.value('(itemStats/@itemSize)[1]', 'bigint'), 0)
	FROM
	@jobXmlFromDB.nodes('/ExchangeVirtualAgent_IndexCopyStats/scInfo') AS Tbl(Col)
	Update jobStats
	SET jobStats.refTime = input.refTime, jobStats.status = input.status, jobStats.reason = input.reason,
		jobStats.itemCount = input.itemCount, jobStats.itemSize = input.itemSize
	FROM #jobStatsXMLTbl jobStats, @indexCopyRefTimeTbl input
	Where jobStats.defId = input.defId AND jobStats.srcAppId = input.srcAppId AND jobStats.destAppId = input.destAppId
	SET @successfulSC = ISNULL((Select count(*) From @indexCopyRefTimeTbl WHERE status = 1/*OperationStatus.SUCCESSFUL*/), 0)
	SET @failedSC = ISNULL((Select count(*) From @indexCopyRefTimeTbl WHERE status = 5/*OperationStatus.FAILED*/), 0)
	SET @pendingSC = ISNULL((Select count(*) From @indexCopyRefTimeTbl WHERE status = 0/*OperationStatus.NONE*/), 0)
	SET @inProgressSC = ISNULL((Select count(*) From @indexCopyRefTimeTbl WHERE status = 7/*OperationStatus.IN_PROGRESS*/), 0)
	SET @totalSC = ISNULL((Select count(*) From @indexCopyRefTimeTbl), 0)
	SET @IndexCopyJobStatsXML =
		(
					SELECT
					(
						SELECT
						defId				'@definitionId',
						icrtl.refTime		'@referenceTime',
						icrtl.status		'@status',
						reason				'@reason',
						cmd.name			'@definitionName',
						srcSC.subclientName 'src/@subclientName',
						srcAppId			'src/@subclientId',
						srcCli.displayName  'src/@clientName',
						destSC.subclientName 'dest/@subclientName',
						destAppId			'dest/@subclientId',
						itemCount			'itemStats/itemCount',
						itemSize			'itemStats/itemSize'
						FROM @indexCopyRefTimeTbl icrtl, App_Application(NOLOCK) srcSC, App_Application(NOLOCK) destSC, CMDefinition(NOLOCK) cmd, App_Client(NOLOCK) srcCli
						Where icrtl.srcAppId = srcSC.id
						AND icrtl.destAppId = destSC.id
						AND icrtl.defId = cmd.id
						AND srcCli.id = srcSC.clientId
						FOR XML PATH('scInfo'), TYPE
					),
					(
						SELECT
						@successfulSC	'@successfulSC',
						@failedSC		'@failedSC',
						@pendingSC		'@pendingSC',
						@totalSC		'@totalSubclients',
						@inProgressSC   '@inProgressSC'
						FOR XML PATH('sourceSubclientCounters'), TYPE
					),
					(
						SELECT
						@jobTotalItems	'@itemCount',
						@jobAppSize		'@itemSize'
						FOR XML PATH('jobItemStats'), TYPE
					)
					For XML PATH(''), ROOT('ExchangeVirtualAgent_IndexCopyStats')
		)
IF EXISTS(SELECT 1 FROM JMMisc WHERE jobId = @jobId AND itemType = 28)
UPDATE JMMisc SET data = @IndexCopyJobStatsXML WHERE jobId = @jobId AND itemType = 28 AND commcellId = @commcellId
	ELSE
INSERT INTO JMMisc VALUES(@jobId, 0, 28, 0, 0, @IndexCopyJobStatsXML, @commcellId)
	-- Update Case Stats.
	IF @itemCount > 0 OR @itemSize > 0 OR @noOfItemsCIed > 0
	BEGIN
		SET @caseStatsXML =
		(
			SELECT
			@itemCount		'@numberOfItems',
			@noOfItemsCIed	'@numberOfItemsCIed',
			@itemSize		'@sizeOfItems'
			FOR XML PATH('App_CaseManagerMetrics')
		)
		IF EXISTS(SELECT 1 FROM APP_SubClientProp WHERE componentNameId = @caseSubclientId AND attrName = 'Case Manager Metrics' AND modified = 0)
			UPDATE App_SubclientProp SET attrVal = CAST(@caseStatsXML AS nvarchar(max)) WHERE componentNameId = @caseSubclientId AND attrName = 'Case Manager Metrics' AND modified = 0
		ELSE
			INSERT INTO App_SubclientProp VALUES (@caseSubclientId, 'Case Manager Metrics', 1, CAST(@caseStatsXML AS nvarchar(max)), dbo.getunixtime(getutcdate()), 0, 0)
	END
	COMMIT TRAN
END TRY
BEGIN CATCH
	ROLLBACK TRAN
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_MESSAGE()
	SET @errorMsg = 'Procedure [' + ERROR_PROCEDURE () + '] Error Line [' + CONVERT(nvarchar(5), ERROR_LINE()) + '].' + ERROR_MESSAGE()
END CATCH
FINISH:
	SET @outXml = (
					SELECT
						@errorCode '@errorCode',
						@errorMsg '@message'
					FOR XML PATH('App_GenericResp')
				  )
	SELECT @outXml
END
-------------------------------------------------------------------------------------------------------
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'IndexCopyUpdateReferenceTime')
	delete from GxQscripts where name = 'IndexCopyUpdateReferenceTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IndexCopyUpdateReferenceTime')
	delete from GXDBVersions where aliasname = 'IndexCopyUpdateReferenceTime'
GO

insert into GXDBVersions values(2, 'IndexCopyUpdateReferenceTime',  '00010001000200090000', 'IndexCopyUpdateReferenceTime', '00010001000200090000')
GO

