

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/IndexCopyGetConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/IndexCopyGetConfig.sp,v $ $Id: IndexCopyGetConfig.sp,v 1.1.2.15.8.1 2021/02/24 09:47:05 ssivananthan Exp $";
---- =============================================
---- Author:		Jaya Rama Raju
---- Create date:
---- Description:
---- =============================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='IndexCopyGetConfig')
BEGIN
	print '>>> Drop Stored Procedure: IndexCopyGetConfig <<<'
	drop procedure IndexCopyGetConfig
END
IF EXISTS (select * from GxQscripts where name='IndexCopyGetConfig')
	delete from GxQscripts where name = 'IndexCopyGetConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IndexCopyGetConfig')
	delete from GXDBVersions where aliasname = 'IndexCopyGetConfig'
GO
print '... Creating Procedure: IndexCopyGetConfig'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure IndexCopyGetConfig
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inXMl XML
AS
BEGIN
  DECLARE @xmlText XML 
SET NOCOUNT ON
DECLARE @inJobId		INT = 0
DECLARE @destSubclientId	INT = 0
DECLARE @destSubclientAppTypeId	INT = 0
DECLARE @destClientID		INT = 0
DECLARE @ownerName				VARCHAR(1024)
SET @inJobId			= ISNULL (( SELECT ref.value('@jobId','INTEGER') FROM @inXMl.nodes('ExchangeVirtualAgent_IndexCopyConfReq') R(ref)), 0)
SET @destSubclientId	= ISNULL(cast(dbo.GetJobOption(@inJobId, 140007 ) as int),-1)
SET @destClientID		= ISNULL((SELECT clientId FROM App_Application(NOLOCK) WHERE id = @destSubclientId), -1)
SET @destSubclientAppTypeId = ISNULL((SELECT appTypeId FROM App_Application(NOLOCK) WHERE id = @destSubclientId), -1)
SET @ownerName = ISNULL((SELECT TOP 1 UM.login FROM sec_getClientOwnersExpandUG CO, UMUsers UM WHERE clientId = @destClientID AND CO.userId = UM.id), '')
IF object_id('tempdb.dbo.#defintionTbl') IS NOT NULL
   DROP TABLE #defintionTbl
CREATE TABLE #defintionTbl
(
	id int,
	mode int
)
CREATE CLUSTERED INDEX defintionTbl_id_Idx1 ON #defintionTbl ([id])
UPDATE CMReference
SET refJobId = @inJobId,
status = 0 -- OperationStatus::OperationStatus_NONE
WHERE destAppId = @destSubclientId AND
( refJobId != @inJobId OR (refJobId = @inJobId AND status NOT IN (1/*OperationStatus_SUCCESSFUL*/, 3/*OperationStatus_SKIPPED*/, 5/*OperationStatus_FAILED*/)))
INSERT INTO #defintionTbl
SELECT def.id, ISNULL(defXml.value('(/Ida_CMDefinitionReq/cmDef/@ingestionMode)[1]', 'Integer'), 2/*CMDefinitionIngestionMode.INCREMENTAL*/)
FROM CMDefinition(NOLOCK) def
WHERE def.id IN(SELECT DISTINCT definitionId FROM CMReference(NOLOCK) WHERE destAppId = @destSubclientId)
SET @xmlText =
	(
		SELECT
		@ownerName '@ownerName',
		(
			SELECT
			Def.id '@definitionId',
			ISNULL(Def.defXml.query('/Ida_CMDefinitionReq/cmDef/defXml/searchReq'), '<searchReq/>'),
			(
				SELECT
				cust.userGuid '@guid',
				cust.smtp '@smtp',
ISNULL(defXml.value('(/Ida_CMDefinitionReq/cmDef/defXml/custodianInfo/@loginName)[1]', 'NVARCHAR(255)'), '')  '@loginName'
				FROM CMCustodian(NOLOCK) cust
				WHERE Def.id = cust.definitionId
				AND cust.modified = 0
				FOR XML PATH('custodians'), TYPE, ROOT('custodianList')
			)
			FROM CMDefinition(NOLOCK) Def
			WHERE Def.id IN(SELECT id FROM #defintionTbl)
			FOR XML PATH('defInfo'), TYPE
		),
		(
			SELECT
			IC.definitionId		'@definitionId',
			IC.refTime			'@referenceTime',
			def.mode			'@mode',
CASE WHEN srcApp.appTypeId = 137 THEN ISNULL(EmailApp.mailboxType,0)
WHEN (srcApp.appTypeId = 33 or srcApp.appTypeId = 29)  AND (EXISTS (select id from APP_client WITH (NOLOCK) where id = srcApp.clientId and status & 4096 = 4096)) THEN 5
WHEN (srcApp.appTypeId = 33 or srcApp.appTypeId = 29) THEN 4
				 ELSE 0
			    END '@srcHoldType', /* Exchange(1, 2, 3), FS(4), Laptop(5)*/
			CASE WHEN EXISTS (select attrval from APP_SubClientProp WITH (NOLOCK) where componentNameId = IC.srcAppId and modified = 0 and attrname = 'Enable Content Indexing' and attrval = '1' ) THEN 2
WHEN EXISTS (select attrval from APP_SubClientProp WITH (NOLOCK) where componentNameId = IC.srcAppId and modified = 0 and attrname = 'Associated DC Plan' and cs_attrName = checksum(N'Associated DC Plan') and ISNULL(dbo.AppPlanGetEntityValueV2(attrval, 'Content Indexing Policy', default),0) > 0)  THEN 2
WHEN EXISTS (select attrval from APP_ClientProp WITH (NOLOCK) where componentNameId = srcApp.clientId and modified = 0 and attrname = 'Content Indexing Enabled' and attrval = '1') THEN 1
				 ELSE 0
				END  '@srcEngineType', /* SearchEngine(1), AnalyticsEngine(2) */
			IC.srcAppId			'src/@subclientId',
			srcApp.appTypeId	'src/@applicationId',
			IC.destAppId		'dest/@subclientId',
			Cli.displayName		'dest/@clientName',
			BkpSet.id			'dest/@backupsetId',
			BkpSet.GUID			'dest/@backupsetGUID',
			@destClientID		'dest/@clientId'
			FROM CMReference(nolock) IC
			INNER JOIN #defintionTbl def ON IC.definitionId = def.id
			INNER JOIN APP_Application(NOLOCK) App ON IC.destAppId = App.Id
			INNER JOIN App_Application(NOLOCK) srcApp ON srcApp.id = IC.srcAppId
			INNER JOIN App_BackupsetName(NOLOCK) BkpSet ON BkpSet.id = App.backupSet
			INNER JOIN App_Client(NOLOCK) Cli ON Cli.id = App.ClientId
			OUTER APPLY ( SELECT TOP 1 mailBoxType FROM APP_EmailConfigPolicyAssoc(NOLOCK) where subClientId = IC.srcAppId AND mailBoxType IS NOT NULL ) EmailApp
			WHERE IC.destAppId = @destSubclientId
			AND IC.refJobId = @inJobId AND IC.status=0 AND IC.modified = 0
			AND
			(
				 1 = CASE
WHEN App.appTypeId = 137 AND def.mode in(1/*OneTime*/, 2/*Incremental*/, 3/*Disabled*/) THEN 1   -- For Exchange include all the defintions.
					  WHEN def.mode = 1 AND IC.refTime = 0 THEN 1
					  WHEN def.mode = 2 THEN 1
					  ELSE 0
			     END)
			FOR XML PATH('scInfo'), TYPE
		)
		FOR XML PATH('ExchangeVirtualAgent_IndexCopyConfResp'), TYPE
	)
IF @xmlText IS NULL
	SET @xmlText = '<ExchangeVirtualAgent_IndexCopyConfResp/>'
SELECT @xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'IndexCopyGetConfig')
	delete from GxQscripts where name = 'IndexCopyGetConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IndexCopyGetConfig')
	delete from GXDBVersions where aliasname = 'IndexCopyGetConfig'
GO

insert into GXDBVersions values(2, 'IndexCopyGetConfig',  'v1.1.2.15.8.1', 'IndexCopyGetConfig', 'v1.1.2.15.8.1')
GO

