

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/IdxMultiClientBrowse.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc. All rights reserved.
-- -----------------------------------------------------------------------------------------------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/IdxMultiClientBrowse.sp,v $ $Id: IdxMultiClientBrowse.sp,v 1.1.2.2 2019/06/26 23:25:03 sbhukar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='IdxMultiClientBrowse')
BEGIN
	print '>>> Drop Stored Procedure: IdxMultiClientBrowse <<<'
	drop procedure IdxMultiClientBrowse
END
IF EXISTS (select * from GxQscripts where name='IdxMultiClientBrowse')
	delete from GxQscripts where name = 'IdxMultiClientBrowse'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IdxMultiClientBrowse')
	delete from GXDBVersions where aliasname = 'IdxMultiClientBrowse'
GO
print '... Creating Procedure: IdxMultiClientBrowse'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure IdxMultiClientBrowse
  @i_inXML XML
AS
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE  @o_xmlMsg    XML
DECLARE @userName varchar(128)
DECLARE @userID INT
EXEC [EntityNameToIdConverterNew] @i_inXML OUTPUT
SET @userName = (SELECT @i_inXML.value('(/databrowse_BrowseRequest/@userName)[1]', 'nvarchar(256)'))
select @userID=id from UMUsers where login=@userName
IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
    DROP TABLE #getIdaObjects
IF OBJECT_ID('dbo.tempdb.#tempOutputTable') IS NOT NULL
	DROP TABLE #tempEntities
CREATE TABLE #getIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
CREATE TABLE #tempEntities (clientId INT, apptypeId INT, instanceId INT, backupsetId INT, subclientID INT, isScIndex INT, isMainDb INT, maClientId INT)
--EXEC sec_getIdaObjectsForUser @userID,7,0,1,'#getIdaObjects'
EXEC sec_getIdaObjectsForUser @userID,7,0,1,'#getIdaObjects'
--select * from #getIdaObjects
insert into #tempEntities
select DISTINCT
	available.clientId,
	available.apptypeId,
	available.instanceID,
	available.backupsetId,
	available.subclientID,
	dbo.isSubClientIndexEnabled(available.backupsetId),
	0,
	0
FROM @i_inXML.nodes(N'databrowse_BrowseRequest/entityList/entity') AS T(N)
cross apply #getIdaObjects available
where
	available.clientId=N.value(N'@clientId', N'INT')
	AND (available.appTypeId=N.value(N'@applicationId', N'INT') OR ISNULL(N.value(N'@applicationId', N'INT'),0)<=0 AND available.apptypeId in (29, 33, 106))
	AND (available.backupsetId=N.value(N'@backupsetId', N'INT') OR ISNULL(N.value(N'@backupsetId', N'INT'),0)<=0)
	AND (available.subclientID=N.value(N'@subclientId', N'INT') OR ISNULL(N.value(N'@subclientId', N'INT'),0)<=0)
	AND exists (select 1 from archfile af where af.appId=available.subclientID AND af.name='IdxLogs_V1' AND af.cs_afname=CHECKSUM(N'IdxLogs_V1'))
insert into #tempEntities
select
	available.clientId,
	available.apptypeId,
	available.instanceID,
	available.backupsetId,
	available.subclientID,
	dbo.isSubClientIndexEnabled(available.backupsetId) AS isScIndex,
	0,
	0
FROM @i_inXML.nodes(N'databrowse_BrowseRequest/entity') AS T(N)
cross apply #getIdaObjects available
where
	available.clientId=N.value(N'@clientId', N'INT')
	AND (available.appTypeId=N.value(N'@applicationId', N'INT') OR ISNULL(N.value(N'@applicationId', N'INT'),0)<=0 AND available.apptypeId in (29, 33, 106))
	AND (available.backupsetId=N.value(N'@backupsetId', N'INT') OR ISNULL(N.value(N'@backupsetId', N'INT'),0)<=0)
	AND (available.subclientID=N.value(N'@subclientId', N'INT') OR ISNULL(N.value(N'@subclientId', N'INT'),0)<=0)
	AND exists (select 1 from archfile af where af.appId=available.subclientID AND af.name='IdxLogs_V1' AND af.cs_afname=CHECKSUM(N'IdxLogs_V1'))
	AND not exists (select 1 from #tempEntities present where present.subclientID=available.subclientID)
--select * from #tempEntities
update #tempEntities set maClientId=(
	select ai.currentIdxServer from App_IndexDBInfo ai
	join APP_Application app on app.id=subclientID
	where ai.backupSetId=#tempEntities.backupsetId
	and (#tempEntities.isScIndex=0 OR isScIndex=1 AND app.guid=ai.dbName)
	and ai.idxDbEngineType = 1
)
--select * from #tempEntities
DECLARE @mainMaId INT=0
select TOP 1 @mainMaId=maClientId from #tempEntities group by maClientId order by count(maClientId) desc
DECLARE  @t_xmlMsg    XML =
				(
					SELECT
						'#SubClientIndex="1";' as '@extendedOptions',
						(select cl1.net_hostname + '*' + cl1.name + '*' + CAST(cl1.cvdPort AS nvarchar(10)) from app_client cl1 where cl1.id=@mainMaId) as '@maMangled',
						(select cl1.net_hostname + '*' + cl1.name + '*' + CAST(cl1.cvdPort AS nvarchar(10)) from app_client cl1 where cl1.id=2) as '@connectBackHost',
						1 as '@multiClientRequest',
					(
						-- backupSet-level indexes
						SELECT
							ai.backupSetGUID as '@backupsetGuid',
							ai.idxDbEngineType as '@idxDbEngineType',
							cl.net_hostname + '*' + cl.name + '*' + CAST(cl.cvdPort AS nvarchar(10)) as '@maMangledName',
							ai.type as '@idxAppType',
							(
							select
								ai.dbName          AS '@DbIdentifer'
							FOR XML PATH('dbInfo'), TYPE
							)
						FROM #tempEntities e
						join App_IndexDBInfo ai ON ai.backupSetId=e.backupsetId
						join app_client cl on cl.id=e.maClientId
						join app_application app on app.id=e.subclientID
						where
							e.isMainDb=0
							and (isScIndex=0 or app.GUID=ai.dbName)
						FOR XML PATH('indexdbList'), TYPE
					),
					(
						SELECT top 1
							ai.backupSetGUID as '@backupsetGuid',
							ai.idxDbEngineType as '@idxDbEngineType',
							cl.net_hostname + '*' + cl.name + '*' + CAST(cl.cvdPort AS nvarchar(10)) as '@maMangledName',
							ai.type as '@idxAppType',
							(
							select
								e1.clientId         AS '@clientId',
								e1.apptypeId        AS '@apptypeId',
								e1.instanceId       AS '@instanceId',
								e1.backupsetId      AS '@backupsetId',
								e1.subclientID      AS '@subclientID',
								app1.GUID			AS '@appGuid',
								bs1.GUID			AS '@backupsetGUID',
								0					AS '@latestIdxAfCtime',
								0					AS '@minIdxAfCtime',
								e1.isScIndex		AS '@isSubClientIndex',
								app1.origCCId		AS '@commCellId',
								cl1.name				AS '@clientName'
							FROM #tempEntities e1
							join app_application app1 on app1.id=e1.subclientID
							join APP_BackupSetName bs1 on bs1.id=e1.backupsetId
							join app_client cl1 on cl1.id=e1.clientid
							FOR XML PATH('subclientInfos'), TYPE
							),
							(
							select
								ai.dbName          AS '@DbIdentifer'
							FOR XML PATH('dbInfo'), TYPE
							)
						FROM #tempEntities e
						join App_IndexDBInfo ai ON ai.backupSetId=e.backupsetId
						join app_client cl on cl.id=e.maClientId
						join app_application app on app.id=e.subclientID
						where
							e.maClientId = @mainMaId
							and (isScIndex=0 or app.GUID=ai.dbName)
						FOR XML PATH('mainIndexDb'), TYPE
					)
					FOR XML PATH('indexingInfo')
				)
declare @mainIdxAppType INT = @t_xmlMsg.value('(/indexingInfo/mainIndexDb/@idxAppType)[1]', 'int' )
SET @t_xmlMsg.modify('insert attribute idxAppType {sql:variable("@mainIdxAppType")} into (/indexingInfo)[1]');
SET @o_xmlMsg = @i_inXML
DECLARE @t_xmlMEB XML = '<multiEntityBrowseFlags mergeMultiClientBrowseData="1"/>'
SET @o_xmlMsg.modify('delete /databrowse_BrowseRequest/multiEntityBrowseFlags');
SET @o_xmlMsg.modify('insert sql:variable("@t_xmlMEB") into (/databrowse_BrowseRequest)[1]');
SET @o_xmlMsg.modify('delete /databrowse_BrowseRequest/applicationInfo');
SET @o_xmlMsg.modify('insert <applicationInfo/> into (/databrowse_BrowseRequest)[1]');
SET @o_xmlMsg.modify('insert sql:variable("@t_xmlMsg") into (/databrowse_BrowseRequest/applicationInfo)[1]');
SET @o_xmlMsg.modify('delete (/databrowse_BrowseRequest/advOptions/@skipUptodateCheck)[1]');
SET @o_xmlMsg.modify('insert attribute skipUptodateCheck {"1"} into (/databrowse_BrowseRequest/advOptions)[1]');
SET @o_xmlMsg.modify('delete (/databrowse_BrowseRequest/advOptions/@copyPrecedence)[1]');
SET @o_xmlMsg.modify('insert attribute copyPrecedence {"0"} into (/databrowse_BrowseRequest/advOptions)[1]');
SELECT @o_xmlMsg
END
GO

IF EXISTS (select * from GxQscripts where name = 'IdxMultiClientBrowse')
	delete from GxQscripts where name = 'IdxMultiClientBrowse'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IdxMultiClientBrowse')
	delete from GXDBVersions where aliasname = 'IdxMultiClientBrowse'
GO

insert into GXDBVersions values(2, 'IdxMultiClientBrowse',  '00010001000200020000', 'IdxMultiClientBrowse', '00010001000200020000')
GO

