

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/IdaGetAssociatedDBInstances.sp] ---------- 

-- ----------------------------------------------------------------------
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/IdaGetAssociatedDBInstances.sp,v $ $Id: IdaGetAssociatedDBInstances.sp,v 1.1.2.3 2020/02/24 12:59:05 stelagamsetti Exp $";
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='IdaGetAssociatedDBInstances')
BEGIN
	print '>>> Drop Stored Procedure: IdaGetAssociatedDBInstances <<<'
	drop procedure IdaGetAssociatedDBInstances
END
IF EXISTS (select * from GxQscripts where name='IdaGetAssociatedDBInstances')
	delete from GxQscripts where name = 'IdaGetAssociatedDBInstances'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IdaGetAssociatedDBInstances')
	delete from GXDBVersions where aliasname = 'IdaGetAssociatedDBInstances'
GO
print '... Creating Procedure: IdaGetAssociatedDBInstances'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure IdaGetAssociatedDBInstances
  @inXML xml
AS
  DECLARE @outXML xml
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
IF object_id('tempdb.dbo.#targetInstances') is not null DROP TABLE #targetInstances
CREATE TABLE #targetInstances (instanceId INT)
	--Debug
	--SET @inXML = '<App_GetAssociatedDBInstanceListReq><agent applicationId="80" clientId="202" /></App_GetAssociatedDBInstanceListReq>'
	DECLARE @inClientId				INT
	DECLARE @inAppTypeId			INT
	SET @inClientId				= ISNULL (( SELECT ref.value('@clientId', 'INTEGER')FROM @inXMl.nodes('App_GetAssociatedDBInstanceListReq/agent') R(ref)), 0)
	SET @inAppTypeId			= ISNULL (( SELECT ref.value('@applicationId', 'INTEGER')FROM @inXMl.nodes('App_GetAssociatedDBInstanceListReq/agent') R(ref)), 80)
IF @inAppTypeId = 80
	BEGIN
		INSERT INTO #targetInstances
		SELECT	DISTINCT A2.instance
		FROM	APP_OracleRacInstance O
			INNER JOIN APP_Application A1
ON A1.instance = O.instaceId AND A1.appTypeId = 80
			INNER JOIN APP_Application A2
ON A1.clientId = A2.clientId AND A2.appTypeId = 80
		WHERE	O.clientId = @inClientID
		SET @outXML =	(
			SELECT
					(SELECT A.clientId AS '@clientId',
							A.instance AS '@instanceId',
							I.name	AS '@instanceName'
					FROM	APP_Application A, APP_InstanceName I
					WHERE	A.instance = I.id AND A.instance = T.instanceId AND ((A.subclientStatus & 8) <> 0)
					FOR XML PATH ('instance'), TYPE),
					(SELECT
						(SELECT
								O.id AS '@racDbInstanceId',
								O.name AS '@instanceOracleSID',
								O.clientId AS 'instancePhysicalClient/@clientId'
						FROM	APP_OracleRacInstance O
						WHERE	O.instaceId = T.instanceId
						FOR XML PATH('racDBInstance'), TYPE)
					FOR XML PATH('oracleRACInstance'), TYPE)
			FROM	#targetInstances T
			FOR XML PATH('dbInstances'), ROOT('App_GetAssociatedDBInstanceListResp')
		)
	END
ELSE IF @inAppTypeID = 135
	BEGIN
		INSERT INTO #targetInstances
		SELECT	DISTINCT componentNameId
		FROM	APP_InstanceProp IP
			CROSS APPLY dbo.SplitString(IP.attrVal, '+') S
		WHERE	IP.attrName = 'Database Clients'
			AND IP.modified = 0
			AND	S.Data = @inClientID
		SET @outXML =	(
			SELECT
					(SELECT DISTINCT A.clientId AS '@clientId',
							A.instance AS '@instanceId',
							I.name	AS '@instanceName'
					FROM	APP_Application A, APP_InstanceName I
					WHERE	A.instance = I.id AND A.instance = T.instanceId AND ((A.subclientStatus & 8) <> 0)
					FOR XML PATH ('instance'), TYPE),
					(SELECT
							S.Data AS 'DBInstances/@clientId'
					FROM	APP_InstanceProp IP
						CROSS APPLY dbo.SplitString(IP.attrVal, '+') S
					WHERE	IP.componentNameId = T.instanceId
						AND IP.attrName = 'Database Clients'
						AND IP.modified = 0
					FOR XML PATH('saphanaInstance'), TYPE)
			FROM	#targetInstances T
			FOR XML PATH('dbInstances'), ROOT('App_GetAssociatedDBInstanceListResp')
		)
	END
	IF @outXML IS NULL
		SET @outXML = '<App_GetAssociatedDBInstanceListResp/>'
	SELECT @outXML
END TRY
BEGIN CATCH
	IF (ERROR_SEVERITY() <> 16 OR ERROR_STATE() <> 1)
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- return error response
	SET @outXML = (SELECT ERROR_STATE() AS '@errorCode', ERROR_MESSAGE() AS '@errorString' FOR XML PATH('App_GenericEntityResponse'), TYPE)
	SELECT @outXML;
END CATCH
IF object_id('tempdb.dbo.#targetInstances') is not null DROP TABLE #targetInstances
GO

IF EXISTS (select * from GxQscripts where name = 'IdaGetAssociatedDBInstances')
	delete from GxQscripts where name = 'IdaGetAssociatedDBInstances'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IdaGetAssociatedDBInstances')
	delete from GXDBVersions where aliasname = 'IdaGetAssociatedDBInstances'
GO

insert into GXDBVersions values(2, 'IdaGetAssociatedDBInstances',  '00010001000200030000', 'IdaGetAssociatedDBInstances', '00010001000200030000')
GO

