

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/IdaDBInfoUpdate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='IdaDBInfoUpdate')
BEGIN
	print '>>> Drop Stored Procedure: IdaDBInfoUpdate <<<'
	drop procedure IdaDBInfoUpdate
END
IF EXISTS (select * from GxQscripts where name='IdaDBInfoUpdate')
	delete from GxQscripts where name = 'IdaDBInfoUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IdaDBInfoUpdate')
	delete from GXDBVersions where aliasname = 'IdaDBInfoUpdate'
GO
print '... Creating Procedure: IdaDBInfoUpdate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure IdaDBInfoUpdate
  @i_xml XML
AS
  DECLARE @o_xml XML
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	DECLARE @timeNow INT = dbo.GetUnixTime(GETUTCDATE())
	IF OBJECT_ID('tempdb.dbo.#dbInfoTbl') IS NOT NULL
		DROP TABLE #dbInfoTbl
	CREATE TABLE #dbInfoTbl
	(	instanceId INT NOT NULL,
		databaseId INT,
		subclientID INT,
		bkpJobId INT,
		databaseName NVARCHAR(512),
		databaseSize BIGINT,
		lastBackupTime INT
	)
	DECLARE @instanceId INT
	DECLARE @appId INT
	DECLARE @bkpJobId INT
	SELECT @instanceId = T.cc.value('@instanceId', 'INT') FROM	@i_xml.nodes('/Ida_DBInfoUpdate/instance') T(cc)
	SELECT @bkpJobId = T.cc.value('@bkpJobId', 'INT') FROM	@i_xml.nodes('/Ida_DBInfoUpdate') T(cc)
	SELECT @appId = applicationId FROM JMBkpJobInfo WHERE jobId = @bkpJobId
	INSERT INTO #dbInfoTbl(instanceId, subclientID, bkpJobId, databaseId, databaseName, databaseSize, lastBackupTime)
	SELECT	@instanceId,
			@appId,
			@bkpJobId,
			ISNULL(T.cc.value('@dbId', 'INT'), 0),
			ISNULL(T.cc.value('@dbName', 'NVARCHAR(512)'), ''),
			ISNULL(T.cc.value('@dbSize', 'BIGINT'), 0),
			ISNULL(T.cc.value('@backupTime', 'INT'), @timeNow)
	FROM @i_xml.nodes('/Ida_DBInfoUpdate/dbInfo') as T(cc)
	MERGE	IdaDBExtendedProp T
	USING	#dbInfoTbl S
		ON	T.instanceID = S.instanceId AND T.databaseID = S.databaseId AND T.databaseName = S.databaseName
	WHEN MATCHED
	THEN	UPDATE
			SET	T.subclientID = S.subclientID,
				T.latestBackupID = S.bkpJobId,
				T.lastBackupTime = S.lastBackupTime,
				T.databaseSize = S.databaseSize,
				T.refTime = @timeNow
	WHEN NOT MATCHED BY TARGET
	THEN	INSERT(instanceID, databaseID, subclientID, latestBackupID, databaseName, lastBackupTime, lastSyncTime, databaseSize, refTime, readinessStatus, notReadyReason, flags)
			VALUES(@instanceId, S.databaseId, @appId, @bkpJobId, S.databaseName, S.lastBackupTime, 0, S.databaseSize, @timeNow, 0, 0, 0)
	;
	SET  @o_xml = (SELECT 0 AS '@errorCode', N'' AS '@errorMessage'
			FOR XML PATH ('Ida_GenericResp'), type)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET  @o_xml = (SELECT ERROR_NUMBER() AS '@errorCode', ERROR_MESSAGE() AS '@errorMessage'
			FOR XML PATH ('Ida_GenericResp'), type)
END CATCH
IF OBJECT_ID('tempdb.dbo.#dbInfoTbl') IS NOT NULL
		DROP TABLE #dbInfoTbl
SELECT @o_xml;
GO

IF EXISTS (select * from GxQscripts where name = 'IdaDBInfoUpdate')
	delete from GxQscripts where name = 'IdaDBInfoUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IdaDBInfoUpdate')
	delete from GXDBVersions where aliasname = 'IdaDBInfoUpdate'
GO

insert into GXDBVersions values(2, 'IdaDBInfoUpdate',  '00000000000000000000', 'IdaDBInfoUpdate', '00000000000000000000')
GO

