

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/IdaAutoCreateOraArchiveLogSC.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2014  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--		  Procedure Name :IdaAutoCreateOraArchiveLogSC
--		  Creates ArchiveLog subclients for Oracle and OracleRAC if not exist
--
-- ----------------------------------------------------------------------*/
 SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='IdaAutoCreateOraArchiveLogSC')
BEGIN
	print '>>> Drop Stored Procedure: IdaAutoCreateOraArchiveLogSC <<<'
	drop procedure IdaAutoCreateOraArchiveLogSC
END
IF EXISTS (select * from GxQscripts where name='IdaAutoCreateOraArchiveLogSC')
	delete from GxQscripts where name = 'IdaAutoCreateOraArchiveLogSC'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IdaAutoCreateOraArchiveLogSC')
	delete from GXDBVersions where aliasname = 'IdaAutoCreateOraArchiveLogSC'
GO
print '... Creating Procedure: IdaAutoCreateOraArchiveLogSC'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure IdaAutoCreateOraArchiveLogSC
  @instanceId INT
AS
  DECLARE @o_errorCode INT
  DECLARE @o_errorMsg NVARCHAR(1024)
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET @o_errorCode = 0
	SET @o_errorMsg = N''
	DECLARE @subclientId		INT = 0
	DECLARE @clientId			INT = 0
	DECLARE	@appTypeId			INT = 0
	DECLARE @backupsetId		INT = 0
	DECLARE @defaultScId		INT = 0
	DECLARE	@dataArchGrpId		INT = 0
	DECLARE @logArchGrpId		INT = 0
	DECLARE @releaseId			INT = 0
	DECLARE @timeNow INT = dbo.GetUnixTime(GETUTCDATE())
	SELECT	@clientId = clientId, @appTypeId = appTypeId, @backupsetId = backupSet, @defaultScId = id, @dataArchGrpId = dataArchGrpID, @logArchGrpId = logArchGrpID
	FROM	APP_Application A
	WHERE	A.instance = @instanceId
		AND	(A.subclientStatus) & 8 <> 0
	IF @clientId = 0 OR @appTypeId = 0 OR @backupsetId = 0 OR @defaultScId = 0 OR @dataArchGrpId = 0 OR @logArchGrpId = 0
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorMsg = 'Invalid instanceId. Client or Agent type not found'
		GOTO PROC_EXIT
	END
IF @appTypeId NOT IN (22, 80)
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorMsg = 'AppType ' + CAST(@appTypeId AS VARCHAR(8)) + ' is not supported for automatic ArchiveLog subclient creation.'
		GOTO PROC_EXIT
	END
	IF EXISTS (SELECT 1 FROM APP_Application WHERE instance = @instanceId AND ((subclientStatus & 262144) <> 0 OR subclientName = 'ArchiveLog') AND (subclientStatus & 4) = 0)
	BEGIN
		SET @o_errorCode = 0
		SET @o_errorMsg = 'ArchiveLog subclient already exists, nothing to do.'
		GOTO PROC_EXIT
	END
	SELECT @releaseId = releaseId FROM APP_Client WHERE id = @clientId
	IF (@releaseId < 16) --Should be at v11 or above
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorMsg = 'Creating ArchiveLog subclient is not supported for v10 or below clients'
		GOTO PROC_EXIT
	END
	--Now create ArchiveLog subclient
	INSERT INTO APP_Application (clientId, appTypeId, instance, backupSet, appNumber, dataArchGrpId, logArchGrpId, refTime, modified, subclientName, subclientStatus, ccpId, ccpTime, origCCId, GUID)
	VALUES (@clientId, @appTypeId, @instanceId, @backupsetId, 0, @dataArchGrpId, @logArchGrpId, @timeNow, @timeNow, 'ArchiveLog', 262144, 0, 0, 0, NEWID())
	-- Get new subclient id
	SET @subclientId = SCOPE_IDENTITY()
	IF (ISNULL(@subclientId, 0) = 0)
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorMsg = 'Unable to create ArchiveLog subclient'
		GOTO PROC_EXIT
	END
	--Now insert default properties into APP_SubclientProp table
	INSERT INTO	APP_SubclientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
	VALUES (@subclientId, 'Single Instancing Option', 7, '1', @timeNow, 0, 0)
	INSERT INTO	APP_SubclientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
	VALUES (@subclientId, 'Encrypt: encryption', 10, '2', @timeNow, 0, 0)
	INSERT INTO	APP_SubclientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
	VALUES (@subclientId, 'Oracle Backup Mode', 7, '1', @timeNow, 0, 0)
	INSERT INTO	APP_SubclientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
	VALUES (@subclientId, 'Backup Archive Log', 2, '1', @timeNow, 0, 0)
	INSERT INTO	APP_SubclientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
	VALUES (@subclientId, 'Archive Log Deleting', 2, '1', @timeNow, 0, 0)
	INSERT INTO	APP_SubclientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
	VALUES (@subclientId, 'Oracle LOS disable Switch', 2, '1', @timeNow, 0, 0)
	INSERT INTO	APP_SubclientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
	VALUES (@subclientId, 'Oracle Data FPS', 7, '8', @timeNow, 0, 0)
	INSERT INTO	APP_SubclientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
	VALUES (@subclientId, 'Arch per bfs', 8, '32', @timeNow, 0, 0)
	INSERT INTO	APP_SubclientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
	VALUES (@subclientId, 'last log SP', 10, '1', @timeNow, 0, 0)
	INSERT INTO	APP_SubclientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
	VALUES (@subclientId, 'last data SP', 10, '1', @timeNow, 0, 0)
IF (@appTypeId = 22)
	BEGIN
		INSERT INTO	APP_SubclientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
		VALUES (@subclientId, 'Oracle Log backup streams', 7, '1', @timeNow, 0, 0)
	END
ELSE IF (@appTypeId = 80)
	BEGIN
		INSERT INTO APP_SubclientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
		SELECT	DISTINCT @subclientId, attrName, attrType, attrVal, @timeNow, 0, ccpId
		FROM	APP_SubclientProp
		WHERE	componentNameId = @defaultScId
			AND	attrName IN ('Oracle RAC Data Properties', 'Oracle RAC Log Properties')
			AND modified = 0
	END
PROC_EXIT:
SELECT @o_errorCode, @o_errorMsg
END
GO

IF EXISTS (select * from GxQscripts where name = 'IdaAutoCreateOraArchiveLogSC')
	delete from GxQscripts where name = 'IdaAutoCreateOraArchiveLogSC'
GO

IF EXISTS (select * from GXDBVersions where aliasname='IdaAutoCreateOraArchiveLogSC')
	delete from GXDBVersions where aliasname = 'IdaAutoCreateOraArchiveLogSC'
GO

insert into GXDBVersions values(2, 'IdaAutoCreateOraArchiveLogSC',  '00000000000000000000', 'IdaAutoCreateOraArchiveLogSC', '00000000000000000000')
GO

