

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/HedVigDatastoresSetInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/HedVigDatastoresSetInfo.sp,v $ $Id: HedVigDatastoresSetInfo.sp,v 1.1.2.2 2020/09/29 19:50:22 rsn Exp $";
--  +---------------------------------------------------+
--  |           PROCEDURE : "HedVigDatastoresSetInfo"         |
--  +---------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='HedVigDatastoresSetInfo')
BEGIN
	print '>>> Drop Stored Procedure: HedVigDatastoresSetInfo <<<'
	drop procedure HedVigDatastoresSetInfo
END
IF EXISTS (select * from GxQscripts where name='HedVigDatastoresSetInfo')
	delete from GxQscripts where name = 'HedVigDatastoresSetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='HedVigDatastoresSetInfo')
	delete from GXDBVersions where aliasname = 'HedVigDatastoresSetInfo'
GO
print '... Creating Procedure: HedVigDatastoresSetInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure HedVigDatastoresSetInfo
  @i_xmlString XML
AS
  DECLARE @o_xmlstring XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = datediff(second, '01/01/1970', GETDATE())
	DECLARE	@export				NVARCHAR
	DECLARE @DatastoreId INT = 0
	IF object_id('tempdb.dbo.#hedvigdatastoretempTable') IS NOT null DROP TABLE #hedvigdatastoretempTable
CREATE TABLE #hedvigdatastoretempTable	(
	Id                      INT NOT NULL IDENTITY    PRIMARY KEY,
	DataStoreName           NVARCHAR(255),
	VMHost                  NVARCHAR(255),
	DataStoreMountPath      NVARCHAR(512),
	HypervisorName          NVARCHAR(255),
	HypervisorId            INT,
	HedVigProxy             NVARCHAR(255),
	VDiskName               NVARCHAR(255),
	HedvigCluster           NVARCHAR(255),
	CreateDate				INT,
	CreatorId               INT,
	status                  INT )
	-- READ THE XML
	DECLARE @VDiskName		NVARCHAR(255) =  ( SELECT ref.value('@vdiskName', 'NVARCHAR(255)')
													FROM @i_xmlString.nodes ('Ida_VMOpReq/datastoreInfo') R(ref))
	DECLARE @VMHost			NVARCHAR(255) =  ( SELECT ref.value('@targetHost', 'NVARCHAR(255)')
													FROM @i_xmlString.nodes ('Ida_VMOpReq/datastoreInfo') R(ref))
	DECLARE @HypervisorName	NVARCHAR(255) = ISNULL (( SELECT ref.value('@clientName', 'NVARCHAR(255)')
													FROM @i_xmlString.nodes ('Ida_VMOpReq/vmInfo/vmLocation/virtualizationClient') R(ref)), '')
	DECLARE @HypervisorId    INT			= ( SELECT ref.value('@clientId', 'INT')
													FROM @i_xmlString.nodes ('Ida_VMOpReq/vmInfo/vmLocation/virtualizationClient') R(ref))
	DECLARE @HedVigProxy	NVARCHAR(255) =  ( SELECT ref.value('@val', 'NVARCHAR(255)')
													FROM @i_xmlString.nodes ('Ida_VMOpReq/datastoreInfo/HedvigTargets[1]') R(ref))
	DECLARE @HedvigCluster	NVARCHAR(255) =  ( SELECT ref.value('@HedvigClusterNode', 'NVARCHAR(255)')
													FROM @i_xmlString.nodes ('Ida_VMOpReq/datastoreInfo') R(ref))
	DECLARE @CreatorId    INT			= ISNULL (( SELECT ref.value('@userId', 'INT')
													FROM @i_xmlString.nodes ('Ida_VMOpReq/vmInfo/creator') R(ref)), 0)
	DECLARE @StorageId    INT			= ( SELECT ref.value('@distributedStorageId', 'INT')
													FROM @i_xmlString.nodes ('Ida_VMOpReq/datastoreInfo/distributedStorage') R(ref))
	DECLARE @DataStoreMountPath	NVARCHAR(255) =  ( SELECT ref.value('@datastoreMountPath', 'NVARCHAR(255)')
													FROM @i_xmlString.nodes ('Ida_VMOpReq/datastoreInfo') R(ref))
	INSERT INTO #hedvigdatastoretempTable (DataStoreName, VMHost, DataStoreMountPath, HypervisorName, HypervisorId, HedVigProxy, VDiskName, HedvigCluster,
											CreateDate, CreatorId, status) VALUES
	(@VDiskName, @VMHost, @DataStoreMountPath, @HypervisorName, @HypervisorId, @HedVigProxy,@VDiskName, @HedvigCluster, @nowTime,@CreatorId, 1)
BEGIN TRAN
	BEGIN
			MERGE  HedVigDataStores as Dest
				USING #hedvigdatastoretempTable as Src
			ON  Dest.DataStoreMountPath = Src.DataStoreMountPath
				AND Dest.VMHost = Src.VMHost
			WHEN MATCHED
			THEN UPDATE
				SET Dest.HedVigProxy = Src.HedVigProxy,
					Dest.HedvigCluster = Src.HedvigCluster,
					Dest.CreateDate = @nowTime,
					Dest.status = 1,
				   @DatastoreId = Dest.Id
			WHEN NOT MATCHED THEN
					INSERT (DataStoreName, VMHost, DataStoreMountPath, HypervisorName, HypervisorId, HedVigProxy, VDiskName, HedvigCluster,
												CreateDate, CreatorId, status) VALUES
				(@VDiskName, @VMHost, @DataStoreMountPath, @HypervisorName, @HypervisorId, @HedVigProxy,@VDiskName, @HedvigCluster, @nowTime,@CreatorId, 1);
				SET @DatastoreId = SCOPE_IDENTITY()
				SET @errorCode = @@ERROR
	END
	BEGIN
		DECLARE @compId INT;
		DECLARE @strVal NVARCHAR(MAX);
		IF(@DatastoreId = 0)
			SET @DatastoreId = (SELECT Id FROM HedVigDatastores WHERE VMHost = @VMHost AND VDiskName = @VDiskName)
        SELECT @strVal= attrVal, @compId = componentNameId FROM HedVigDatastoreProp
            WHERE attrName = 'Distributed Storage ID'
            AND componentNameId = @DatastoreId
            AND modified =0
        IF ( @compId IS NOT NULL AND @strVal != @StorageId)
        BEGIN
               UPDATE HedVigDatastoreProp
                  SET  attrVal = @StorageId
               WHERE id = @compId
               AND attrName = 'Distributed Storage ID'
        END
        ELSE IF ( @compId IS NULL )
        BEGIN
                INSERT INTO HedVigDatastoreProp
                VALUES ( @DatastoreId, 'Distributed Storage ID', 1, @StorageId, dbo.GetUnixTime(getutcdate()), 0)
        END
		SET @errorCode = @@ERROR
    END
ERROR:
IF @errorCode <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
SET @o_xmlstring =
(
	SELECT
		(SELECT
			@DatastoreId AS 'dataStoreId'
			FOR XML PATH('datastoreInfo'), TYPE
		),
		(SELECT @errorCode '@errorCode',
				@errorString '@errorMessage'
		FOR XML PATH ('resp'), TYPE
		)
	FOR XML PATH(''), ROOT('Ida_VMOpResp')
)
SELECT @o_xmlstring
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'HedVigDatastoresSetInfo')
	delete from GxQscripts where name = 'HedVigDatastoresSetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='HedVigDatastoresSetInfo')
	delete from GXDBVersions where aliasname = 'HedVigDatastoresSetInfo'
GO

insert into GXDBVersions values(2, 'HedVigDatastoresSetInfo',  '00010001000200020000', 'HedVigDatastoresSetInfo', '00010001000200020000')
GO

