

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GrantRightsToMA.sp] ---------- 

--		ALLOW COMMENTS BELOW HERE!
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GrantRightsToMA.sp,v $ $Id: GrantRightsToMA.sp,v 1.6.60.5 2020/12/21 08:43:07 jswaminathan Exp $";
-- =============================================
-- Author:		Ashish Gupta
-- Creation date: 01/07/2010
-- Description:	Grants all user groups of specified user rights to entity
-- =============================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='GrantRightsToMA')
BEGIN
	print '>>> Drop Stored Procedure: GrantRightsToMA <<<'
	drop procedure GrantRightsToMA
END
IF EXISTS (select * from GxQscripts where name='GrantRightsToMA')
	delete from GxQscripts where name = 'GrantRightsToMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GrantRightsToMA')
	delete from GXDBVersions where aliasname = 'GrantRightsToMA'
GO
print '... Creating Procedure: GrantRightsToMA'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure GrantRightsToMA
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INTEGER,
  @i_entityId INTEGER,
  @i_authCode VARCHAR(32) = ''
AS
SET NOCOUNT ON
  DECLARE @errorCode INTEGER
  DECLARE @errorMsg VARCHAR(64)
DECLARE @mmAutoGrantParam		INTEGER
SET @errorMsg = 'Success'
SET @errorCode = 0
SET @mmAutoGrantParam = 0
BEGIN TRY
	SET @mmAutoGrantParam = ISNULL((SELECT value FROM MMConfigs WHERE name = 'MMCONFIG_AUTO_GRANT_RIGHTS'), 0)
	IF @mmAutoGrantParam = 1
	BEGIN
		IF NOT EXISTS (SELECT ClientId FROM MMHost WHERE ClientId=@i_entityId)
		BEGIN
			SET @errorCode = -1
			SET @errorMsg = 'Invalid entity ID passed.'
			GOTO ERROR_OUT
		END
		IF @i_userId <> 0 AND NOT EXISTS (SELECT name FROM UMUsers WHERE id=@i_userId)
		BEGIN
			SET @errorCode = -2
			SET @errorMsg = 'Invalid user ID passed.'
			GOTO ERROR_OUT
		END
		IF dbo.isNewSecurity() = 1
		  BEGIN
			 DECLARE @permissionsList NVARCHAR(MAX)
SET @permissionsList = CAST(10 AS NVARCHAR(10))
			 DECLARE @userId INT = @i_userId
			 DECLARE @tenantAdminUserGroupId	INT = 0
			 IF @userId IS NULL or @userId = 0
			 BEGIN
				/* Get tenant admin user of tenant */
				DECLARE @excludeUserFlags INT = dbo.sec_getExcludeFlagsForUser()
				DECLARE @tenantAdminUserId	INT = 0
				DECLARE @companyId	INT
				IF @i_authCode IS NOT NULL AND @i_authCode <> ''
				BEGIN
					/* Get company id based on authcode used for registration */
SELECT @companyId = componentNameId FROM APP_CompanyProp WITH (NOLOCK) WHERE attrname='Authorization Code' and attrVal=@i_authCode AND modified=0
				END
				ELSE
				BEGIN
					/* Both @i_userId and @i_authCode are not defined, that means MA package being added is not part of client registration. Get company id based on company of corresponding client entity.  */
SET @companyId = ISNULL((SELECT companyId FROM App_CompanyEntities WITH (NOLOCK) WHERE entityType = 3 AND entityId = @i_entityId), 0)
				END
				IF @companyId <> 0 AND @companyId IS NOT NULL
				BEGIN
					SET @tenantAdminUserId = (SELECT TOP 1 UU.id FROM UMUsers UU WITH (NOLOCK)
										INNER JOIN UMUserGroup UUG WITH (NOLOCK)
											ON UUG.userId=UU.id
										INNER JOIN UMGroups UG WITH (NOLOCK)
											ON UG.id=UUG.groupId
AND UG.groupFlags&0x10000<> 0
										AND UG.umdsProviderId=@companyId
										WHERE (UU.flags& @excludeUserFlags) = 0)
					SET @userId = @tenantAdminUserId
SET @tenantAdminUserGroupId = ISNULL((SELECT id FROM umgroups WITH (NOLOCK) WHERE umdsProviderId=@companyId AND groupFlags &  0x10000 = 0x10000),0)
				END
				ELSE
				BEGIN
					IF @i_authCode IS NOT NULL AND @i_authCode <> ''
					BEGIN
						SET @errorCode = -3
						SET @errorMsg = 'Invalid company id for given authcode'
					END
					GOTO ERROR_OUT
				END
			 END
EXEC sec_setCreatorForEntity @userId, 0, @permissionsList, @errorCode OUTPUT, @errorMsg OUTPUT, 11, @i_entityId, 0, 0, 0, 0, 0, 0, 0, 0, @tenantAdminUserGroupId
	      END
		ELSE
		  BEGIN
			INSERT UMGroupAssociation
SELECT groupId, 2048, @i_entityId, 0, 0, 0, 0, 0, 0, 0
			FROM UMUserGroup WHERE userId = @i_userId AND groupId NOT in (
SELECT groupId FROM UMGroupAssociation WHERE type1 = 2048 AND id1 = @i_entityId
			)
		  END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = -3
	SET @errorMsg = 'GrantRightsToMA: Unknown exception occured.'
END CATCH
ERROR_OUT:
	SELECT @errorCode AS 'ErrorCode', @errorMsg AS 'ErrorMsg'
GO

IF EXISTS (select * from GxQscripts where name = 'GrantRightsToMA')
	delete from GxQscripts where name = 'GrantRightsToMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GrantRightsToMA')
	delete from GXDBVersions where aliasname = 'GrantRightsToMA'
GO

insert into GXDBVersions values(2, 'GrantRightsToMA',  '00010006006000050000', 'GrantRightsToMA', '00010006006000050000')
GO

