

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetYearMonthOfDay.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetYearMonthOfDay.sp,v $ $Id: GetYearMonthOfDay.sp,v 1.3 2010/07/23 15:41:31 sbonilla Exp $";
-- =============================================
-- Author:		Anand Vibhor
-- Create date: 01/28/2006
-- Description:	Check if the new time fall in the weekly exception
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetYearMonthOfDay <<<'

IF EXISTS (select * from sysobjects where name='GetYearMonthOfDay')
	drop procedure GetYearMonthOfDay
IF EXISTS (select * from GxQscripts where name='GetYearMonthOfDay')
	delete from GxQscripts where name = 'GetYearMonthOfDay'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetYearMonthOfDay')
	delete from GXDBVersions where aliasname = 'GetYearMonthOfDay'
GO
print '... Creating Procedure: GetYearMonthOfDay'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetYearMonthOfDay
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @nextRunTime integer,
  @calId integer,
  @month integer OUTPUT,
  @year integer OUTPUT
AS
BEGIN
DECLARE @stdCalDay DATETIME
DECLARE @strStdCalDay varchar(128)
DECLARE @calendarId int
DECLARE @startDate DATETIME
DECLARE @startDateYear DATETIME
DECLARE @startDateQtr DATETIME
DECLARE @startDateHalfYr DATETIME
DECLARE @diffMonth integer
DECLARE @yearStartMonth integer
DECLARE @day integer
DECLARE @monthOffset integer
DECLARE @calType integer
SET @stdCalDay = dbo.GetDateTime(@nextRunTime)
SET @calendarId = @calId
set @year = DATEPART(year, @stdCalDay)
set @month = DATEPART(month, @stdCalDay)
set @day = DATEPART(day, @stdCalDay)
SET @strStdCalDay = (LTRIM(STR(@month)) + '/' + LTRIM(STR(@day)) + '/' + LTRIM(STR(@year)))
set @stdCalDay = CAST(@strStdCalDay AS datetime)
set @calType = (Select calType from APP_CustomCalendar where id = @calendarId)
if (@calType > 2)
  select @startDate = startDate , @year = [year], @month = [month] from   APP_CustomCalendarMonths where (startDate  <= @stdCalDay) AND (endDate >= @stdCalDay) and calendarId = @calendarId
else
 set @startDate =  dbo.getstartday( @year , @month , 0)
END
GO

IF EXISTS (select * from GxQscripts where name = 'GetYearMonthOfDay')
	delete from GxQscripts where name = 'GetYearMonthOfDay'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetYearMonthOfDay')
	delete from GXDBVersions where aliasname = 'GetYearMonthOfDay'
GO

insert into GXDBVersions values(2, 'GetYearMonthOfDay',  '00010003000000000000', 'GetYearMonthOfDay', '00010003000000000000')
GO

