

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetWinDCClientList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source, /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppAddContent.sp,v $ $Id, AppAddContent.sp,v 1.8 2006/01/13 05,03,02 xsui Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   GetWinDCClientList   - get list of windows dc clients that user has agent management capability on
SET QUOTED_IDENTIFIER ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetWinDCClientList <<<'

IF EXISTS (select * from sysobjects where name='GetWinDCClientList')
	drop procedure GetWinDCClientList
IF EXISTS (select * from GxQscripts where name='GetWinDCClientList')
	delete from GxQscripts where name = 'GetWinDCClientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetWinDCClientList')
	delete from GXDBVersions where aliasname = 'GetWinDCClientList'
GO
print '... Creating Procedure: GetWinDCClientList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetWinDCClientList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @userIdParam integer
AS
  DECLARE @r_clientId integer
  DECLARE @net_hostname nvarchar(1024)
  DECLARE @OsName nvarchar(1024)
  DECLARE @OsType integer
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
BEGIN
SET NOCOUNT ON
DECLARE	@clientTbl	TABLE (r_clientId INT)
IF object_id('tempdb.dbo.#GetWinDCClientList_userObjects') is not null
		DROP TABLE #GetWinDCClientList_userObjects
create table  #GetWinDCClientList_userObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
--CAPABILITY IS AGENT MANAGEMENT
EXEC sec_getUserObjects @userIdParam,2013 ,0,'#GetWinDCClientList_userObjects'
IF NOT EXISTS(select * from #GetWinDCClientList_userObjects where  capabilities & 2 = 2 and clientId= 0 and commcellid =2)
	INSERT INTO @clientTbl
	SELECT  DISTINCT Cli.Id
	FROM	APP_Client Cli join (select clientId as id from #GetWinDCClientList_userObjects where capabilities & 2 = 2 ) as tmp
	ON Cli.id = tmp.id join APP_ClientProp Prop
	ON Cli.id = Prop.ComponentnameId
	WHERE	Prop.attrname like 'Data Classification Installed on Client' and
			Prop.attrval = '1' and
			cli.status &2 <> 2 and cli.status &4 <> 4
ELSE
	INSERT INTO @clientTbl
	SELECT  DISTINCT Cli.Id
	FROM	APP_Client Cli join APP_ClientProp Prop
	ON Cli.id = Prop.ComponentnameId
	WHERE	Prop.attrname like 'Data Classification Installed on Client' and
			Prop.attrval = '1' and
			cli.status &2 <> 2 and cli.status &4 <> 4
SELECT	tmp.r_clientId,
		Cli.net_hostname,
--		OS.name,
		dbo.GetClientOSName(Cli.id, NULL),
		 (Case CProp.attrVAl
		 WHEN 1 THEN 1
		 WHEN 2 THEN 1
		 WHEN 3 THEN 1
         ELSE 0
         END)
	FROM APP_client Cli join @clientTbl tmp on tmp.r_clientId = Cli.id
--	join simOperatingSystem simsys on Cli.operatingsystemosid = simsys.id
--	join SIMOS OS on simsys.simosid = os.id
	JOIN APP_clientProp CProp ON Cli.id = CProp.componentNameId
	where  CProp.attrName like 'Binary Set ID' and CProp.modified = 0
IF object_id('tempdb.dbo.#GetWinDCClientList_userObjects') is not null
		DROP TABLE #GetWinDCClientList_userObjects
END

IF EXISTS (select * from GxQscripts where name = 'GetWinDCClientList')
	delete from GxQscripts where name = 'GetWinDCClientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetWinDCClientList')
	delete from GXDBVersions where aliasname = 'GetWinDCClientList'
GO

insert into GXDBVersions values(2, 'GetWinDCClientList',  '00000000000000000000', 'GetWinDCClientList', '00000000000000000000')
GO

