

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetVersionInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "GetVersionInfo "	|
--	|This Procedure is used to get browse path by given userId or mailboxguid.	|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetVersionInfo <<<'

IF EXISTS (select * from sysobjects where name='GetVersionInfo')
	drop procedure GetVersionInfo
IF EXISTS (select * from GxQscripts where name='GetVersionInfo')
	delete from GxQscripts where name = 'GetVersionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetVersionInfo')
	delete from GXDBVersions where aliasname = 'GetVersionInfo'
GO
print '... Creating Procedure: GetVersionInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetVersionInfo
  @CSId integer =0,
  @WSId integer = 0,
  @outputXml XML OUTPUT
--	The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
--************************************************************************
--	NEW ITEMS MAY ONLY BE ADDED AT THE END OF THE :OUT LIST!!!!!!!!!!!!!!
--	This is because some code (myIndicator) uses a hardcoded index # into
--	this list for certain items, so if an item is inserted before them,
--	the index # will reference the wrong item and we will get the wrong
--	data to send to the GUI!
--************************************************************************
AS
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	IF OBJECT_ID('tempdb.dbo.#VersionInfo') is not null drop table dbo.#VersionInfo
	create table #VersionInfo(clientId integer, release varchar(128), HighestSP integer,SpMinorVersion integer, releaseId integer );
	INSERT INTO dbo.#VersionInfo
	SELECT DISTINCT c.id, g.release,HighestSP,SpMinorVersion, c.releaseId
	FROM simInstalledPackages s
	INNER JOIN APP_CLIENT c ON s.ClientId = c.id
	INNER JOIN simAllGalaxyRel g ON g.id = c.releaseId
	WHERE ClientId = @CSId or (ClientId = @WSId  and simPackageID=252)
	IF OBJECT_ID('tempdb.dbo.#VersionValues') is not null drop table dbo.#VersionValues
	create table #VersionValues(clientId integer, Name varchar(128), Value integer);
	INSERT INTO #VersionValues
	SELECT clientId, convert(varchar(15), Name) [Name],  convert(varchar(15), Value) [Value]
	FROM
	(SELECT clientId, Convert(Varchar(50), release) As release, Convert(Varchar(50), HighestSP) As HighestSP,   Convert(Varchar(50), SpMinorVersion) As SpMinorVersion,  Convert(Varchar(50), releaseId) As releaseId
	 FROM #VersionInfo) p
	UNPIVOT
	(Value FOR Name IN
		([release], [HighestSP], [SpMinorVersion],[releaseId])
	) as unpvt
	DECLARE @outputXml1 xml = (SELECT [Name] AS '@name', Value as '@value' fROM #VersionValues  where clientId = @CSId FOR XML PATH('attributes'), Root('CSVersionInfo'))
	DECLARE @outputXml2 xml = (SELECT [Name] AS '@name', Value as '@value' fROM #VersionValues  where clientId = @WSId FOR XML PATH('attributes'), Root('WSVersionInfo'))
	SET @outputXml = (select @outputXml1,@outputXml2 FOR XML PATH(''),ROOT('App_GetVersionInfoResponse'))
	DROP table dbo.#VersionInfo
	DROP table dbo.#VersionValues
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'GetVersionInfo')
	delete from GxQscripts where name = 'GetVersionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetVersionInfo')
	delete from GXDBVersions where aliasname = 'GetVersionInfo'
GO

insert into GXDBVersions values(2, 'GetVersionInfo',  '00000000000000000000', 'GetVersionInfo', '00000000000000000000')
GO

