

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetVSIndexingVersionClientsForVendor.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: List all VSA clients for given hypervisor type with Indexing V1
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='GetVSIndexingVersionClientsForVendor')
BEGIN
	print '>>> Drop Stored Procedure: GetVSIndexingVersionClientsForVendor <<<'
	drop procedure GetVSIndexingVersionClientsForVendor
END
IF EXISTS (select * from GxQscripts where name='GetVSIndexingVersionClientsForVendor')
	delete from GxQscripts where name = 'GetVSIndexingVersionClientsForVendor'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetVSIndexingVersionClientsForVendor')
	delete from GXDBVersions where aliasname = 'GetVSIndexingVersionClientsForVendor'
GO
print '... Creating Procedure: GetVSIndexingVersionClientsForVendor'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure GetVSIndexingVersionClientsForVendor
  @vendor INT,
  @indexingVersion INT
AS
  DECLARE @clientCount integer 
SET NOCOUNT ON
DECLARE @dropTempTable INT = 0
IF OBJECT_ID('tempdb.dbo.#VSAInstancesForVendor') IS NULL
BEGIN
    -- temporary table does not exist in execution context. create one
    CREATE TABLE #VSAInstancesForVendor (instanceId INT PRIMARY KEY)
    -- and set flag that indicates that it should be dropped
    SET @dropTempTable = 1
END
	SET @clientCount = 0
	--Map vendor to instance type and get existing instances
	IF @vendor = 1
	BEGIN
		--VMW
		Insert into #VSAInstancesForVendor
		SELECT componentNameId FROM App_InstanceProp(NOLOCK) WHERE attrName = 'Virtual Server Instance Type' and attrVal in ('100','101') and modified = 0
	END
	ELSE IF @vendor = 4
	BEGIN
		--Amazon
		Insert into #VSAInstancesForVendor
		SELECT componentNameId FROM App_InstanceProp(NOLOCK) WHERE attrName = 'Virtual Server Instance Type' and attrVal in ('301') and modified = 0
	END
	ELSE IF @vendor = 3
	BEGIN
		--Xen
		Insert into #VSAInstancesForVendor
		SELECT componentNameId FROM App_InstanceProp(NOLOCK) WHERE attrName = 'Virtual Server Instance Type' and attrVal in ('201','202') and modified = 0
	END
	ELSE IF @vendor = 7
	BEGIN
		--Azure Resource Manager
		Insert into #VSAInstancesForVendor
		SELECT componentNameId FROM App_InstanceProp(NOLOCK) WHERE attrName = 'Virtual Server Instance Type' and attrVal in ('402') and modified = 0
	END
	ELSE IF @vendor = 17
	BEGIN
		--Azure Stack
		Insert into #VSAInstancesForVendor
		SELECT componentNameId FROM App_InstanceProp(NOLOCK) WHERE attrName = 'Virtual Server Instance Type' and attrVal in ('403') and modified = 0
	END
	ELSE
	BEGIN
		Insert into #VSAInstancesForVendor
		SELECT componentNameId FROM App_InstanceProp(NOLOCK) WHERE attrName = 'Virtual Server Instance Type' and modified = 0 and attrVal in
			('100','101','102','201','202','301','401','501','402','1201','601','701','1001','901','1101','801','103','1301','403','1401','1102','1501','1502')
	END
	IF @indexingVersion = 1
		BEGIN
			SELECT @clientCount =  Count(*)  FROM app_application(NOLOCK) app inner join #VSAInstancesForVendor Ins
			ON app.instance = INS.instanceId
			left outer join app_clientprop acpr
			on app.clientid = acpr.componentnameid and
			acpr.attrname = 'IndexingV2_VSA' and
			acpr.attrval = '1' and acpr.modified = 0
			WHERE appTypeId = 106 and
			(subclientstatus = 0 or (subclientStatus & 0x8) = 0x8) and
			acpr.id is null
		END
	ELSE
		BEGIN
			SELECT @clientCount =  Count(*)  FROM app_application(NOLOCK) app inner join #VSAInstancesForVendor Ins
			ON app.instance = INS.instanceId
			inner join app_clientprop acpr
			on app.clientid = acpr.componentnameid and
			acpr.attrname = 'IndexingV2_VSA' and
			acpr.attrval = '1' and acpr.modified = 0
			WHERE appTypeId = 106 and
				  (subclientstatus = 0 or (subclientStatus & 0x8) = 0x8)
		END
-- if there was temporary table it means that this stored proc called from another one which will use whatever is in #VSAInstancesForVendor table
-- otherwise build xml message and select result set
IF @dropTempTable = 1
BEGIN
    DROP TABLE #VSAInstancesForVendor
END
SELECT @clientCount
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetVSIndexingVersionClientsForVendor')
	delete from GxQscripts where name = 'GetVSIndexingVersionClientsForVendor'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetVSIndexingVersionClientsForVendor')
	delete from GXDBVersions where aliasname = 'GetVSIndexingVersionClientsForVendor'
GO

insert into GXDBVersions values(2, 'GetVSIndexingVersionClientsForVendor',  '00000000000000000000', 'GetVSIndexingVersionClientsForVendor', '00000000000000000000')
GO

