

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetVSIndexingV1CientsForVendor.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: List all VSA clients for given hypervisor type with Indexing V1
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetVSIndexingV1CientsForVendor')
BEGIN
	print '>>> Drop Stored Procedure: GetVSIndexingV1CientsForVendor <<<'
	drop procedure GetVSIndexingV1CientsForVendor
END
IF EXISTS (select * from GxQscripts where name='GetVSIndexingV1CientsForVendor')
	delete from GxQscripts where name = 'GetVSIndexingV1CientsForVendor'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetVSIndexingV1CientsForVendor')
	delete from GXDBVersions where aliasname = 'GetVSIndexingV1CientsForVendor'
GO
print '... Creating Procedure: GetVSIndexingV1CientsForVendor'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetVSIndexingV1CientsForVendor
  @vendor INT
AS
  DECLARE @clientCount integer 
SET NOCOUNT ON
DECLARE @dropTempTable INT = 0
IF OBJECT_ID('tempdb.dbo.#VSAInstancesForVendor') IS NULL
BEGIN
    -- temporary table does not exist in execution context. create one
    CREATE TABLE #VSAInstancesForVendor (instanceId INT PRIMARY KEY)
    -- and set flag that indicates that it should be dropped
    SET @dropTempTable = 1
END
	SET @clientCount = 0
	--Map vendor to instance type and get existing instances
	IF @vendor = 1
	BEGIN
		--VMW
		Insert into #VSAInstancesForVendor
		SELECT componentNameId FROM App_InstanceProp(NOLOCK) WHERE attrName = 'Virtual Server Instance Type' and attrVal in ('100','101') and modified = 0
	END
	ELSE IF @vendor = 3
	BEGIN
		--Xen
		Insert into #VSAInstancesForVendor
		SELECT componentNameId FROM App_InstanceProp(NOLOCK) WHERE attrName = 'Virtual Server Instance Type' and attrVal in ('201','202') and modified = 0
	END
	ELSE
	BEGIN
		Insert into #VSAInstancesForVendor
		SELECT componentNameId FROM App_InstanceProp(NOLOCK) WHERE attrName = 'Virtual Server Instance Type' and modified = 0 and attrVal in
			(SELECT CASE @vendor
				WHEN 2 THEN '102'
				WHEN 4 THEN '301'
				WHEN 5 THEN '401'
				WHEN 6 THEN '501'
				WHEN 7 THEN '402'
				WHEN 8 THEN '1201'
				WHEN 9 THEN '601'
				WHEN 10 THEN '701'
				WHEN 11 THEN '1001'
				WHEN 12 THEN '901'
				WHEN 13 THEN '1101'
				WHEN 14 THEN '801'
				WHEN 15 THEN '103'
				WHEN 16 THEN '1301'
				WHEN 17 THEN '403'
				WHEN 18 THEN '1401'
				WHEN 19 THEN '1102'
				WHEN 20 THEN '1501'
				WHEN 21 THEN '1502'
				END)
	END
	SELECT @clientCount =  Count(*)  FROM app_application(NOLOCK) app inner join #VSAInstancesForVendor Ins
		ON app.instance = INS.instanceId
	left outer join app_clientprop acpr
		on app.clientid = acpr.componentnameid and
		acpr.attrname = 'IndexingV2_VSA' and
		acpr.attrval = '1' and acpr.modified = 0
	WHERE appTypeId = 106 and
		  (subclientstatus = 0 or (subclientStatus & 0x8) = 0x8) and
		  acpr.id is null
-- if there was temporary table it means that this stored proc called from another one which will use whatever is in #VSAInstancesForVendor table
-- otherwise build xml message and select result set
IF @dropTempTable = 1
BEGIN
    DROP TABLE #VSAInstancesForVendor
END
SELECT @clientCount
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetVSIndexingV1CientsForVendor')
	delete from GxQscripts where name = 'GetVSIndexingV1CientsForVendor'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetVSIndexingV1CientsForVendor')
	delete from GXDBVersions where aliasname = 'GetVSIndexingV1CientsForVendor'
GO

insert into GXDBVersions values(2, 'GetVSIndexingV1CientsForVendor',  '00000000000000000000', 'GetVSIndexingV1CientsForVendor', '00000000000000000000')
GO

