

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetV2CloudAppsPseudoClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +===========================================================================+
--  |               GetV2CloudAppsPseudoClients                                 |
--  |   Procedure to get v2CloudApps all Pseudo Clients               |
--  +===========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='GetV2CloudAppsPseudoClients')
BEGIN
	print '>>> Drop Stored Procedure: GetV2CloudAppsPseudoClients <<<'
	drop procedure GetV2CloudAppsPseudoClients
END
IF EXISTS (select * from GxQscripts where name='GetV2CloudAppsPseudoClients')
	delete from GxQscripts where name = 'GetV2CloudAppsPseudoClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetV2CloudAppsPseudoClients')
	delete from GXDBVersions where aliasname = 'GetV2CloudAppsPseudoClients'
GO
print '... Creating Procedure: GetV2CloudAppsPseudoClients'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure GetV2CloudAppsPseudoClients
-----------------------------------------------------------
---    PARAMETERS                                        ---
  @inXmlReq XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
    DECLARE @errorCode              INT = 0
    DECLARE @errorString            NVARCHAR(1024) = ''
    DECLARE @i_userId               INT = 0
	DECLARE @i_instanceType 		INT = 0
    DECLARE @OutXmlReq              XML = NULL
    IF OBJECT_ID('tempdb.dbo.#tmpOffice365ClientList') IS NOT NULL
        DROP TABLE #tmpOffice365ClientList
    CREATE TABLE #tmpOffice365ClientList (clientId INT , clientName NVARCHAR(MAX), instanceId INT)
    CREATE CLUSTERED INDEX #tmpOffice365ClientList_clientId_Idx1 ON #tmpOffice365ClientList (clientId)
    SET @i_userId = ISNULL((select @inXmlReq.value('(Ida_GetV2CloudAppsPseudoClientsReq/processinginstructioninfo/user[1]/@userId)[1]', 'INT')), 0)
    SET @i_instanceType =  ISNULL((select @inXmlReq.value('(Ida_GetV2CloudAppsPseudoClientsReq/@instanceType)[1]', 'INT')), 0)
    --Security
    IF OBJECT_ID('tempdb.dbo.#tempclientSecurityObjects') IS NOT Null DROP TABLE #tempclientSecurityObjects
    create table  #tempclientSecurityObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
    CREATE CLUSTERED INDEX #tempclientSecurityObjects_clientId_Idx1 ON #tempclientSecurityObjects (clientId)
EXEC sec_getIdaObjectsForUser @i_userId,3,0,0,'#tempclientSecurityObjects'
    INSERT INTO #tmpOffice365ClientList ( clientId, clientName, instanceId)
        SELECT C.id as clientId, C.displayName as clientName, SC.instance as instanceId
        FROM APP_Application (NOLOCK) SC
INNER JOIN APP_Client(NOLOCK) C ON C.id = SC.clientId AND (C.status & 0x00002 != 0x00002 /*UNINSTALLED*/ AND C.status &  0x00004 !=  0x00004 /*DELETE*/ AND C.status & 0x00020 != 0x00020 /*Hidden*/)
            INNER JOIN APP_InstanceProp (NOLOCK) IP ON SC.instance = IP.componentNameId AND IP.attrName = 'Cloud Apps Instance Type' AND attrType = 7 AND attrVal = @i_instanceType
            INNER JOIN  APP_ClientProp (NOLOCK) AC ON SC.clientId = AC.componentNameId AND AC.attrName = 'Office 365 Pseudo Client' AND AC.attrval = 1 AND AC.modified = 0
WHERE SC.appTypeId = 134
AND (SC.subclientStatus & 0x00002 != 0x00002 /*UNINSTALLED*/
AND SC.subclientStatus & 0x00004 != 0x00004 /*DELETE*/
AND SC.subclientStatus & 0x00020 != 0x00020 /*Hidden*/)
    IF @i_userId!=0
    BEGIN
        DELETE FROM  #tmpOffice365ClientList WHERE clientId NOT IN (SELECT clientId FROM #tempclientSecurityObjects)
    END
    SET @errorCode = @@ERROR
    IF @errorCode != 0
    BEGIN
        GOTO ERROR_EXIT
    END
    DECLARE @clientList table(clientId int, clientName nvarchar(256), instanceId int)
    INSERT INTO @clientList SELECT DISTINCT clientId, clientName, instanceId FROM #tmpOffice365ClientList
    SET @OutXmlReq = (
                        SELECT
                            (
                                SELECT   clientId as '@clientId', clientName as '@clientName', instanceId as '@instanceId'
                                FROM @clientList C
                            FOR XML PATH ('pseudoClients'), type
                            )
                    FOR XML PATH('Ida_GetV2CloudAppsPseudoClientsResp'))
ERROR_EXIT:
    IF @errorCode <> 0
        SET @OutXmlReq = (SELECT ISNULL(@errorCode,0) AS '@errorCode', ISNULL(@errorString,'')
                                AS '@errorMessage' FOR XML PATH('Ida_GetV2CloudAppsPseudoClientsResp'))
    IF @OutXmlReq IS NULL
        SET @OutXmlReq = '<Ida_GetV2CloudAppsPseudoClientsResp />'
    SELECT @OutXmlReq
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetV2CloudAppsPseudoClients')
	delete from GxQscripts where name = 'GetV2CloudAppsPseudoClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetV2CloudAppsPseudoClients')
	delete from GXDBVersions where aliasname = 'GetV2CloudAppsPseudoClients'
GO

insert into GXDBVersions values(2, 'GetV2CloudAppsPseudoClients',  '00000000000000000000', 'GetV2CloudAppsPseudoClients', '00000000000000000000')
GO

