

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetUserEntitiesForVmProvisioning.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetUserEntitiesForVmProvisioning')
BEGIN
	print '>>> Drop Stored Procedure: GetUserEntitiesForVmProvisioning <<<'
	drop procedure GetUserEntitiesForVmProvisioning
END
IF EXISTS (select * from GxQscripts where name='GetUserEntitiesForVmProvisioning')
	delete from GxQscripts where name = 'GetUserEntitiesForVmProvisioning'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetUserEntitiesForVmProvisioning')
	delete from GXDBVersions where aliasname = 'GetUserEntitiesForVmProvisioning'
GO
print '... Creating Procedure: GetUserEntitiesForVmProvisioning'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetUserEntitiesForVmProvisioning
  @xmlText XML
AS
SET NOCOUNT ON
DECLARE @errorCode INT =0
DECLARE @errorMessage nvarchar(MAX)
DECLARE @userId INT	= 0
DECLARE @localeId INT	= 0
DECLARE @localgroupIdTbl table (groupId integer,groupName nvarchar(max))
DECLARE @userIdTbl table (userId integer,userName nvarchar(max))
DECLARE @isRestrictedViewEnabled int = 0
DECLARE @canManageAllUsers INT =0
DECLARE @externalGroups TABLE( groupId integer,
																		groupName nvarchar(max))
SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS client
                            FROM    @xmlText.nodes('//App_GetUserEntitiesForVmProvisioningReq/processinginstructioninfo/user') R ( ref )),0)
SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS client
                            FROM    @xmlText.nodes('//App_GetUserEntitiesForVmProvisioningReq/processinginstructioninfo/locale') R ( ref )),0)
IF @userId = 0
BEGIN
	SET @errorCode = 1 -- Invalid input
	GOTO ENDSP
END
-- Return all users and user groups if the logged in user is admin/ if user has CC level user managemnet rights
-- Else list groups he belongs to and has user management rights.
-- return Peer users; User groups logged in user belongs to and user groups of Peer users
SET @isRestrictedViewEnabled =  ISNULL(CAST( (SELECT TOP (1) value FROM GXGlobalParam WHERE name = 'Restricted View Enabled' AND modified = 0) AS INT), 0)
--EXEC sec_canManageAllUsers @userId, @canManageAllUsers OUTPUT
IF OBJECT_ID('tempdb.dbo.#getUsersForThisUserTbl') IS NOT NULL
	DROP TABLE #getUsersForThisUserTbl
IF OBJECT_ID('tempdb.dbo.#getUserGroupsForThisUserTbl') IS NOT NULL
	DROP TABLE #getUserGroupsForThisUserTbl
IF OBJECT_ID('tempdb.dbo.#getUserExtGroupsForThisUserTbl') IS NOT NULL
	DROP TABLE #getUserExtGroupsForThisUserTbl
create table #getUsersForThisUserTbl (userId INT)
create table #getUserGroupsForThisUserTbl (userGrpId INT)
create table #getUserExtGroupsForThisUserTbl (extUserGrpId INT)
exec [sec_getUsersForThisUser] '#getUsersForThisUserTbl',@userId
exec [sec_getUserGroupsForThisUser] '#getUserGroupsForThisUserTbl',@userId,0,1
exec [sec_getUserGroupsForThisUser] '#getUserExtGroupsForThisUserTbl',@userId,0,2
INSERT INTO @userIdTbl
select userId,UM.login from #getUsersForThisUserTbl T INNER JOIN UMUsers UM ON T.userId=UM.id
INSERT INTO @localgroupIdTbl
select userGrpId,UG.name from #getUserGroupsForThisUserTbl T INNER JOIN UMGroups UG ON T.userGrpId=UG.id
INSERT INTO @externalGroups
select extUserGrpId,UD.name from #getUserExtGroupsForThisUserTbl T INNER JOIN UMDSGroups UD ON T.extUserGrpId=UD.id
IF OBJECT_ID('tempdb.dbo.#getUsersForThisUserTbl') IS NOT NULL
	DROP TABLE #getUsersForThisUserTbl
IF OBJECT_ID('tempdb.dbo.#getUserGroupsForThisUserTbl') IS NOT NULL
	DROP TABLE #getUserGroupsForThisUserTbl
IF OBJECT_ID('tempdb.dbo.#getUserExtGroupsForThisUserTbl') IS NOT NULL
	DROP TABLE #getUserExtGroupsForThisUserTbl
--IF @canManageAllUsers <> 0
--BEGIN
--	DECLARE @includeUsersFlags int = -1;
--	DECLARE @excludeUsersFlags int = 0;
--	SET @includeUsersFlags = ( CAST (0x001 AS INT) )
--	SET @excludeUsersFlags = ( CAST (0x200 AS INT) | CAST (0x004 AS INT) | CAST (0x080 AS INT) | CAST(0x100 AS INT) )
--	INSERT INTO @userIdTbl
--        SELECT UMUsers.id,UMUsers.login FROM UMUsers
--        WHERE (UMUsers.flags & @excludeUsersFlags = 0) AND (UMUsers.flags & @includeUsersFlags <> 0)
--        ORDER BY UMUsers.id
--	INSERT INTO @localgroupIdTbl
--    SELECT UMGroups.id, UMGroups.name
--    FROM UMGroups
--    WHERE ( (@isRestrictedViewEnabled <> 0 OR UMGroups.name <> 'CV_Restricted_Visibility')
--            AND UMGroups.name <> 'Common Outlook Add-Ins'
--        )
--    ORDER BY UMGroups.id
--	INSERT INTO @externalGroups
--	SELECT  DISTINCT  id,name
--	FROM         UMDSGroups
--	ORDER BY id
--	GOTO ENDSP
--END
--BEGIN
--		INSERT INTO @localgroupIdTbl
--		SELECT DISTINCT UMGroups.id , UMGroups.name
--    FROM UMGroups	INNER JOIN UMUserGroup ON UMGroups.id = UMUserGroup.groupId
--		INNER JOIN UMGroupCapability ON UMGroups.id = UMGroupCapability.groupId
--		WHERE  UMUserGroup.userId = @userId AND (UMGroupCapability.capabilityId = 14) AND
--		( (@isRestrictedViewEnabled <> 0 OR UMGroups.name <> 'CV_Restricted_Visibility')
--				AND UMGroups.name <> 'Common Outlook Add-Ins'
--			)
--		--Filter the ones associated to local groups that does not have user management capability.
--		DECLARE @externalAssociatedGroups TABLE ( localGroupId integer,
--																		localGroupName nvarchar(100),
--																		externalGroupId integer,
--																		externalGroupName nvarchar(100))
--		INSERT INTO @externalAssociatedGroups
--    SELECT  DISTINCT  UMGroups.id , UMGroups.name,UMDSUserGroup.groupId,UMDSGroups.name
--    FROM  UMDSUserGroup INNER JOIN UMDSGroupMaps ON UMDSUserGroup.groupId = UMDSGroupMaps.umDSgroupId
--												INNER JOIN UMDSGroups	ON UMDSGroupMaps.umDSgroupId = UMDSGroups.id
--												INNER JOIN UMGroups ON UMDSGroupMaps.umgroupId = UMGroups.id
--												INNER JOIN UMGroupCapability ON UMGroups.id = UMGroupCapability.groupId
--    WHERE     (UMDSUserGroup.userId = @userId) AND (UMGroupCapability.capabilityId = 14)
--		ORDER BY UMGroups.id
--		-- Copy to new tables for easy processing.
--		INSERT INTO @externalGroups
--		SELECT distinct externalGroupId,externalGroupName FROM @externalAssociatedGroups
--		--Include All associated local groups with external group
--		INSERT INTO @localgroupIdTbl
--		SELECT distinct localGroupId,localGroupName FROM @externalAssociatedGroups
--		-- Get Users of all the above local groups and external groups
--		-- Local group associated with local group is already in the list;so external users will alos be added to this list.
--		INSERT INTO @userIdTbl
--		SELECT DISTINCT U.id,U.login
--		FROM UMUserGroup UMUG,UMUsers U
--		WHERE UMUG.groupId in (select DISTINCT groupId FROM @localgroupIdTbl)
--		and UMUG.userId = U.id
--		UNION
--		SELECT DISTINCT U.id,U.login
--		FROM UMDSUserGroup UMDSUG,UMUsers U
--		WHERE UMDSUG.groupId in (select DISTINCT groupId FROM @externalGroups)
--		and UMDSUG.userId = U.id
--		-- External group
--		IF NOT EXISTS (SELECT * FROM @userIdTbl WHERE userId = @userId)
--			INSERT	INTO @userIdTbl
--			SELECT	UMUsers.id,UMUsers.login FROM UMUsers
--			WHERE	UMUSers.id = @userId
--END
--FRAME LOCALISED ERROR MESSAGE
ENDSP:
IF @errorCode <> 0
BEGIN
	IF @errorCode = 1
	BEGIN
SET @errorMessage = (select message from EvLocaleMsgs Where messageId=(12 | (CAST(POWER(2, 24) AS BIGINT) * 35))  AND [localeId] = @localeId)
	END
	ELSE IF @errorCode = 2
    BEGIN
SET @errorMessage = (select message from EvLocaleMsgs Where messageId=(1936 | (CAST(POWER(2, 24) AS BIGINT) * 35))  AND [localeId] = @localeId)
        SET @errorMessage = REPLACE(@errorMessage, '^1%s', (SELECT login from UMUSERS where id = @userId))
        SET @errorMessage = REPLACE(@errorMessage, '^2%s',
            dbo.fn_EvFormatEventMsgText(0,@localeId,
IsNull((Select tokenId from UMCapability where id = 14),
                    (Select tokenId from UMCapability where id = 31)),
            0,2))
    END
END
-- FRAME OUTPUT
SET @xmlText = (SELECT @errorCode as '@errorCode',
						@errorMessage as '@errorMessage',
						(SELECT DISTINCT
						userId as '@userId',
						userName as '@userName'
						FROM @userIdTbl
						FOR XML PATH('users'),TYPE),
						(SELECT DISTINCT
						groupId as '@userGroupId',
						groupName as '@userGroupName'
						FROM @localgroupIdTbl
						FOR XML PATH('userGroups'),TYPE),
						(SELECT DISTINCT
						groupId as '@groupId',
						groupName as '@externalGroupName'
						FROM @externalGroups
						FOR XML PATH('externalUserGroups'),TYPE)
				FOR XML PATH('App_GetUserEntitiesForVmProvisioningResp'),TYPE)
SELECT @xmlText
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'GetUserEntitiesForVmProvisioning')
	delete from GxQscripts where name = 'GetUserEntitiesForVmProvisioning'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetUserEntitiesForVmProvisioning')
	delete from GXDBVersions where aliasname = 'GetUserEntitiesForVmProvisioning'
GO

insert into GXDBVersions values(2, 'GetUserEntitiesForVmProvisioning',  '00000000000000000000', 'GetUserEntitiesForVmProvisioning', '00000000000000000000')
GO

