

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetUserDetails.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  GetUserDetails()
--  | Description:  Get user information given username
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetUserDetails.sp,v $ $Id: GetUserDetails.sp,v 1.8.2.3 2018/03/22 03:12:57 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetUserDetails <<<'

IF EXISTS (select * from sysobjects where name='GetUserDetails')
	drop procedure GetUserDetails
IF EXISTS (select * from GxQscripts where name='GetUserDetails')
	delete from GxQscripts where name = 'GetUserDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetUserDetails')
	delete from GXDBVersions where aliasname = 'GetUserDetails'
GO
print '... Creating Procedure: GetUserDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetUserDetails
  @i_xmlText XML
AS
  DECLARE @o_ErrorCode integer=0
  DECLARE @o_ErrorString NVARCHAR(1024)
  DECLARE @o_xmlText XML	
	SET NOCOUNT ON
BEGIN
	DECLARE @i_userName		NVARCHAR(1024)
	DECLARE @i_clientId		INT
	SET @o_ErrorCode = 0
	SET @o_xmlText = '<App_GetUserDetailResp />'
	SET @i_userName = ISNULL(( SELECT ref.value('@userName', 'nvarchar(1024)')
						FROM @i_xmlText.nodes('App_GetUserDetailReq/user') R ( ref ) ), '')
	SET @i_clientId = ISNULL(( SELECT ref.value('@clientId', 'int')
						FROM @i_xmlText.nodes('App_GetUserDetailReq/client') R ( ref ) ), 0)
	IF LEN(@i_userName) = 0
	BEGIN
			SET @o_ErrorCode = 1
			SET @o_ErrorString = 'User Name is empty'
			GOTO EXIT_PROC
	END
	IF @i_clientId = 0
	BEGIN
			SET @o_ErrorCode = 2
			SET @o_ErrorString = 'Client Id Not Found'
			GOTO EXIT_PROC
	END
	BEGIN TRY
	DECLARE @userId INT = ISNULL((SELECT id FROM UMUSERS WITH(NOLOCK) WHERE login = @i_userName OR email = @i_userName),0)
	END TRY
	BEGIN CATCH
		SET @o_ErrorCode = 4
		SET @o_ErrorString = 'Duplicate users found for username ' + @i_userName
		GOTO EXIT_PROC
	END CATCH
	IF @userId =0
	BEGIN
		SET @o_ErrorCode = 3
		SET @o_ErrorString = 'UserId not found for username ' + @i_userName
		GOTO EXIT_PROC
	END
	EXEC sec_updateUserCredentials @userId, 1
	DECLARE @capabilities BIGINT = 0
	IF object_id('tempdb.dbo.#GetUserDetails_userObjects') is not null 		DROP TABLE #GetUserDetails_userObjects
create table  #GetUserDetails_userObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @userId,2013,0,'#GetUserDetails_userObjects'
	SELECT @capabilities = @capabilities | capabilities
	FROM #GetUserDetails_userObjects
	WHERE (clientId = @i_clientId) OR (commCellId = 2 AND clientGroupId = 0 AND appTypeId=0 AND backupsetId=0 AND archGroupId=0
			AND clientId=0 AND complianceReportId=0 AND cdPolicyId=0 AND downloadSetId=0
			AND ermId=0 AND instanceId=0 AND legalHoldId=0 AND libraryId=0 AND mediaAgentId=0
			AND querySetId=0 AND reviewSetId=0 AND subClientId=0 AND tagId=0
			AND vtContainerId=0 AND vtPolicyId=0 AND vtShelfId=0 AND taskId=0 AND workflowId=0
			AND logMonitoringPolicyId=0 AND arrayId=0 AND cloudId=0 AND userGroupId=0
			AND providerId=0 AND entityId1=0 AND entityId2=0 AND entityId3=0 AND entityId4=0
			AND entityId5=0 AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0)
	IF object_id('tempdb.dbo.#GetUserDetails_userObjects') is not null 		DROP TABLE #GetUserDetails_userObjects
	SET @o_xmlText =
	(
		SELECT @capabilities '@capabilities',
				(
					SELECT @userId '@userId',
						   @i_userName '@userName'
					FOR XML PATH ('user'), TYPE
				)
		FOR XML PATH ('App_GetUserDetailResp'), TYPE
	)
EXIT_PROC:
	IF @o_ErrorCode > 0
	BEGIN
		SET @o_xmlText =
		(
			SELECT @o_ErrorCode '@errorCode',
					@o_ErrorString '@errorMessage'
			FOR XML PATH ('error'), ROOT('App_GetUserDetailResp')
		)
	END
	SELECT @o_xmlText
END
SET NOCOUNT ON
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'GetUserDetails')
	delete from GxQscripts where name = 'GetUserDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetUserDetails')
	delete from GXDBVersions where aliasname = 'GetUserDetails'
GO

insert into GXDBVersions values(2, 'GetUserDetails',  '00010008000200030000', 'GetUserDetails', '00010008000200030000')
GO

