

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetUserCapabilities.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetUserCapabilities.sp,v $ $Id: GetUserCapabilities.sp,v 1.5.44.3 2020/11/19 09:43:10 jswaminathan Exp $";
-- =============================================
-- Author:		Ashish Gupta
-- Creation date: 02/09/2010
-- Description:	returns bitmask of all the capabilities for a user
-- =============================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='GetUserCapabilities')
BEGIN
	print '>>> Drop Stored Procedure: GetUserCapabilities <<<'
	drop procedure GetUserCapabilities
END
IF EXISTS (select * from GxQscripts where name='GetUserCapabilities')
	delete from GxQscripts where name = 'GetUserCapabilities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetUserCapabilities')
	delete from GXDBVersions where aliasname = 'GetUserCapabilities'
GO
print '... Creating Procedure: GetUserCapabilities'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure GetUserCapabilities
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId integer = 0,
  @i_userGuid varchar(36) = ''
AS
SET NOCOUNT ON
  DECLARE @capBitMask bigint = 0
IF object_id('tempdb.dbo.#GetUserCapabilities_userObjects') is not null
   DROP TABLE #GetUserCapabilities_userObjects
create table  #GetUserCapabilities_userObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
IF ( @i_userGUID IS NOT null AND @i_userGUID <> '' )
BEGIN
	SET @i_userId = ( SELECT id FROM UMUsers WHERE userGuid = @i_userGUID )
END
IF (@i_userId IS NOT null AND @i_userId <> 0)
BEGIN
        EXEC sec_getUserObjects @i_userId, 0 , 0 , '#GetUserCapabilities_userObjects'
		SELECT @capBitMask = @capBitmask | capabilities
		FROM #GetUserCapabilities_userObjects
END
SELECT @capBitMask as CapBitMask
IF object_id('tempdb.dbo.#GetUserCapabilities_userObjects') is not null
   DROP TABLE #GetUserCapabilities_userObjects
GO

IF EXISTS (select * from GxQscripts where name = 'GetUserCapabilities')
	delete from GxQscripts where name = 'GetUserCapabilities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetUserCapabilities')
	delete from GXDBVersions where aliasname = 'GetUserCapabilities'
GO

insert into GXDBVersions values(2, 'GetUserCapabilities',  '00010005004400030000', 'GetUserCapabilities', '00010005004400030000')
GO

