

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetUpdateOSTypesFromClientList.sp] ---------- 

--  +========================================================================+
--  | Stored Proc:  GetUpdateOSTypesFromClientList
--  | SP to get the update os typ list for the client list
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetUpdateOSTypesFromClientList <<<'

IF EXISTS (select * from sysobjects where name='GetUpdateOSTypesFromClientList')
	drop procedure GetUpdateOSTypesFromClientList
IF EXISTS (select * from GxQscripts where name='GetUpdateOSTypesFromClientList')
	delete from GxQscripts where name = 'GetUpdateOSTypesFromClientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetUpdateOSTypesFromClientList')
	delete from GXDBVersions where aliasname = 'GetUpdateOSTypesFromClientList'
GO
print '... Creating Procedure: GetUpdateOSTypesFromClientList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetUpdateOSTypesFromClientList
  @inClientIdList VARCHAR(MAX)
AS
  DECLARE @oRelease integer
  DECLARE @oOSType integer
SET NOCOUNT ON
IF object_id('tempdb.dbo.#AU_Temp') IS NOT null DROP TABLE #AU_Temp
IF object_id('tempdb.dbo.#AU_ClientsRelAndOS') IS NOT null DROP TABLE #AU_ClientsRelAndOS
 CREATE TABLE #AU_Temp
 (
   TmpID	INTEGER
 )
  CREATE TABLE #AU_ClientsRelAndOS
 (
   clientId	INTEGER,
   releaseId	INTEGER,
   binarySet	INTEGER,
   updateOsId	INTEGER
 )
 IF @inClientIdList <> '0'
	BEGIN
		INSERT INTO #AU_Temp
	      SELECT  * FROM dbo.SplitIDs(@inClientIdList)
	END
--Get all clientid's from siminstalledpackages instead of app_client table when clientid is passed as zero from commandline
 ELSE
	BEGIN
		INSERT INTO #AU_Temp
	      SELECT  Distinct clientid from siminstalledpackages
		 DECLARE @doNotConsiderDeconfCl INT = ISNULL((SELECT CAST(value AS INT) FROM GXGlobalParam WHERE name = 'IgnoreDeconfigClientsForPatchDownload' AND modified = 0), 0)
		 IF @doNotConsiderDeconfCl <> 0
		 BEGIN
DELETE FROM #AU_TEMP where TmpID IN(Select id from APP_client where status & 0x00002 = 0x00002)
		 END
	END
--Get the Required client list
INSERT INTO #AU_ClientsRelAndOS SELECT id,releaseId,0,0 from APP_Client WHERE id In (SELECT TmpID FROM #AU_Temp)
--since we are getting clientid's from siminstalledpackages table we dont have to handle the virtual clients.
-- MR: 79488
-- on cluster CS (without having any other clients in commcell), due to following delete call all rows would get deleted.
-- so, no updates would be downloaded. So, add explicit check to not delete commserve specific row
--Delete all virtual clients
--DELETE FROM #AU_ClientsRelAndOS WHERE clientId In ( SELECT distinct componentNameId FROM APP_ClientProp WHERE attrName like 'Virtual Client' and attrVal != '0' and componentNameId != '2')
--update the binary set Id
UPDATE #AU_ClientsRelAndOS SET binarySet=(select CONVERT(INT,attrVal) from APP_ClientProp where attrName like 'Binary Set ID' and componentNameId = clientId)
--update the updateOsId
UPDATE #AU_ClientsRelAndOS SET updateOsId=(select UpdateOSID from PatchUpdateOS where BinarySetID=binarySet) WHERE releaseId <= 14
UPDATE #AU_ClientsRelAndOS SET updateOsId=(select NewUpdateOSID from PatchUpdateOS  where BinarySetID=binarySet) WHERE releaseId > 14
--add both win32 and winx64 for 1 Touch Servers
INSERT INTO #AU_ClientsRelAndOS SELECT clientId,releaseId,1,1 from #AU_ClientsRelAndOS WHERE clientId In(SELECT distinct clientId from simInstalledPackages where simPackageID=554) AND (releaseId = 14 or releaseId = 15)
INSERT INTO #AU_ClientsRelAndOS SELECT clientId,releaseId,3,3 from #AU_ClientsRelAndOS WHERE clientId In(SELECT distinct clientId from simInstalledPackages where simPackageID=554) AND (releaseId = 14 or releaseId = 15)
SET NOCOUNT OFF
SELECT DISTINCT releaseId,updateOsId FROM #AU_ClientsRelAndOS
DROP TABLE #AU_Temp
DROP TABLE #AU_ClientsRelAndOS
GO

IF EXISTS (select * from GxQscripts where name = 'GetUpdateOSTypesFromClientList')
	delete from GxQscripts where name = 'GetUpdateOSTypesFromClientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetUpdateOSTypesFromClientList')
	delete from GXDBVersions where aliasname = 'GetUpdateOSTypesFromClientList'
GO

insert into GXDBVersions values(2, 'GetUpdateOSTypesFromClientList',  '00000000000000000000', 'GetUpdateOSTypesFromClientList', '00000000000000000000')
GO

